/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.maf.MAFParser;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFUtils;
import org.broad.igv.maf.MultipleAlignmentBlock;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;

public class MAFListReader
implements MAFReader {
    private static Logger log = LogManager.getLogger(MAFListReader.class);
    List<String> chrNames;
    private String refId;
    private List<String> species;
    private Map<String, String> speciesNames;
    Map<String, String> filenameMap;
    Map<String, MAFParser> readerMap;

    public MAFListReader(String mappingFile) throws IOException {
        this.loadDictionaryFile(mappingFile);
        this.loadSpeciesNames(mappingFile);
        this.readerMap = new HashMap<String, MAFParser>();
    }

    @Override
    public String getRefId() {
        return this.refId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDictionaryFile(String mappingFile) throws IOException {
        this.chrNames = new ArrayList<String>();
        this.filenameMap = new HashMap<String, String>();
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(mappingFile);
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                if (tokens.length != 2) {
                    log.info("Skipping line: " + nextLine);
                    continue;
                }
                String chr = tokens[0];
                String fname = tokens[1];
                String fullPath = FileUtils.getAbsolutePath(fname, mappingFile);
                this.filenameMap.put(chr, fullPath);
                this.chrNames.add(chr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSpeciesNames(String path) {
        InputStream is = null;
        this.species = new ArrayList<String>();
        this.speciesNames = new LinkedHashMap<String, String>();
        try {
            String nextLine;
            String speciesPath = path + ".species";
            is = FileUtils.resourceExists(speciesPath) ? ParsingUtils.openInputStream(speciesPath) : MAFUtils.class.getResourceAsStream("species.properties");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((nextLine = br.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#ref")) {
                    tokens = Globals.equalPattern.split(nextLine);
                    this.refId = tokens[1];
                    continue;
                }
                tokens = Globals.equalPattern.split(nextLine);
                if (tokens.length != 2) continue;
                String id = tokens[0];
                String name = tokens[1];
                this.species.add(id);
                this.speciesNames.put(id, name);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public List<MultipleAlignmentBlock> loadAlignments(String chr, int start, int end) throws IOException {
        MAFParser reader = this.getReader(chr);
        return reader == null ? null : reader.loadAlignments(chr, start, end);
    }

    private MAFParser getReader(String chr) {
        MAFParser reader = this.readerMap.get(chr);
        if (reader == null) {
            String path = this.filenameMap.get(chr);
            if (path == null) {
                log.info("No MAF file found for chromosome: " + chr);
            } else {
                try {
                    reader = new MAFParser(path);
                    this.readerMap.put(chr, reader);
                }
                catch (Exception e) {
                    log.error("Error loading MAF reader (" + path + "):  ", e);
                    MessageUtils.showMessage("Error loading MAF file: " + e.getMessage());
                }
            }
        }
        return reader;
    }

    public List<String> getChrNames() {
        return this.chrNames;
    }

    @Override
    public String getSpeciesName(String speciesId) {
        if (this.speciesNames != null && this.speciesNames.containsKey(speciesId)) {
            return this.speciesNames.get(speciesId);
        }
        return speciesId;
    }

    @Override
    public Collection<String> getSpecies() {
        return this.species;
    }
}

