/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.goby;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;
import org.campagnelab.goby.counts.CachingCountsArchiveReader;
import org.campagnelab.goby.counts.CountBinningAdaptor;
import org.campagnelab.goby.counts.CountsReader;
import org.campagnelab.goby.counts.CountsReaderI;

public class GobyCountArchiveDataSource
implements CoverageDataSource {
    static final Logger LOG = LogManager.getLogger(TDFReader.class);
    CachingCountsArchiveReader counts;
    private double currentMax = 4.0;
    private String filename;
    private boolean someIdsStartWithChr;
    private ObjectSet<String> ids;
    private WindowFunction selectedWindowFunction;
    long numBasesSeen;
    long numSitesSeen;
    private boolean hasPrecomputedStats;
    private boolean doNormalize;
    private double normalizationFactor;
    static List<WindowFunction> availableFunctions = Arrays.asList(WindowFunction.mean, WindowFunction.max);

    public GobyCountArchiveDataSource(ResourceLocator locator) {
        this.init(locator.getPath());
    }

    private void init(String filename) {
        try {
            this.filename = FilenameUtils.removeExtension((String)filename);
            this.counts = new CachingCountsArchiveReader(this.filename);
            this.ids = this.counts.getIdentifiers();
            for (String id : this.ids) {
                if (!id.startsWith("chr")) continue;
                this.someIdsStartWithChr = true;
                break;
            }
            if (this.counts.isStatsParsed()) {
                this.numBasesSeen = this.counts.getTotalBasesSeen();
                this.numSitesSeen = this.counts.getTotalSitesSeen();
                this.hasPrecomputedStats = true;
            }
            boolean normalizeCounts = PreferencesManager.getPreferences().getAsBoolean("NORMALIZE_COVERAGE");
            this.setNormalize(normalizeCounts);
        }
        catch (IOException ex) {
            LOG.error("Error loading file: " + filename, ex);
            throw new DataLoadException("Error loading goby counts archive file: " + ex.toString(), filename);
        }
    }

    public GobyCountArchiveDataSource(File file) {
        this.init(file.getPath());
    }

    @Override
    public double getDataMax() {
        return this.currentMax;
    }

    @Override
    public double getDataMin() {
        boolean normalizeCounts = PreferencesManager.getPreferences().getAsBoolean("NORMALIZE_COVERAGE");
        this.setNormalize(normalizeCounts);
        return 0.0;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        if ("All".equals(chr)) {
            return new Vector<LocusScore>();
        }
        try {
            this.currentMax = 0.0;
            CountsReader reader = this.getCountsReader(chr);
            int initialStartPosition = startLocation;
            int binSize = this.getBinSize(startLocation, endLocation);
            if (reader == null) {
                return null;
            }
            this.updateNormalizationFactor();
            CountBinningAdaptor binAdaptor = new CountBinningAdaptor((CountsReaderI)reader, binSize);
            if (this.counts.hasIndex()) {
                binAdaptor.reposition(startLocation);
            }
            binAdaptor.skipTo(startLocation);
            int position = binAdaptor.getPosition();
            ObjectArrayList result = new ObjectArrayList();
            result.add((Object)new BasicScore(initialStartPosition, position, 0.0f));
            while (binAdaptor.hasNextTransition() && position < endLocation) {
                binAdaptor.nextTransition();
                position = binAdaptor.getPosition();
                double count = this.selectedWindowFunction == WindowFunction.mean ? binAdaptor.getAverage() : (double)binAdaptor.getMax();
                double normalizedCount = count / this.normalizationFactor;
                int length = binAdaptor.getLength();
                BasicScore bs = new BasicScore(position, position + length, (float)normalizedCount);
                result.add((Object)bs);
                this.currentMax = Math.max(this.currentMax, normalizedCount);
                if (this.hasPrecomputedStats) continue;
                this.numBasesSeen = (long)((double)this.numBasesSeen + (double)length * count);
                if (count == 0.0) continue;
                this.numSitesSeen += (long)length;
            }
            result.add((Object)new BasicScore(position, endLocation, 0.0f));
            return result;
        }
        catch (IOException e) {
            LOG.error(e);
            throw new DataLoadException(String.format("Error getting summary scores for range %s:%d-%d in goby counts archive file %s %n", chr, startLocation, endLocation, this.filename), this.filename);
        }
    }

    private int getBinSize(int startLocation, int endLocation) {
        int regionLength = endLocation - startLocation;
        return Math.max(1, regionLength / 2000);
    }

    private void updateNormalizationFactor() {
        this.normalizationFactor = this.numSitesSeen == 0L ? 1.0 : (this.doNormalize ? (double)this.numBasesSeen / (double)this.numSitesSeen / 2.0 : 1.0);
    }

    private CountsReader getCountsReader(String chr) throws IOException {
        CountsReader reader;
        if (this.ids.contains((Object)chr)) {
            return this.counts.getCountReader(chr);
        }
        if (!this.someIdsStartWithChr && (reader = this.counts.getCountReader(chr.replaceFirst("chr", ""))) != null) {
            return reader;
        }
        return this.counts.getCountReader(chr);
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.COVERAGE;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.selectedWindowFunction = statType;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.selectedWindowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return availableFunctions;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getPath() {
        return this.filename;
    }

    @Override
    public void setNormalize(boolean normalize) {
        this.doNormalize = normalize;
    }

    @Override
    public boolean getNormalize() {
        return this.doNormalize;
    }
}

