/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.ChromosomeComparator;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.InMemorySequence;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.SequenceWrapper;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class Genome {
    private static Logger log = LogManager.getLogger(Genome.class);
    public static final int MAX_WHOLE_GENOME_LONG = 100;
    private static Object aliasLock = new Object();
    private String id;
    private String displayName;
    private List<String> chromosomeNames;
    private List<String> longChromosomeNames;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private long totalLength = -1L;
    private long nominalLength = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    private Map<String, String> chrAliasTable;
    private Sequence sequence;
    private FeatureTrack geneTrack;
    private String species;
    private String ucscID;
    private String blatDB;
    private ArrayList<ResourceLocator> annotationResources;
    private boolean showWholeGenomeView = true;
    private static Map<String, String> ucscSpeciesMap;
    private static Map<String, String> ucsdIDMap;
    public static Genome mockGenome;

    public Genome(String id, String displayName, Sequence sequence, boolean chromosOrdered) {
        this.id = id;
        this.displayName = displayName;
        this.chrAliasTable = new HashMap<String, String>();
        this.sequence = sequence instanceof InMemorySequence ? sequence : new SequenceWrapper(sequence);
        this.chromosomeNames = sequence.getChromosomeNames();
        this.ucscID = ucsdIDMap.containsKey(id) ? ucsdIDMap.get(id) : id;
        ArrayList<Chromosome> tmpChromos = new ArrayList<Chromosome>(this.chromosomeNames.size());
        int maxLength = -1;
        this.chromosomeMap = new LinkedHashMap(tmpChromos.size());
        for (int i = 0; i < this.chromosomeNames.size(); ++i) {
            String chr = this.chromosomeNames.get(i);
            int length = sequence.getChromosomeLength(chr);
            maxLength = Math.max(maxLength, length);
            Chromosome chromo = new Chromosome(i, chr, length);
            tmpChromos.add(chromo);
            if (!chromosOrdered) continue;
            this.chromosomeMap.put(chr, chromo);
        }
        if (!chromosOrdered) {
            ChromosomeComparator.sortChromosomeList(tmpChromos, maxLength / 10, this.chromosomeMap);
            this.chromosomeNames = new ArrayList<String>(this.chromosomeMap.keySet());
        }
        this.initializeChromosomeAliases();
    }

    public Genome(String id, List<Chromosome> chromosomes) {
        this.id = id;
        this.displayName = id;
        this.chrAliasTable = new HashMap<String, String>();
        this.sequence = null;
        this.chromosomeNames = new ArrayList<String>(chromosomes.size());
        this.chromosomeMap = new LinkedHashMap(chromosomes.size());
        for (Chromosome chromosome : chromosomes) {
            this.chromosomeNames.add(chromosome.getName());
            this.chromosomeMap.put(chromosome.getName(), chromosome);
        }
        this.initializeChromosomeAliases();
    }

    public String getCanonicalChrName(String str) {
        if (str == null) {
            return str;
        }
        if (this.chrAliasTable.containsKey(str)) {
            return this.chrAliasTable.get(str);
        }
        return str;
    }

    public boolean isKnownChr(String str) {
        return this.chrAliasTable.containsKey(str);
    }

    public void addChrAliases(Collection<Collection<String>> synonymsList) {
        if (synonymsList == null) {
            return;
        }
        if (this.chrAliasTable == null) {
            this.chrAliasTable = new HashMap<String, String>();
        }
        HashSet<String> chrNameSet = new HashSet<String>(this.chromosomeNames);
        for (Collection<String> synonyms : synonymsList) {
            String chr = null;
            for (String syn : synonyms) {
                if (!chrNameSet.contains(syn)) continue;
                chr = syn;
                break;
            }
            if (chr == null) continue;
            for (String syn : synonyms) {
                this.chrAliasTable.put(syn, chr);
            }
        }
    }

    void initializeChromosomeAliases() {
        this.chrAliasTable.putAll(this.getAutoAliases());
    }

    Map<String, String> getAutoAliases() {
        HashMap<String, String> autoAliases = new HashMap<String, String>();
        for (String string : this.chromosomeNames) {
            autoAliases.put(string, string);
        }
        for (String string : this.chromosomeNames) {
            if (!string.startsWith("gi|")) continue;
            String alias = Genome.getNCBIName(string);
            autoAliases.put(alias, string);
            int n = alias.lastIndexOf(46);
            if (n <= 0) continue;
            alias = alias.substring(0, n);
            autoAliases.put(alias, string);
        }
        int count = 0;
        for (String name : this.chromosomeNames) {
            if (name.toLowerCase().startsWith("chr")) {
                autoAliases.put(name.substring(3), name);
            } else {
                autoAliases.put("chr" + name, name);
            }
            if (count++ != 50) continue;
            break;
        }
        if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
            autoAliases.put("23", "chrX");
            autoAliases.put("24", "chrY");
            autoAliases.put("MT", "chrM");
        } else if (this.id.startsWith("mm") || this.id.startsWith("rheMac")) {
            autoAliases.put("21", "chrX");
            autoAliases.put("22", "chrY");
            autoAliases.put("MT", "chrM");
        } else if (this.id.equals("b37")) {
            autoAliases.put("chrM", "MT");
            autoAliases.put("chrX", "23");
            autoAliases.put("chrY", "24");
        }
        ArrayList arrayList = new ArrayList(autoAliases.entrySet());
        for (Map.Entry entry : arrayList) {
            String illuminaName;
            String alias = (String)entry.getKey();
            String chr = (String)entry.getValue();
            if (!alias.endsWith(".fa")) {
                illuminaName = alias + ".fa";
                autoAliases.put(illuminaName, chr);
            }
            if (chr.endsWith(".fa")) continue;
            illuminaName = chr + ".fa";
            autoAliases.put(illuminaName, chr);
        }
        return autoAliases;
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    public String getHomeChromosome() {
        if (!this.showWholeGenomeView || this.chromosomeNames.size() == 1 || this.getLongChromosomeNames().size() > 100) {
            return this.chromosomeNames.get(0);
        }
        return "All";
    }

    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(this.getCanonicalChrName(chrName));
    }

    public List<String> getAllChromosomeNames() {
        return this.chromosomeNames;
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getTotalLength() {
        if (this.totalLength < 0L) {
            this.totalLength = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.totalLength += (long)chr.getLength();
            }
        }
        return this.totalLength;
    }

    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getLongChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        List<String> wgChrNames = this.getLongChromosomeNames();
        for (String c : wgChrNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = wgChrNames.get(wgChrNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    public String getId() {
        return this.id;
    }

    public String getBlatDB() {
        return this.blatDB != null ? this.blatDB : this.id;
    }

    public void setBlatDB(String blatDB) {
        this.blatDB = blatDB;
    }

    public void setUcscID(String ucscID) {
        this.ucscID = ucscID;
    }

    public String getUCSCId() {
        return this.ucscID == null ? this.id : this.ucscID;
    }

    public String getSpecies() {
        if (this.species == null) {
            this.species = Genome.getSpeciesForID(this.getUCSCId());
        }
        return this.species;
    }

    public String getNextChrName(String chr) {
        List<String> chrList = this.getAllChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    public String getPrevChrName(String chr) {
        List<String> chrList = this.getAllChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    public byte[] getSequence(String chr, int start, int end) {
        return this.getSequence(chr, start, end, true);
    }

    public byte[] getSequence(String chr, int start, int end, boolean useCache) {
        if (this.sequence == null) {
            return null;
        }
        Chromosome c = this.getChromosome(chr);
        if (c == null) {
            return null;
        }
        if ((end = Math.min(end, c.getLength())) <= start) {
            return null;
        }
        return this.sequence.getSequence(chr, start, end, useCache);
    }

    public boolean sequenceIsRemote() {
        return this.sequence.isRemote();
    }

    public boolean sequenceIsFasta() {
        return this.sequence.isFasta();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public byte getReference(String chr, int pos) {
        return this.sequence == null ? null : Byte.valueOf(this.sequence.getBase(chr, pos));
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> chrCytoMap) {
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            List<Cytoband> cytobands = entry.getValue();
            Chromosome chromosome = this.chromosomeMap.get(chr);
            if (chromosome == null) continue;
            chromosome.setCytobands(cytobands);
        }
    }

    public void setGeneTrack(FeatureTrack geneFeatureTrack) {
        this.geneTrack = geneFeatureTrack;
    }

    public FeatureTrack getGeneTrack() {
        return this.geneTrack;
    }

    public List<String> getLongChromosomeNames() {
        block6: {
            if (this.longChromosomeNames != null) break block6;
            this.longChromosomeNames = new ArrayList<String>();
            if (this.chromosomeMap.size() < 100) {
                double[] lengths = new double[this.chromosomeMap.size()];
                int idx = 0;
                for (Chromosome c : this.chromosomeMap.values()) {
                    lengths[idx++] = c.getLength();
                }
                double mean = StatUtils.mean((double[])lengths);
                double std = Math.sqrt(StatUtils.variance((double[])lengths));
                double min = 0.1 * mean;
                for (String chr : this.getAllChromosomeNames()) {
                    if (!((double)this.chromosomeMap.get(chr).getLength() > min)) continue;
                    this.longChromosomeNames.add(chr);
                }
            } else {
                ArrayList<Chromosome> allChromosomes = new ArrayList<Chromosome>(this.chromosomeMap.values());
                allChromosomes.sort((c1, c2) -> c2.getLength() - c1.getLength());
                Chromosome lastChromosome = null;
                HashSet<String> tmp = new HashSet<String>();
                for (Chromosome c : allChromosomes) {
                    double delta;
                    if (lastChromosome != null && (delta = (double)(lastChromosome.getLength() - c.getLength())) / (double)lastChromosome.getLength() > 0.7) break;
                    tmp.add(c.getName());
                    lastChromosome = c;
                }
                for (String chr : this.getAllChromosomeNames()) {
                    if (!tmp.contains(chr)) continue;
                    this.longChromosomeNames.add(chr);
                }
            }
        }
        return this.longChromosomeNames;
    }

    public long getNominalLength() {
        if (this.nominalLength < 0L) {
            this.nominalLength = 0L;
            for (String chrName : this.getLongChromosomeNames()) {
                Chromosome chr = this.getChromosome(chrName);
                this.nominalLength += (long)chr.getLength();
            }
        }
        return this.nominalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getSpeciesForID(String id) {
        if (ucscSpeciesMap == null) {
            ucscSpeciesMap = new HashMap<String, String>();
            InputStream is = null;
            try {
                String nextLine;
                is = Genome.class.getResourceAsStream("speciesMapping.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((nextLine = br.readLine()) != null) {
                    if (nextLine.startsWith("#")) continue;
                    String[] tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length == 2) {
                        ucscSpeciesMap.put(tokens[0].trim(), tokens[1].trim());
                        continue;
                    }
                    log.error("Unexpected number of tokens in species mapping file for line: " + nextLine);
                }
            }
            catch (IOException e) {
                log.error("Error reading species mapping table", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("", e);
                    }
                }
            }
        }
        for (Map.Entry<String, String> entry : ucscSpeciesMap.entrySet()) {
            if (!id.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean sequenceIsLoaded(ReferenceFrame frame) {
        return this.sequence.isLoaded(frame);
    }

    public void setAnnotationResources(ArrayList<ResourceLocator> annotationResources) {
        this.annotationResources = annotationResources;
    }

    public ArrayList<ResourceLocator> getAnnotationResources() {
        return this.annotationResources;
    }

    private Genome(String id) {
        this.id = id;
    }

    public void setShowWholeGenomeView(boolean showWholeGenomeView) {
        this.showWholeGenomeView = showWholeGenomeView;
    }

    public boolean getShowWholeGenomeView() {
        return this.showWholeGenomeView;
    }

    public void setLongChromosomeNames(List<String> chrNames) {
        this.longChromosomeNames = chrNames;
    }

    static {
        ucsdIDMap = new HashMap<String, String>();
        ucsdIDMap.put("1kg_ref", "hg18");
        ucsdIDMap.put("1kg_v37", "hg19");
        ucsdIDMap.put("b37", "hg19");
        mockGenome = new Genome("hg19");
    }
}

