/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.parsers;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.data.WiggleParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class ToolsWiggleParser
extends WiggleParser {
    private static Logger log = LogManager.getLogger(ToolsWiggleParser.class);
    private DataConsumer dataConsumer;
    String trackLine = null;
    String nextLine = null;
    float[] buffer = new float[1];

    public ToolsWiggleParser(String file, DataConsumer dataConsumer, Genome genome) {
        super(new ResourceLocator(file), genome);
        this.dataConsumer = dataConsumer;
        this.parseHeader();
        String[] trackNames = new String[]{this.resourceLocator.getTrackName()};
        if (this.resourceLocator.getPath().endsWith(".ewig") || this.resourceLocator.getPath().endsWith(".ewig.gz") || this.resourceLocator.getPath().endsWith("ewig.map")) {
            trackNames = new String[5];
            trackNames[4] = this.resourceLocator.getTrackName();
            trackNames[0] = "A";
            trackNames[1] = "C";
            trackNames[2] = "G";
            trackNames[3] = "T";
        }
        dataConsumer.setTrackParameters(TrackType.OTHER, this.trackLine, trackNames);
        if (this.trackLine != null) {
            TrackProperties props = new TrackProperties();
            ParsingUtils.parseTrackLine(this.trackLine, props);
            TrackProperties.BaseCoord convention = props.getBaseCoord();
            if (convention == TrackProperties.BaseCoord.ZERO) {
                this.startBase = 0;
            }
        }
    }

    public DataConsumer getDataConsumer() {
        return this.dataConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWiggle(ResourceLocator file) {
        try (AsciiLineReader reader = null;){
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            int lineNo = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("track") && nextLine.contains("wiggle_0")) {
                    boolean bl = true;
                    return bl;
                }
                if (lineNo++ <= 100) continue;
                break;
            }
        }
        return false;
    }

    private void parseHeader() {
        try (AsciiLineReader reader = null;){
            reader = ParsingUtils.openAsciiReader(this.resourceLocator);
            while ((this.nextLine = reader.readLine()) != null && this.nextLine.trim().length() > 0) {
                if (this.nextLine.startsWith("#") || this.nextLine.startsWith("data") || this.nextLine.startsWith("browser") || this.nextLine.trim().length() == 0) continue;
                if (this.nextLine.startsWith("track")) {
                    this.trackLine = this.nextLine;
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public WiggleDataset parse() {
        this.lastPosition = -1;
        this.unsortedChromosomes = new HashSet();
        if (this.resourceLocator.getPath().endsWith("ewig.map")) {
            this.startBase = 0;
            this.windowSpan = 1;
            this.type = WiggleParser.Type.VARIABLE;
            String parent = new File(this.resourceLocator.getPath()).getParent();
            Map<String, String> fileMap = null;
            try {
                fileMap = this.parseEwigList(this.resourceLocator.getPath());
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                this.chr = entry.getKey();
                File f = new File(parent, entry.getValue());
                this.parseFile(new ResourceLocator(f.getAbsolutePath()));
            }
        } else {
            this.parseFile(this.resourceLocator);
        }
        this.parsingComplete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> parseEwigList(String path) throws IOException {
        try (BufferedReader reader = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>();
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                fileMap.put(tokens[0], tokens[1]);
            }
            LinkedHashMap<String, String> linkedHashMap = fileMap;
            return linkedHashMap;
        }
    }

    @Override
    protected void changedChromosome(WiggleDataset dataset, String lastChr) {
        this.lastPosition = -1;
    }

    @Override
    protected void parsingComplete() {
        this.getDataConsumer().parsingComplete();
    }

    @Override
    public void addData(String chr, int start, int end, float value) {
        this.buffer[0] = value;
        this.addData(chr, start, end, this.buffer);
    }

    @Override
    public void addData(String chr, int start, int end, float[] values) {
        this.getDataConsumer().addData(chr, start, end, values, null);
    }
}

