/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.DoubleArrayList;

public class ListAccumulator {
    static Set<WindowFunction> PERCENTILE_WINDOW_FUNCTIONS = new HashSet<WindowFunction>();
    public static int MAX_VALUE_COUNT = 100000;
    private static Logger log = LogManager.getLogger(ListAccumulator.class);
    boolean isFinished = false;
    List<WindowFunction> windowFunctions;
    List<WindowFunction> quantileFunctions;
    Map<WindowFunction, List<PercentileValue>> percentiles = new HashMap<WindowFunction, List<PercentileValue>>();
    DoubleArrayList values = null;
    float sum = 0.0f;
    int basesCovered = 0;
    int nPts = 0;
    float min = Float.NaN;
    float max = Float.NaN;
    float absoluteMax = Float.NaN;
    float mean = Float.NaN;
    float median = Float.NaN;
    float percentile2 = Float.NaN;
    float percentile10 = Float.NaN;
    float percentile90 = Float.NaN;
    float percentile98 = Float.NaN;

    public ListAccumulator(Collection<WindowFunction> windowFunctions) {
        this.windowFunctions = new ArrayList<WindowFunction>(windowFunctions);
        this.quantileFunctions = new ArrayList<WindowFunction>();
        for (WindowFunction wf : windowFunctions) {
            if (!PERCENTILE_WINDOW_FUNCTIONS.contains(wf)) continue;
            this.quantileFunctions.add(wf);
            if (this.values != null) continue;
            this.values = new DoubleArrayList();
        }
    }

    public void add(int w, float v) {
        if (!Float.isNaN(v)) {
            this.min = Float.isNaN(this.min) ? v : Math.min(this.min, v);
            this.max = Float.isNaN(this.max) ? v : Math.max(this.max, v);
            this.sum += (float)w * v;
            this.basesCovered += w;
            ++this.nPts;
            if (this.values != null) {
                this.values.add(v);
                if (this.values.size() > MAX_VALUE_COUNT) {
                    this.computePercentiles();
                    this.values.clear();
                }
            }
        }
    }

    public void finish() {
        if (this.isFinished) {
            return;
        }
        this.mean = Float.isNaN(this.sum) ? Float.NaN : this.sum / (float)this.basesCovered;
        float f = this.absoluteMax = Math.abs(this.min) > Math.abs(this.max) ? this.min : this.max;
        if (this.values != null) {
            if (this.nPts == 1) {
                for (WindowFunction wf : this.quantileFunctions) {
                    this.setValue(wf, this.mean);
                }
            } else {
                if (this.values.size() > 1) {
                    this.computePercentiles();
                }
                for (WindowFunction wf : this.quantileFunctions) {
                    List<PercentileValue> pList = this.percentiles.get(wf);
                    float v = Float.NaN;
                    if (pList != null && pList.size() > 0) {
                        double weightedSum = 0.0;
                        double sumOfWeights = 0.0;
                        for (PercentileValue pv : pList) {
                            double weight = (double)pv.nPoints / (double)this.nPts;
                            sumOfWeights += weight;
                            weightedSum += weight * pv.value;
                        }
                        v = (float)(weightedSum / sumOfWeights);
                    }
                    this.setValue(wf, v);
                }
            }
        }
        this.values = null;
        this.isFinished = true;
    }

    private void computePercentiles() {
        if (this.values != null) {
            double[] valueArray = this.values.toArray();
            for (WindowFunction wf : this.quantileFunctions) {
                double p = this.getPercentile(wf);
                if (!(p > 0.0)) continue;
                float v = (float)StatUtils.percentile((double[])valueArray, (double)p);
                if (Float.isInfinite(v)) {
                    log.error("Infinite percentile (" + wf + ")");
                    continue;
                }
                List<PercentileValue> pList = this.percentiles.get(wf);
                if (pList == null) {
                    pList = new ArrayList<PercentileValue>();
                    this.percentiles.put(wf, pList);
                }
                pList.add(new PercentileValue(valueArray.length, v));
            }
        }
    }

    private void setValue(WindowFunction wf, float value) {
        switch (wf) {
            case mean: {
                this.mean = value;
                break;
            }
            case median: {
                this.median = value;
                break;
            }
            case min: {
                this.min = value;
                break;
            }
            case max: {
                this.max = value;
                break;
            }
            case percentile2: {
                this.percentile2 = value;
                break;
            }
            case percentile10: {
                this.percentile10 = value;
                break;
            }
            case percentile90: {
                this.percentile90 = value;
                break;
            }
            case percentile98: {
                this.percentile98 = value;
                break;
            }
            default: {
                System.err.println("Unexpected window function: " + wf.toString());
            }
        }
    }

    public float getValue(WindowFunction wf) {
        switch (wf) {
            case mean: {
                return this.mean;
            }
            case median: {
                return this.median;
            }
            case min: {
                return this.min;
            }
            case max: {
                return this.max;
            }
            case absoluteMax: {
                return this.absoluteMax;
            }
            case percentile2: {
                return this.percentile2;
            }
            case percentile10: {
                return this.percentile10;
            }
            case percentile90: {
                return this.percentile90;
            }
            case percentile98: {
                return this.percentile98;
            }
            case count: {
                return this.nPts;
            }
        }
        System.err.println("Unexpected window function: " + wf.toString());
        return Float.NaN;
    }

    public double getPercentile(WindowFunction wf) {
        switch (wf) {
            case percentile2: {
                return 2.0;
            }
            case percentile10: {
                return 10.0;
            }
            case percentile90: {
                return 90.0;
            }
            case percentile98: {
                return 98.0;
            }
            case median: {
                return 50.0;
            }
        }
        return -1.0;
    }

    static {
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.median);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile2);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile10);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile90);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile98);
    }

    class PercentileValue {
        int nPoints;
        double value;

        PercentileValue(int nPoints, double value) {
            this.nPoints = nPoints;
            this.value = value;
        }
    }
}

