/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.BaseModification;
import org.broad.igv.sam.BisulfiteBaseInfo;
import org.broad.igv.sam.BisulfiteBaseInfoNOMeseq;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.GreyscaleColorTable;
import org.broad.igv.ui.color.HSLColorTable;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.util.ChromosomeColors;

public class AlignmentRenderer {
    private static Logger log = LogManager.getLogger(AlignmentRenderer.class);
    private static final Color negStrandColor = new Color(150, 150, 230);
    private static final Color posStrandColor = new Color(230, 150, 150);
    private static final Color RL_COLOR = new Color(0, 150, 0);
    private static final Color RR_COLOR = new Color(20, 50, 200);
    private static final Color LL_COLOR = new Color(0, 150, 150);
    private static Color smallISizeColor = new Color(0, 0, 150);
    private static Color largeISizeColor = new Color(200, 0, 0);
    private static final Color OUTLINE_COLOR = new Color(185, 185, 185);
    private static Color clippedColor = new Color(255, 20, 147);
    public static Color purple = new Color(118, 24, 220);
    private static Color deletionColor = Color.black;
    private static Color skippedColor = new Color(150, 184, 200);
    private static Color unknownGapColor = new Color(0, 150, 0);
    private static final Color bisulfiteColorFw1 = new Color(195, 195, 195);
    private static final Color bisulfiteColorRev1 = new Color(195, 210, 195);
    private static final Color nomeseqColor = new Color(195, 195, 195);
    private static Map<String, AlignmentTrack.OrientationType> frOrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f1f2OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> f2f1OrientationTypes;
    private static Map<String, AlignmentTrack.OrientationType> rfOrientationTypes;
    private static Map<AlignmentTrack.OrientationType, Color> typeToColorMap;
    public static final HSLColorTable tenXColorTable1;
    public static final HSLColorTable tenXColorTable2;
    public static final GreyscaleColorTable tenXColorTable3;
    public static final Color GROUP_DIVIDER_COLOR;
    private static byte[] softClippedReference;
    private static ColorTable readGroupColors;
    private static ColorTable sampleColors;
    private static ColorTable movieColors;
    private static ColorTable zmwColors;
    private static Map<String, ColorTable> tagValueColors;
    private static ColorTable defaultTagColors;
    public static HashMap<Character, Color> nucleotideColors;
    AlignmentTrack track;

    private static void initializeTagTypes() {
        frOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        frOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F R ", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("FR", AlignmentTrack.OrientationType.LR);
        frOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("F F ", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("FF", AlignmentTrack.OrientationType.LL);
        frOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R R ", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("RR", AlignmentTrack.OrientationType.RR);
        frOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("R F ", AlignmentTrack.OrientationType.RL);
        frOrientationTypes.put("RF", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        rfOrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LR);
        rfOrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("R R ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("RR ", AlignmentTrack.OrientationType.LL);
        rfOrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F F ", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("FF", AlignmentTrack.OrientationType.RR);
        rfOrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("F R ", AlignmentTrack.OrientationType.RL);
        rfOrientationTypes.put("FR", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f2f1OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.LR);
        f2f1OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.LL);
        f2f1OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.RR);
        f2f1OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.RL);
        f2f1OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes = new HashMap<String, AlignmentTrack.OrientationType>();
        f1f2OrientationTypes.put("F1F2", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("R2R1", AlignmentTrack.OrientationType.LR);
        f1f2OrientationTypes.put("F1R2", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R2F1", AlignmentTrack.OrientationType.LL);
        f1f2OrientationTypes.put("R1F2", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("F2R1", AlignmentTrack.OrientationType.RR);
        f1f2OrientationTypes.put("R1R2", AlignmentTrack.OrientationType.RL);
        f1f2OrientationTypes.put("F2F1", AlignmentTrack.OrientationType.RL);
    }

    private static void initializeTagColors() {
        ColorPalette palette = ColorUtilities.getPalette("Pastel 1");
        readGroupColors = new PaletteColorTable(palette);
        sampleColors = new PaletteColorTable(palette);
        movieColors = new PaletteColorTable(palette);
        zmwColors = new PaletteColorTable(palette);
        defaultTagColors = new PaletteColorTable(palette);
        tagValueColors = new HashMap<String, ColorTable>();
        typeToColorMap = new HashMap<AlignmentTrack.OrientationType, Color>(5);
        typeToColorMap.put(AlignmentTrack.OrientationType.LL, LL_COLOR);
        typeToColorMap.put(AlignmentTrack.OrientationType.RL, RL_COLOR);
        typeToColorMap.put(AlignmentTrack.OrientationType.RR, RR_COLOR);
    }

    private static void setNucleotideColors() {
        IGVPreferences prefs = PreferencesManager.getPreferences();
        nucleotideColors = new HashMap();
        Color a = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.A"), Color.green);
        Color c = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.C"), Color.blue);
        Color t = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.T"), Color.red);
        Color g = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.G"), new Color(209, 113, 5));
        Color n = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.N"), new Color(64, 64, 64));
        nucleotideColors.put(Character.valueOf('A'), a);
        nucleotideColors.put(Character.valueOf('a'), a);
        nucleotideColors.put(Character.valueOf('C'), c);
        nucleotideColors.put(Character.valueOf('c'), c);
        nucleotideColors.put(Character.valueOf('T'), t);
        nucleotideColors.put(Character.valueOf('t'), t);
        nucleotideColors.put(Character.valueOf('G'), g);
        nucleotideColors.put(Character.valueOf('g'), g);
        nucleotideColors.put(Character.valueOf('N'), n);
        nucleotideColors.put(Character.valueOf('n'), n);
        nucleotideColors.put(Character.valueOf('-'), Color.lightGray);
    }

    public AlignmentRenderer(AlignmentTrack track) {
        this.track = track;
    }

    private void initializeGraphics(RenderContext context) {
        Font font = FontManager.getFont(10);
        Graphics2D g1 = context.getGraphics2D("ALIGNMENT");
        float alpha = 0.75f;
        int type = 3;
        AlphaComposite alignmentAlphaComposite = AlphaComposite.getInstance(type, alpha);
        g1.setComposite(alignmentAlphaComposite);
        g1.setFont(font);
        Graphics2D g2 = context.getGraphics2D("LINK_LINE");
        alpha = 0.3f;
        type = 3;
        alignmentAlphaComposite = AlphaComposite.getInstance(type, alpha);
        g2.setComposite(alignmentAlphaComposite);
        Graphics2D g3 = context.getGraphics2D("THICK_STROKE");
        g3.setStroke(new BasicStroke(2.0f));
        Graphics2D g4 = context.getGraphics2D("STRAND");
        g4.setColor(Color.DARK_GRAY);
        Graphics2D g5 = context.getGraphics2D("SOFT_CLIP");
        g5.setColor(Color.BLACK);
        Graphics2D g6 = context.getGraphics2D("MISMATCH");
        g6.setColor(Color.RED);
    }

    public void renderAlignments(List<Alignment> alignments, AlignmentCounts alignmentCounts, RenderContext context, Rectangle rowRect, AlignmentTrack.RenderOptions renderOptions) {
        this.initializeGraphics(context);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color defaultColor = this.track.getColor();
        if (alignments != null && alignments.size() > 0) {
            int lastPixelDrawn = -1;
            for (Alignment alignment : alignments) {
                boolean leaveMargin;
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (pixelEnd < (double)rowRect.x || pixelStart > rowRect.getMaxX()) continue;
                double pixelWidth = pixelEnd - pixelStart;
                Color alignmentColor = this.getAlignmentColor(alignment, this.track);
                boolean bl = leaveMargin = this.track.getDisplayMode() != Track.DisplayMode.SQUISHED;
                if (pixelWidth < 2.0 && (!AlignmentTrack.isBisulfiteColorType(renderOptions.getColorOption()) && renderOptions.getColorOption() != AlignmentTrack.ColorOption.BASE_MODIFICATION || !(pixelWidth >= 1.0))) {
                    if (pixelEnd <= (double)lastPixelDrawn && alignmentColor == defaultColor) continue;
                    Graphics2D g = context.getGraphics2D("ALIGNMENT");
                    g.setColor(alignmentColor);
                    int w = Math.max(1, (int)pixelWidth);
                    int h = (int)Math.max(1.0, rowRect.getHeight() - 2.0);
                    int y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h) / 2.0);
                    g.fillRect((int)pixelStart, y, w, h);
                    lastPixelDrawn = (int)pixelStart + w;
                    continue;
                }
                if (alignment instanceof PairedAlignment) {
                    this.drawPairedAlignment((PairedAlignment)alignment, rowRect, context, renderOptions, leaveMargin, alignmentCounts);
                    continue;
                }
                if (alignment instanceof LinkedAlignment) {
                    this.drawLinkedAlignment((LinkedAlignment)alignment, rowRect, context, renderOptions, leaveMargin, alignmentCounts);
                    continue;
                }
                this.drawAlignment(alignment, rowRect, context, alignmentColor, renderOptions, leaveMargin, alignmentCounts, false);
            }
            IGVPreferences prefs = this.track.getPreferences();
            boolean showCenterLine = prefs.getAsBoolean("SAM.SHOW_CENTER_LINE");
            int bottom = rowRect.y + rowRect.height;
            if (showCenterLine) {
                double center = (int)(context.getReferenceFrame().getCenter() - origin);
                int centerLeftP = (int)(center / locScale);
                int centerRightP = (int)((center + 1.0) / locScale);
                Graphics2D g = context.getGraphics();
                g.setColor(Color.black);
                GraphicUtils.drawDottedDashLine(g, centerLeftP, rowRect.y, centerLeftP, bottom);
                if (centerRightP - centerLeftP > 2) {
                    GraphicUtils.drawDottedDashLine(g, centerRightP, rowRect.y, centerRightP, bottom);
                }
            }
        }
    }

    private void drawLinkedAlignment(LinkedAlignment alignment, Rectangle rowRect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color alignmentColor = this.getAlignmentColor(alignment, this.track);
        List<Alignment> barcodedAlignments = alignment.alignments;
        if (barcodedAlignments.size() > 0) {
            boolean mixedStrand = alignment instanceof LinkedAlignment && alignment.getStrand() == Strand.NONE;
            Alignment firstAlignment = barcodedAlignments.get(0);
            if (barcodedAlignments.size() > 1) {
                Graphics2D gline = context.getGraphics2D("LINK_LINE");
                gline.setColor(alignmentColor);
                int startX = (int)(((double)firstAlignment.getEnd() - origin) / locScale);
                int endX = (int)(((double)barcodedAlignments.get(barcodedAlignments.size() - 1).getStart() - origin) / locScale);
                int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
                int y = (int)rowRect.getY();
                startX = Math.max(rowRect.x, startX);
                endX = Math.min(rowRect.x + rowRect.width, endX);
                gline.drawLine(startX, y + h / 2, endX, y + h / 2);
            }
            for (int i = 0; i < barcodedAlignments.size(); ++i) {
                boolean overlapped = false;
                Alignment al = barcodedAlignments.get(i);
                if (al.isNegativeStrand()) {
                    if (mixedStrand) {
                        alignmentColor = negStrandColor;
                    }
                    overlapped = i > 0 && barcodedAlignments.get(i - 1).getAlignmentEnd() > al.getAlignmentStart();
                } else {
                    if (mixedStrand) {
                        alignmentColor = posStrandColor;
                    }
                    overlapped = i < barcodedAlignments.size() - 1 && al.getAlignmentEnd() > barcodedAlignments.get(i + 1).getAlignmentStart();
                }
                this.drawAlignment(al, rowRect, context, alignmentColor, renderOptions, leaveMargin, alignmentCounts, overlapped);
            }
        }
    }

    private void drawSimpleAlignment(Alignment alignment, Rectangle rect, Graphics2D g, RenderContext context, boolean flagUnmappedPair) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        int x = (int)(((double)alignment.getStart() - origin) / locScale);
        int length = alignment.getEnd() - alignment.getStart();
        int w = (int)Math.ceil((double)length / locScale);
        int h = (int)Math.max(1.0, rect.getHeight() - 2.0);
        int y = (int)(rect.getY() + (rect.getHeight() - (double)h) / 2.0);
        int arrowLength = Math.min(5, w / 6);
        int d = Math.max(0, (int)((double)(arrowLength + 2) - 2.0 / context.getScale()));
        if (alignment.isNegativeStrand()) {
            x += d;
        }
        if (!alignment.isNegativeStrand()) {
            w -= d;
        }
        int[] xPoly = null;
        int[] yPoly = new int[]{y, y, y + h / 2, y + h, y + h};
        if (x < rect.x && x + w > rect.x + rect.width) {
            x = rect.x;
            w = rect.width;
            arrowLength = 0;
        } else if (x < rect.x) {
            int delta = rect.x - x;
            x = rect.x;
            w -= delta;
            if (alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        } else if (x + w > rect.x + rect.width) {
            w -= x + w - (rect.x + rect.width);
            if (!alignment.isNegativeStrand()) {
                arrowLength = 0;
            }
        }
        xPoly = alignment.isNegativeStrand() ? new int[]{x + w, x, x - arrowLength, x, x + w} : new int[]{x, x + w, x + w + arrowLength, x + w, x};
        g.fillPolygon(xPoly, yPoly, xPoly.length);
        if (flagUnmappedPair && alignment.isPaired() && !alignment.getMate().isMapped()) {
            g.setColor(Color.red);
            g.drawPolygon(xPoly, yPoly, xPoly.length);
        }
    }

    private void drawPairedAlignment(PairedAlignment pair, Rectangle rowRect, RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts) {
        double locScale = context.getScale();
        Color alignmentColor1 = this.getAlignmentColor(pair.firstAlignment, this.track);
        Color alignmentColor2 = null;
        boolean overlapped = pair.secondAlignment != null && pair.firstAlignment.getChr().equals(pair.secondAlignment.getChr()) && pair.firstAlignment.getAlignmentEnd() > pair.secondAlignment.getAlignmentStart();
        Graphics2D g = context.getGraphics2D("ALIGNMENT");
        g.setColor(alignmentColor1);
        this.drawAlignment(pair.firstAlignment, rowRect, context, alignmentColor1, renderOptions, leaveMargin, alignmentCounts, overlapped);
        if (pair.secondAlignment != null) {
            if (alignmentColor2 == null) {
                alignmentColor2 = this.getAlignmentColor(pair.secondAlignment, this.track);
            }
        } else {
            return;
        }
        g.setColor(alignmentColor2);
        this.drawAlignment(pair.secondAlignment, rowRect, context, alignmentColor2, renderOptions, leaveMargin, alignmentCounts, overlapped);
        Color lineColor = this.track.getColor();
        if (alignmentColor1.equals(alignmentColor2) || pair.secondAlignment == null) {
            lineColor = alignmentColor1;
        }
        g.setColor(lineColor);
        double origin = context.getOrigin();
        int startX = (int)(((double)pair.firstAlignment.getEnd() - origin) / locScale);
        int endX = (int)(((double)pair.firstAlignment.getMate().getStart() - origin) / locScale);
        int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        startX = Math.max(rowRect.x, startX);
        endX = Math.min(rowRect.x + rowRect.width, endX);
        g.drawLine(startX, y + h / 2, endX, y + h / 2);
    }

    private void drawAlignment(Alignment alignment, Rectangle rowRect, RenderContext context, Color alignmentColor, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, AlignmentCounts alignmentCounts, boolean overlapped) {
        Map<Integer, BaseModification> baseModifications;
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        Graphics2D gAlignment = context.getGraphics2D("ALIGNMENT");
        gAlignment.setColor(alignmentColor);
        if (blocks == null || blocks.length == 0) {
            this.drawSimpleAlignment(alignment, rowRect, gAlignment, context, renderOptions.isFlagUnmappedPairs());
            return;
        }
        IGVPreferences prefs = this.track.getPreferences();
        boolean flagLargeIndels = prefs.getAsBoolean("SAM.FLAG_LARGE_INDELS");
        int largeInsertionsThreshold = prefs.getAsInt("SAM.LARGE_INSERTIONS_THRESOLD");
        boolean hideSmallIndelsBP = prefs.getAsBoolean("SAM.HIDE_SMALL_INDEL");
        int indelThresholdBP = prefs.getAsInt("SAM.SMALL_INDEL_BP_THRESHOLD");
        boolean quickConsensus = renderOptions.isQuickConsensusMode();
        float snpThreshold = prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        double locScale = context.getScale();
        int h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
        int y = (int)rowRect.getY();
        Graphics2D clippedGraphics = context.getGraphic2DForColor(clippedColor);
        if (h > 5) {
            clippedGraphics.setStroke(new BasicStroke(1.2f));
        }
        Graphics2D strandGraphics = context.getGraphics2D("STRAND");
        Graphics2D largeIndelGraphics = context.getGraphics2D("INDEL_LABEL");
        largeIndelGraphics.setFont(FontManager.getFont(1, h - 2));
        Graphics2D bpGraphics = context.getGraphics2D("BASE");
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        if (dX >= 8) {
            Font f = FontManager.getFont(1, Math.min(dX, h));
            bpGraphics.setFont(f);
        }
        boolean flagClipping = prefs.getAsBoolean("SAM.FLAG_CLIPPING");
        int clippingThreshold = prefs.getAsInt("SAM.CLIPPING_THRESHOLD");
        int[] clipping = SAMAlignment.getClipping(alignment.getCigarString());
        boolean leftClipped = flagClipping && clipping[0] + clipping[1] > clippingThreshold;
        boolean rightClipped = flagClipping && clipping[2] + clipping[3] > clippingThreshold;
        double bpStart = context.getOrigin();
        double bpEnd = Math.ceil(context.getEndLocation());
        List<Gap> gaps = alignment.getGaps();
        if (gaps != null) {
            for (Gap gap : gaps) {
                boolean drawGap;
                int gapStart = gap.getStart();
                int gapWidth = gap.getnBases();
                int gapEnd = gapStart + gapWidth;
                int gapPxStart = (int)((Math.max(bpStart, (double)gapStart) - bpStart) / locScale);
                int gapPxEnd = (int)((Math.min(bpEnd, (double)gapEnd) - bpStart) / locScale);
                if ((double)gapEnd <= bpStart) continue;
                if ((double)gapStart >= bpEnd) break;
                boolean bl = drawGap = !hideSmallIndelsBP || gapWidth >= indelThresholdBP;
                if (!drawGap) continue;
                Graphics2D gapGraphics = context.getGraphics2D("GAP");
                if (gap.getType() == '\u0000') {
                    gapGraphics.setColor(unknownGapColor);
                } else if (gap.getType() == 'N') {
                    gapGraphics.setColor(skippedColor);
                } else if (h > 5) {
                    gapGraphics = context.getGraphics2D("THICK_STROKE");
                    gapGraphics.setColor(deletionColor);
                }
                gapGraphics.drawLine(gapPxStart, y + h / 2, gapPxEnd, y + h / 2);
                if (!flagLargeIndels || gap.getType() != 'D' || gapWidth <= largeInsertionsThreshold) continue;
                this.drawLargeIndelLabel(largeIndelGraphics, false, Globals.DECIMAL_FORMAT.format(gapWidth), (gapPxStart + gapPxEnd) / 2, y, h, gapPxEnd - gapPxStart - 2, context.translateX, null);
            }
        }
        Graphics2D outlineGraphics = null;
        HashMap<String, Color> selectedReadNames = this.track.selectedReadNames;
        if (selectedReadNames.containsKey(alignment.getReadName())) {
            Color c = selectedReadNames.get(alignment.getReadName());
            c = c == null ? Color.blue : c;
            outlineGraphics = context.getGraphics2D("THICK_STROKE");
            gAlignment.setColor(c);
        } else if (renderOptions.isFlagUnmappedPairs() && alignment.isPaired() && !alignment.getMate().isMapped()) {
            outlineGraphics = context.getGraphics2D("OUTLINE");
            outlineGraphics.setColor(Color.red);
        } else if (alignment.getMappingQuality() == 0 && renderOptions.isFlagZeroQualityAlignments()) {
            outlineGraphics = context.getGraphic2DForColor(OUTLINE_COLOR);
        }
        double pixelLengthOnReference = (double)alignment.getLengthOnReference() / locScale;
        int arrowPxWidth = pixelLengthOnReference == 0.0 ? 0 : (int)Math.min((double)Math.min(5, h / 2), pixelLengthOnReference / 6.0);
        int blockChromStart = blocks[0].getStart();
        boolean leftmost = true;
        for (int blockIx = 0; blockIx < blocks.length; ++blockIx) {
            boolean tallEnoughForArrow;
            AlignmentBlock block = blocks[blockIx];
            int blockChromEnd = block.getStart() + block.getLength();
            int blockPxStart = (int)Math.round(((double)blockChromStart - bpStart) / locScale);
            int blockPxEnd = (int)Math.round(((double)blockChromEnd - bpStart) / locScale);
            boolean rightmost = blockIx + 1 == blocks.length;
            boolean bl = tallEnoughForArrow = h > 6;
            if (!rightmost) {
                if (hideSmallIndelsBP && blocks[blockIx + 1].getStart() - blockChromEnd < indelThresholdBP) continue;
                blockChromStart = blocks[blockIx + 1].getStart();
            }
            if (h == 1) {
                gAlignment.drawLine(blockPxStart, y, blockPxEnd, y);
            } else {
                int pixelGap;
                if (!overlapped && (pixelGap = (int)(2.0 / locScale)) < arrowPxWidth) {
                    arrowPxWidth = Math.max(0, arrowPxWidth - pixelGap);
                }
                int[] xPoly = new int[]{blockPxStart - (leftmost && alignment.isNegativeStrand() && tallEnoughForArrow ? arrowPxWidth : 0), blockPxStart, blockPxEnd, blockPxEnd + (rightmost && !alignment.isNegativeStrand() && tallEnoughForArrow ? arrowPxWidth : 0), blockPxEnd, blockPxStart};
                int[] yPoly = new int[]{y + h / 2, y, y, y + h / 2, y + h, y + h};
                Polygon blockShape = new Polygon(xPoly, yPoly, xPoly.length);
                Graphics2D g = gAlignment;
                if (!block.hasBases()) {
                    if (block.isSoftClip()) {
                        g = context.getGraphics2D("SOFT_CLIP");
                    } else if (block.getCigarOperator() == 'X') {
                        g = context.getGraphics2D("MISMATCH");
                    }
                }
                g.fill(blockShape);
                if (outlineGraphics != null) {
                    outlineGraphics.draw(blockShape);
                }
                if (leftmost && leftClipped) {
                    clippedGraphics.drawLine(xPoly[0], yPoly[0], xPoly[1], yPoly[1]);
                    clippedGraphics.drawLine(xPoly[5], yPoly[5] - 1, xPoly[0], yPoly[0]);
                }
                if (rightmost && rightClipped) {
                    clippedGraphics.drawLine(xPoly[2], yPoly[2], xPoly[3], yPoly[3]);
                    clippedGraphics.drawLine(xPoly[3], yPoly[3], xPoly[4], yPoly[4] - 1);
                }
            }
            leftmost = false;
        }
        AlignmentBlock[] insertions = alignment.getInsertions();
        if (insertions != null) {
            InsertionMarker expandedInsertion = InsertionManager.getInstance().getSelectedInsertion(context.getReferenceFrame().getChrName());
            int expandedPosition = expandedInsertion == null ? -1 : expandedInsertion.position;
            for (AlignmentBlock aBlock : insertions) {
                if (aBlock.getStart() == expandedPosition) continue;
                int x = (int)(((double)aBlock.getStart() - bpStart) / locScale);
                int bpWidth = aBlock.getBasesLength();
                double pxWidthExact = (double)bpWidth / locScale;
                h = (int)Math.max(1.0, rowRect.getHeight() - (double)(leaveMargin ? 2 : 0));
                y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h) / 2.0) - (leaveMargin ? 1 : 0);
                if ((double)x > rowRect.getMaxX()) break;
                if ((double)x < rowRect.getX() || hideSmallIndelsBP && bpWidth < indelThresholdBP) continue;
                if (flagLargeIndels && bpWidth > largeInsertionsThreshold) {
                    this.drawLargeIndelLabel(context.getGraphics2D("INDEL_LABEL"), true, Globals.DECIMAL_FORMAT.format(bpWidth), x - 1, y, h, (int)pxWidthExact, context.translateX, aBlock);
                    continue;
                }
                int pxWing = h > 10 ? 2 : (h > 5 ? 1 : 0);
                Graphics2D ig = context.getGraphics();
                ig.setColor(purple);
                ig.fillRect(x, y, 2, h);
                ig.fillRect(x - pxWing, y, 2 + 2 * pxWing, 2);
                ig.fillRect(x - pxWing, y + h - 2, 2 + 2 * pxWing, 2);
                aBlock.setPixelRange((x += context.translateX) - pxWing, x + 2 + pxWing);
            }
        }
        if (locScale < 100.0) {
            boolean showAllBases;
            AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
            boolean bl = showAllBases = renderOptions.isShowAllBases() && colorOption != AlignmentTrack.ColorOption.BISULFITE && colorOption != AlignmentTrack.ColorOption.NOMESEQ;
            if (renderOptions.isShowMismatches() || showAllBases) {
                block3: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                    byte[] reference;
                    boolean haveBases;
                    boolean bl2 = haveBases = block.hasBases() && block.getLength() > 0;
                    if (!haveBases) continue;
                    String chr = context.getChr();
                    int start = block.getStart();
                    int end = block.getEnd();
                    if ((double)end <= bpStart) continue;
                    if ((double)start >= bpEnd) break;
                    boolean isSoftClip = block.isSoftClip();
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    byte[] byArray = reference = isSoftClip ? softClippedReference : genome.getSequence(chr, start, end);
                    if (reference == null && !showAllBases) continue;
                    int pY = (int)rowRect.getY();
                    int dY = (int)rowRect.getHeight();
                    dX = (int)Math.max(1.0, 1.0 / locScale);
                    BisulfiteBaseInfo bisinfo = null;
                    boolean nomeseqMode = renderOptions.getColorOption().equals((Object)AlignmentTrack.ColorOption.NOMESEQ);
                    boolean bisulfiteMode = AlignmentTrack.isBisulfiteColorType(renderOptions.getColorOption());
                    if (nomeseqMode) {
                        bisinfo = new BisulfiteBaseInfoNOMeseq(reference, alignment, block, renderOptions.bisulfiteContext);
                    } else if (bisulfiteMode) {
                        bisinfo = new BisulfiteBaseInfo(reference, alignment, block, renderOptions.bisulfiteContext);
                    }
                    ByteSubarray blockBases = block.getBases();
                    int s = (int)Math.max(Math.floor(bpStart), (double)start);
                    int e = (int)Math.min(Math.ceil(bpEnd), (double)end);
                    for (int loc = s; loc < e; ++loc) {
                        boolean showBase;
                        double bisulfiteXaxisShift;
                        int pX;
                        int idx = loc - start;
                        boolean misMatch = AlignmentUtils.isMisMatch(reference, blockBases, isSoftClip, idx);
                        if (!showAllBases && (bisulfiteMode || !misMatch) && (!bisulfiteMode || BisulfiteBaseInfo.DisplayStatus.NOTHING == bisinfo.getDisplayStatus(idx))) continue;
                        char c = (char)blockBases.getByte(idx);
                        Color color = null;
                        color = bisulfiteMode ? bisinfo.getDisplayColor(idx) : (renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION ? Color.GRAY : nucleotideColors.get(Character.valueOf(c)));
                        if (color == null) {
                            color = Color.black;
                        }
                        if (renderOptions.getShadeBasesOption()) {
                            byte qual = block.getQuality(loc - start);
                            color = this.getShadedColor(qual, color, alignmentColor, prefs);
                        }
                        if ((double)(pX = (int)(((double)loc + (bisulfiteXaxisShift = bisulfiteMode ? bisinfo.getXaxisShift(idx) : 0.0) - bpStart) / locScale)) > rowRect.getMaxX()) continue block3;
                        if ((double)(pX + dX) < rowRect.getX()) continue;
                        BisulfiteBaseInfo.DisplayStatus bisstatus = bisinfo == null ? null : bisinfo.getDisplayStatus(idx);
                        boolean bl3 = showBase = isSoftClip || bisulfiteMode || !quickConsensus || alignmentCounts.isConsensusMismatch(loc, reference[idx], chr, snpThreshold);
                        if (!showBase) continue;
                        this.drawBase(gAlignment, color, c, pX, pY, dX, dY - (leaveMargin ? 2 : 0), bisulfiteMode, bisstatus);
                    }
                }
            }
        }
        if (renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION && (baseModifications = alignment.getBaseModificationMap()) != null) {
            double threshold = 256.0f * PreferencesManager.getPreferences().getAsFloat("SAM.BASEMOD_THRESHOLD");
            block5: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                int pY = (int)rowRect.getY();
                int dY = (int)rowRect.getHeight();
                dX = (int)Math.max(1.0, 1.0 / locScale);
                Graphics2D g = context.getGraphics();
                for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
                    if (!baseModifications.containsKey(i)) continue;
                    BaseModification mod = baseModifications.get(i);
                    int l = Byte.toUnsignedInt(mod.likelihood);
                    if ((double)l < threshold) continue;
                    Color c = BaseModification.getModColor(mod.modification, mod.likelihood);
                    g.setColor(c);
                    int blockIdx = i - block.getBases().startOffset;
                    int pX = (int)(((double)(block.getStart() + blockIdx) - bpStart) / locScale);
                    if ((double)pX > rowRect.getMaxX()) continue block5;
                    if ((double)(pX + dX) < rowRect.getX()) continue;
                    if (dX < 3) {
                        dX = 3;
                        --pX;
                    }
                    g.fillRect(pX, pY, dX, Math.max(1, dY - 2));
                }
            }
        }
    }

    private void drawBase(Graphics2D g, Color color, char c, int pX, int pY, int dX, int dY, boolean bisulfiteMode, BisulfiteBaseInfo.DisplayStatus bisstatus) {
        int fontSize = Math.min(Math.min(dX, dY), 12);
        if (fontSize >= 8 && (!bisulfiteMode || bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.CHARACTER))) {
            Font f = FontManager.getFont(1, fontSize);
            g.setFont(f);
            g.setColor(color);
            GraphicUtils.drawCenteredText(new char[]{c}, pX, pY, dX, dY, g);
        } else {
            int pX0i = pX;
            int dXi = dX;
            if (bisulfiteMode && bisstatus.equals((Object)BisulfiteBaseInfo.DisplayStatus.COLOR) && dXi < 3) {
                int expansion = dXi;
                pX0i -= expansion;
                dXi += 2 * expansion;
            }
            if (color != null) {
                g.setColor(color);
                g.fillRect(pX0i, pY, dXi, dY);
            }
        }
    }

    private Color getShadedColor(byte qual, Color foregroundColor, Color backgroundColor, IGVPreferences prefs) {
        float alpha = 0.0f;
        int minQ = prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        if (alpha >= 1.0f) {
            return foregroundColor;
        }
        Color color = ColorUtilities.getCompositeColor(backgroundColor, foregroundColor, alpha);
        return color;
    }

    private void drawLargeIndelLabel(Graphics2D g, boolean isInsertion, String labelText, int pxCenter, int pxTop, int pxH, int pxWmax, int translateX, AlignmentBlock insertionBlock) {
        boolean doesTextFit;
        int pxPad = 2;
        int pxWing = pxH > 10 ? 2 : 1;
        int minTextHeight = 8;
        Rectangle2D textBounds = g.getFontMetrics().getStringBounds(labelText, g);
        int pxTextW = 4 + (int)textBounds.getWidth();
        boolean bl = doesTextFit = pxH >= 8 && pxTextW < pxWmax;
        if (!doesTextFit && !isInsertion) {
            return;
        }
        int pxW = Math.max(2, Math.min(pxTextW, pxWmax));
        int pxLeft = pxCenter - (int)Math.ceil(pxW / 2);
        int pxRight = pxLeft + pxW;
        g.setColor(isInsertion ? purple : Color.white);
        g.fillRect(pxLeft, pxTop, pxRight - pxLeft, pxH);
        if (isInsertion && pxH > 5) {
            g.fillRect(pxLeft - pxWing, pxTop, pxRight - pxLeft + 2 * pxWing, 2);
            g.fillRect(pxLeft - pxWing, pxTop + pxH - 2, pxRight - pxLeft + 2 * pxWing, 2);
        }
        if (doesTextFit) {
            g.setColor(isInsertion ? Color.white : purple);
            GraphicUtils.drawCenteredText(labelText, pxLeft, pxTop, pxW, pxH, (Graphics)g);
        }
        if (insertionBlock != null) {
            insertionBlock.setPixelRange(pxLeft + translateX, pxRight + translateX);
        }
    }

    private void drawInsertions(Rectangle rect, Alignment alignment, RenderContext context, AlignmentTrack.RenderOptions renderOptions, AlignmentCounts alignmentCounts, boolean leaveMargin, IGVPreferences prefs) {
        AlignmentBlock[] insertions = alignment.getInsertions();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        boolean flagLargeIndels = prefs.getAsBoolean("SAM.FLAG_LARGE_INDELS");
        int largeInsertionsThreshold = prefs.getAsInt("SAM.LARGE_INSERTIONS_THRESOLD");
        float snpThreshold = prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        boolean quickConsensus = false;
        if (insertions != null) {
            InsertionMarker expandedInsertion = InsertionManager.getInstance().getSelectedInsertion(context.getReferenceFrame().getChrName());
            int expandedPosition = expandedInsertion == null ? -1 : expandedInsertion.position;
            boolean hideSmallIndelsBP = prefs.getAsBoolean("SAM.HIDE_SMALL_INDEL");
            int indelThresholdBP = prefs.getAsInt("SAM.SMALL_INDEL_BP_THRESHOLD");
            for (AlignmentBlock aBlock : insertions) {
                if (aBlock.getStart() == expandedPosition) continue;
                int x = (int)(((double)aBlock.getStart() - origin) / locScale);
                int bpWidth = aBlock.getBasesLength();
                double pxWidthExact = (double)bpWidth / locScale;
                int h = (int)Math.max(1.0, rect.getHeight() - (double)(leaveMargin ? 2 : 0));
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h) / 2.0) - (leaveMargin ? 1 : 0);
                if ((double)x > rect.getMaxX()) break;
                if ((double)x < rect.getX() || hideSmallIndelsBP && bpWidth < indelThresholdBP) continue;
                if (flagLargeIndels && bpWidth > largeInsertionsThreshold) {
                    this.drawLargeIndelLabel(context.getGraphics2D("INDEL_LABEL"), true, Globals.DECIMAL_FORMAT.format(bpWidth), x - 1, y, h, (int)pxWidthExact, context.translateX, aBlock);
                    continue;
                }
                int pxWing = h > 10 ? 2 : (h > 5 ? 1 : 0);
                Graphics2D g = context.getGraphics();
                g.setColor(purple);
                g.fillRect(x, y, 2, h);
                g.fillRect(x - pxWing, y, 2 + 2 * pxWing, 2);
                g.fillRect(x - pxWing, y + h - 2, 2 + 2 * pxWing, 2);
                aBlock.setPixelRange((x += context.translateX) - pxWing, x + 2 + pxWing);
            }
        }
    }

    public void renderExpandedInsertion(InsertionMarker i, List<Alignment> alignments, RenderContext context, Rectangle rect, boolean leaveMargin) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (alignments != null && alignments.size() > 0) {
            Graphics2D g = context.getGraphics2D("INSERTIONS");
            double dX = 1.0 / context.getScale();
            int fontSize = (int)Math.min(dX, 12.0);
            if (fontSize >= 8) {
                Font f = FontManager.getFont(1, fontSize);
                g.setFont(f);
            }
            for (Alignment alignment : alignments) {
                if (alignment.getEnd() < i.position) continue;
                if (alignment.getStart() > i.position) break;
                AlignmentBlock insertion = alignment.getInsertionAt(i.position);
                if (insertion == null) continue;
                double pixelStart = ((double)insertion.getStart() - origin) / locScale;
                double pixelEnd = ((double)insertion.getEnd() - origin) / locScale;
                int x = (int)pixelStart;
                if (pixelEnd < (double)rect.x || pixelStart > rect.getMaxX()) continue;
                int bpWidth = insertion.getBasesLength();
                double pxWidthExact = (double)bpWidth / locScale;
                int h = (int)Math.max(1.0, rect.getHeight() - 2.0);
                int y = (int)(rect.getY() + (rect.getHeight() - (double)h) / 2.0) - 1;
                if (!insertion.hasBases()) {
                    g.setColor(purple);
                    g.fillRect(x, y, (int)pxWidthExact, h);
                    continue;
                }
                this.drawExpandedInsertionBases(x, context, rect, insertion, leaveMargin);
            }
        }
    }

    private void drawExpandedInsertionBases(int pixelPosition, RenderContext context, Rectangle rect, AlignmentBlock block, boolean leaveMargin) {
        Graphics2D g = context.getGraphics2D("INSERTIONS");
        ByteSubarray bases = block.getBases();
        int padding = block.getPadding();
        double locScale = context.getScale();
        double origin = context.getOrigin();
        int pY = (int)rect.getY();
        int dY = (int)rect.getHeight();
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        int size = bases.length + padding;
        for (int p = 0; p < size; ++p) {
            int pX;
            char c = p < padding ? (char)'-' : (char)bases.getByte(p - padding);
            Color color = SequenceRenderer.nucleotideColors.get(Character.valueOf(c));
            if (color == null) {
                color = Color.black;
            }
            if ((double)(pX = (int)((double)pixelPosition + (double)p / locScale)) > rect.getMaxX()) break;
            if ((double)(pX + dX) < rect.getX()) continue;
            this.drawBase(g, color, c, pX, pY, dX, dY - (leaveMargin ? 2 : 0), false, null);
        }
        int leftX = pixelPosition + context.translateX;
        int rightX = leftX + rect.width;
        block.setPixelRange(leftX, rightX);
    }

    private Color getAlignmentColor(Alignment alignment, AlignmentTrack track) {
        Color defaultColor;
        Color c = defaultColor = track.getColor();
        AlignmentTrack.RenderOptions renderOptions = track.renderOptions;
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        switch (colorOption) {
            case YC_TAG: {
                Color ycColor = alignment.getYcColor();
                if (ycColor == null) break;
                c = ycColor;
                break;
            }
            case BISULFITE: 
            case BASE_MODIFICATION: {
                c = alignment.getFirstOfPairStrand() == Strand.POSITIVE ? bisulfiteColorFw1 : bisulfiteColorRev1;
                break;
            }
            case NOMESEQ: {
                c = nomeseqColor;
                break;
            }
            case UNEXPECTED_PAIR: 
            case PAIR_ORIENTATION: {
                c = this.getOrientationColor(alignment, AlignmentRenderer.getPEStats(alignment, renderOptions));
                if (c != defaultColor || colorOption == AlignmentTrack.ColorOption.PAIR_ORIENTATION) break;
            }
            case INSERT_SIZE: {
                boolean sameChr;
                boolean isPairedAlignment = alignment instanceof PairedAlignment;
                ReadMate mate = alignment.getMate();
                if ((!alignment.isPaired() || mate == null || !mate.isMapped()) && !isPairedAlignment) break;
                String mateChr = mate == null ? null : mate.getChr();
                boolean bl = sameChr = isPairedAlignment || mateChr != null && mateChr.equals(alignment.getChr());
                if (sameChr) {
                    int readDistance;
                    if (track.getExperimentType() == AlignmentTrack.ExperimentType.RNA || (readDistance = Math.abs(alignment.getInferredInsertSize())) == 0) break;
                    int minThreshold = renderOptions.getMinInsertSize();
                    int maxThreshold = renderOptions.getMaxInsertSize();
                    PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
                    if (renderOptions.isComputeIsizes() && peStats != null) {
                        minThreshold = peStats.getMinThreshold();
                        maxThreshold = peStats.getMaxThreshold();
                    }
                    if (readDistance < minThreshold) {
                        c = smallISizeColor;
                        break;
                    }
                    if (readDistance <= maxThreshold) break;
                    c = largeISizeColor;
                    break;
                }
                c = ChromosomeColors.getColor(alignment.getMate().getChr());
                if (c != null) break;
                c = Color.black;
                break;
            }
            case READ_STRAND: {
                if (alignment.isNegativeStrand()) {
                    c = negStrandColor;
                    break;
                }
                c = posStrandColor;
                break;
            }
            case FIRST_OF_PAIR_STRAND: {
                Strand fragmentStrand = alignment.getFirstOfPairStrand();
                if (fragmentStrand == Strand.NEGATIVE) {
                    c = negStrandColor;
                    break;
                }
                if (fragmentStrand != Strand.POSITIVE) break;
                c = posStrandColor;
                break;
            }
            case READ_GROUP: {
                String rg = alignment.getReadGroup();
                if (rg == null) break;
                c = readGroupColors.get(rg);
                break;
            }
            case SAMPLE: {
                String sample = alignment.getSample();
                if (sample == null) break;
                c = sampleColors.get(sample);
                break;
            }
            case LIBRARY: {
                String library = alignment.getLibrary();
                if (library == null) break;
                c = sampleColors.get(library);
                break;
            }
            case MOVIE: {
                String[] readNameParts = alignment.getReadName().split("/");
                if (readNameParts.length < 3) break;
                c = movieColors.get(readNameParts[0]);
                break;
            }
            case ZMW: {
                String[] readNameParts = alignment.getReadName().split("/");
                if (readNameParts.length < 3) break;
                c = zmwColors.get(readNameParts[0] + "/" + readNameParts[1]);
                break;
            }
            case TAG: {
                ColorTable ctable;
                Object tagValue;
                String tag = renderOptions.getColorByTag();
                if (tag == null || (tagValue = alignment.getAttribute(tag)) == null) break;
                String groupByTag = renderOptions.getGroupByTag();
                if (groupByTag == null) {
                    ctable = defaultTagColors;
                } else {
                    Object g = alignment.getAttribute(groupByTag);
                    String group = g == null ? "" : g.toString();
                    String ctableKey = groupByTag + ":" + group;
                    ctable = tagValueColors.get(ctableKey);
                    if (ctable == null) {
                        ctable = groupByTag.equals("HP") ? this.getTenXColorTable(group) : defaultTagColors;
                        tagValueColors.put(group, ctable);
                    }
                }
                c = ctable.get(tagValue.toString());
                break;
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        if (alignment.getMappingQuality() == 0 && renderOptions.isFlagZeroQualityAlignments()) {
            float alpha = 0.15f;
            return ColorUtilities.getCompositeColor(Color.white, c, alpha);
        }
        return c;
    }

    private ColorTable getTenXColorTable(String group) {
        ColorTable ctable = group.equals("1") ? tenXColorTable1 : (group.equals("2") ? tenXColorTable2 : tenXColorTable3);
        return ctable;
    }

    public static PEStats getPEStats(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        String lb = alignment.getLibrary();
        if (lb == null) {
            lb = "null";
        }
        PEStats peStats = null;
        if (renderOptions.peStats != null) {
            peStats = renderOptions.peStats.get(lb);
        }
        return peStats;
    }

    private int getOutlierStatus(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            int minThreshold = peStats.getMinOutlierInsertSize();
            int maxThreshold = peStats.getMaxOutlierInsertSize();
            int dist = Math.abs(alignment.getInferredInsertSize());
            if (dist >= minThreshold || dist <= maxThreshold) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    private int compareToBounds(Alignment alignment, AlignmentTrack.RenderOptions renderOptions) {
        int dist;
        int minThreshold = renderOptions.getMinInsertSize();
        int maxThreshold = renderOptions.getMaxInsertSize();
        PEStats peStats = AlignmentRenderer.getPEStats(alignment, renderOptions);
        if (renderOptions.isComputeIsizes() && peStats != null) {
            minThreshold = peStats.getMinThreshold();
            maxThreshold = peStats.getMaxThreshold();
        }
        if ((dist = Math.abs(alignment.getInferredInsertSize())) < minThreshold) {
            return -1;
        }
        if (dist > maxThreshold) {
            return 1;
        }
        return 0;
    }

    private Color getOrientationColor(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(alignment, peStats);
        Color c = typeToColorMap.get((Object)type);
        return c == null ? this.track.getColor() : c;
    }

    static AlignmentTrack.OrientationType getOrientationType(Alignment alignment, PEStats peStats) {
        AlignmentTrack.OrientationType type = null;
        if (alignment.isPaired()) {
            String pairOrientation = alignment.getPairOrientation();
            if (peStats != null) {
                PEStats.Orientation libraryOrientation = peStats.getOrientation();
                switch (libraryOrientation) {
                    case FR: {
                        type = frOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case RF: {
                        type = rfOrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F1F2: {
                        type = f1f2OrientationTypes.get(pairOrientation);
                        break;
                    }
                    case F2F1: {
                        type = f2f1OrientationTypes.get(pairOrientation);
                    }
                }
            } else {
                type = alignment.getAttribute("CS") != null ? f2f1OrientationTypes.get(pairOrientation) : frOrientationTypes.get(pairOrientation);
            }
        }
        return type;
    }

    static {
        tenXColorTable1 = new HSLColorTable(30);
        tenXColorTable2 = new HSLColorTable(270);
        tenXColorTable3 = new GreyscaleColorTable();
        GROUP_DIVIDER_COLOR = new Color(200, 200, 200);
        softClippedReference = new byte[1000];
        AlignmentRenderer.initializeTagTypes();
        AlignmentRenderer.setNucleotideColors();
        AlignmentRenderer.initializeTagColors();
    }
}

