/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import htsjdk.tribble.Feature;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.variant.VariantTrack;

public class GlobalKeyDispatcher
implements KeyEventDispatcher {
    private static Logger log = LogManager.getLogger(GlobalKeyDispatcher.class);
    private final InputMap inputMap = new InputMap();
    private final ActionMap actionMap = new ActionMap();

    public GlobalKeyDispatcher() {
        this.init();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Action action;
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        String actionKey = (String)this.inputMap.get(ks);
        if (event.getKeyCode() == 17 || event.getKeyCode() == 18) {
            boolean flag = !event.isControlDown() && !event.isAltDown() && !event.isMetaDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }
        if (event.getKeyCode() == 27) {
            IGV.getInstance().clearSelections();
            IGV.getInstance().repaint();
            return true;
        }
        if (actionKey != null && (action = this.actionMap.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, event.getModifiers()));
            return true;
        }
        return false;
    }

    public void init() {
        final IGV igv = IGV.getInstance();
        final IGVPreferences prefMgr = PreferencesManager.getPreferences();
        KeyStroke nextKey0 = KeyStroke.getKeyStroke(70, 0, false);
        KeyStroke nextKey = KeyStroke.getKeyStroke(70, 2, false);
        EnableWrappedAction nextAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextFeature(true);
            }
        });
        this.inputMap.put(nextKey, "nextFeature");
        this.inputMap.put(nextKey0, "nextFeature");
        this.actionMap.put("nextFeature", nextAction);
        KeyStroke prevKey = KeyStroke.getKeyStroke(66, 2, false);
        KeyStroke prevKey0 = KeyStroke.getKeyStroke(66, 0, false);
        EnableWrappedAction prevAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextFeature(false);
            }
        });
        this.inputMap.put(prevKey, "prevFeature");
        this.inputMap.put(prevKey0, "prevFeature");
        this.actionMap.put("prevFeature", prevAction);
        KeyStroke nextExonKey = KeyStroke.getKeyStroke(70, 3, false);
        KeyStroke nextExonKey0 = KeyStroke.getKeyStroke(70, 1, false);
        EnableWrappedAction nextExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextExon(true);
            }
        });
        this.inputMap.put(nextExonKey, "nextExon");
        this.inputMap.put(nextExonKey0, "nextExon");
        this.actionMap.put("nextExon", nextExonAction);
        KeyStroke prevExonKey = KeyStroke.getKeyStroke(66, 3, false);
        KeyStroke prevExonKey0 = KeyStroke.getKeyStroke(66, 1, false);
        EnableWrappedAction prevExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalKeyDispatcher.this.nextExon(false);
            }
        });
        this.inputMap.put(prevExonKey, "prevExon");
        this.inputMap.put(prevExonKey0, "prevExon");
        this.actionMap.put("prevExon", prevExonAction);
        KeyStroke searchBoxKeyCtrl = KeyStroke.getKeyStroke(76, 2, false);
        KeyStroke searchBoxKeyMeta = KeyStroke.getKeyStroke(76, 4, false);
        EnableWrappedAction searchBoxAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igv.focusSearchBox();
            }
        });
        this.inputMap.put(searchBoxKeyCtrl, "focusSearch");
        this.inputMap.put(searchBoxKeyMeta, "focusSearch");
        this.actionMap.put("focusSearch", searchBoxAction);
        KeyStroke extrasKey = KeyStroke.getKeyStroke(84, 8, false);
        EnableWrappedAction extrasAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igv.enableExtrasMenu();
            }
        });
        this.inputMap.put(extrasKey, "tools");
        this.actionMap.put("tools", extrasAction);
        KeyStroke regionKey = KeyStroke.getKeyStroke(82, 2, false);
        EnableWrappedAction regionAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                Range currentRange = FrameManager.getDefaultFrame().getCurrentRange();
                RegionOfInterest regionOfInterest = new RegionOfInterest(currentRange.getChr(), currentRange.getStart(), currentRange.getEnd(), null);
                igv.addRegionOfInterest(regionOfInterest);
            }
        });
        this.inputMap.put(regionKey, "region");
        this.actionMap.put("region", regionAction);
        KeyStroke regionCenterKey = KeyStroke.getKeyStroke(82, 3, false);
        EnableWrappedAction regionCenterAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                int center = (int)FrameManager.getDefaultFrame().getCenter();
                RegionOfInterest regionOfInterest = new RegionOfInterest(FrameManager.getDefaultFrame().getChrName(), center, center + 1, null);
                igv.addRegionOfInterest(regionOfInterest);
            }
        });
        this.inputMap.put(regionCenterKey, "regionCenter");
        this.actionMap.put("regionCenter", regionCenterAction);
        KeyStroke sortByLastKey = KeyStroke.getKeyStroke(83, 128, false);
        AbstractAction sorAlignmentTracksAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sortOptionString = prefMgr.get("SAM.SORT_OPTION");
                if (sortOptionString != null) {
                    try {
                        AlignmentTrack.SortOption option = AlignmentTrack.SortOption.valueOf(sortOptionString);
                        String lastSortTag = prefMgr.get("SAM.SORT_BY_TAG");
                        igv.sortAlignmentTracks(option, lastSortTag);
                    }
                    catch (IllegalArgumentException e1) {
                        log.error("Unrecognized sort option: " + sortOptionString);
                    }
                }
            }
        };
        this.inputMap.put(sortByLastKey, "sortByLast");
        this.actionMap.put("sortByLast", sorAlignmentTracksAction);
        KeyStroke scatterplotKey = KeyStroke.getKeyStroke(80, 2, false);
        AbstractAction scatterplotAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScatterPlotUtils.hasPlottableTracks()) {
                    ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                    String chr = defaultFrame.getChrName();
                    int start = (int)defaultFrame.getOrigin();
                    int end = (int)defaultFrame.getEnd();
                    int zoom = defaultFrame.getZoom();
                    ScatterPlotUtils.openPlot(chr, start, end, zoom);
                }
            }
        };
        this.inputMap.put(scatterplotKey, "scatterPlot");
        this.actionMap.put("scatterPlot", scatterplotAction);
        KeyStroke backKey1 = KeyStroke.getKeyStroke(93, 256, false);
        KeyStroke backKey2 = KeyStroke.getKeyStroke(37, 512, false);
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igv.getSession().getHistory().back();
            }
        };
        this.inputMap.put(backKey1, "back");
        this.inputMap.put(backKey2, "back");
        this.actionMap.put("back", backAction);
        KeyStroke forwardKey1 = KeyStroke.getKeyStroke(91, 256, false);
        KeyStroke forwardKey2 = KeyStroke.getKeyStroke(39, 512, false);
        AbstractAction forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                igv.getSession().getHistory().forward();
            }
        };
        this.inputMap.put(forwardKey1, "forward");
        this.inputMap.put(forwardKey2, "forward");
    }

    private void nextExon(boolean forward) {
        if (FrameManager.isGeneListMode()) {
            return;
        }
        ReferenceFrame vc = FrameManager.getDefaultFrame();
        List<Track> tracks = IGV.getInstance().getSelectedTracks();
        if (tracks.size() == 1) {
            Track t = (Track)tracks.iterator().next();
            if (!(t instanceof FeatureTrack)) {
                return;
            }
            AbstractFeature e = null;
            if (t instanceof FeatureTrack) {
                Feature feature;
                int center = (int)vc.getCenter();
                FeatureTrack ft = (FeatureTrack)t;
                if (ft.getDisplayMode() == Track.DisplayMode.COLLAPSED || ft.getSelectedFeatureRowIndex() == -1) {
                    MessageUtils.showMessage("Exon navigation is only allowed when track is expanded and a single feature row is selected.");
                    return;
                }
                List<Feature> featureList = ft.getFeaturesAtPositionInFeatureRow(center, ft.getSelectedFeatureRowIndex(), vc);
                Feature feature2 = feature = featureList != null && featureList.size() > 0 ? featureList.get(0) : null;
                if (feature == null) {
                    return;
                }
                if (feature instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)feature;
                    List<Exon> exons = bf.getExons();
                    if (exons == null || exons.isEmpty()) {
                        MessageUtils.showMessage("At least one centered feature does not have exon structure");
                        return;
                    }
                    if (forward) {
                        for (Exon exon : bf.getExons()) {
                            if (!((double)exon.getStart() > vc.getCenter() + 1.0)) continue;
                            e = exon;
                            break;
                        }
                    } else {
                        for (int i = exons.size() - 1; i >= 0; --i) {
                            Exon exon = exons.get(i);
                            if (!((double)exon.getEnd() < vc.getCenter())) continue;
                            e = exon;
                            break;
                        }
                    }
                }
                if (e != null) {
                    vc.centerOnLocation(forward ? (double)e.getStart() : (double)e.getEnd());
                    int n = 3;
                }
            }
        }
    }

    private void nextFeature(boolean forward) {
        if (FrameManager.isGeneListMode()) {
            return;
        }
        ReferenceFrame frame = FrameManager.getDefaultFrame();
        List<Track> tracks = IGV.getInstance().getSelectedTracks();
        if (tracks.size() == 1) {
            try {
                Track t = (Track)tracks.iterator().next();
                if (!(t instanceof FeatureTrack) && !(t instanceof VariantTrack)) {
                    return;
                }
                Feature f = null;
                if (t instanceof FeatureTrack) {
                    f = ((FeatureTrack)t).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                } else if (t instanceof VariantTrack) {
                    f = ((VariantTrack)t).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                }
                if (f != null) {
                    String chr = GenomeManager.getInstance().getCurrentGenome().getCanonicalChrName(f.getChr());
                    double newCenter = f.getStart();
                    if (!chr.equals(frame.getChrName())) {
                        double range = frame.getEnd() - frame.getOrigin();
                        int newOrigin = (int)Math.max(newCenter - range / 2.0, 0.0);
                        int newEnd = (int)((double)newOrigin + range);
                        frame.jumpTo(chr, newOrigin, newEnd);
                    } else {
                        frame.centerOnLocation(newCenter);
                    }
                }
            }
            catch (IOException e) {
                MessageUtils.showErrorMessage("Error encountered reading features: " + e.getMessage(), e);
            }
        }
    }

    private class EnableWrappedAction
    extends AbstractAction {
        private Action action;

        private EnableWrappedAction(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            this.action.actionPerformed(e);
            this.setEnabled(true);
        }
    }
}

