/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class CombinedDataSource
implements DataSource {
    private static Logger log = LogManager.getLogger(CombinedDataSource.class);
    DataTrack trackl;
    DataTrack track2;
    Operation operation = Operation.ADD;

    public CombinedDataSource(DataTrack trackl, DataTrack track2, Operation operation) {
        this.trackl = trackl;
        this.track2 = track2;
        this.operation = operation;
    }

    public void updateTrackReferences(List<Track> allTracks) {
        this.trackl = this.updateTrackReference(this.trackl, allTracks);
        this.track2 = this.updateTrackReference(this.track2, allTracks);
    }

    public DataTrack getTrackl() {
        return this.trackl;
    }

    public DataTrack getTrack2() {
        return this.track2;
    }

    public Operation getOperation() {
        return this.operation;
    }

    private DataTrack updateTrackReference(DataTrack memberTrack, List<Track> allTracks) {
        if (memberTrack.getName() == null && memberTrack.getResourceLocator() == null) {
            DataTrack matchingTrack = (DataTrack)IGVSessionReader.getMatchingTrack(memberTrack.getId(), allTracks);
            if (matchingTrack == null) {
                throw new IllegalStateException("Could not find track with ID " + memberTrack.getId());
            }
            return matchingTrack;
        }
        return memberTrack;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<LocusScore> outerScores = this.trackl.getSummaryScores(chr, startLocation, endLocation, zoom).getFeatures();
        List<LocusScore> innerScores = this.track2.getSummaryScores(chr, startLocation, endLocation, zoom).getFeatures();
        int initialSize = outerScores.size() + innerScores.size();
        ArrayList<LocusScore> combinedScoresList = new ArrayList<LocusScore>(initialSize);
        if (initialSize == 0) {
            return combinedScoresList;
        }
        if (innerScores.size() == 0) {
            return outerScores;
        }
        if (outerScores.size() == 0) {
            return innerScores;
        }
        LinkedHashSet<Integer> boundariesSet = new LinkedHashSet<Integer>(2 * initialSize);
        UnmodifiableIterator dualIter = Iterators.mergeSorted(Arrays.asList(innerScores.iterator(), outerScores.iterator()), (Comparator)new Comparator<LocusScore>(){

            @Override
            public int compare(LocusScore o1, LocusScore o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        while (dualIter.hasNext()) {
            LocusScore score = (LocusScore)dualIter.next();
            boundariesSet.add(score.getStart());
            boundariesSet.add(score.getEnd());
        }
        Object[] boundariesArray = boundariesSet.toArray(new Integer[0]);
        Arrays.sort(boundariesArray);
        int outerScoreInd = 0;
        int innerScoreInd = 0;
        for (int bb = 0; bb < boundariesArray.length - 1; ++bb) {
            int start = (Integer)boundariesArray[bb];
            int end = (Integer)boundariesArray[bb + 1];
            outerScoreInd = this.findContains(start, end, outerScores, Math.max(outerScoreInd, 0));
            innerScoreInd = this.findContains(start, end, innerScores, Math.max(innerScoreInd, 0));
            LocusScore outerScore = this.getContains(outerScores, outerScoreInd);
            LocusScore innerScore = this.getContains(innerScores, innerScoreInd);
            if (outerScore == null && innerScore == null) continue;
            float score = this.combineScores(outerScore, innerScore);
            BasicScore newScore = new BasicScore(start, end, score);
            combinedScoresList.add(newScore);
        }
        return combinedScoresList;
    }

    private int findContains(int start, int end, List<LocusScore> scoresList, int startIndex) {
        for (int ii = startIndex; ii < scoresList.size(); ++ii) {
            LocusScore score = scoresList.get(ii);
            if (score.getStart() <= start && score.getEnd() >= end) {
                return ii;
            }
            if (score.getStart() < end) continue;
            return -1;
        }
        return -1;
    }

    private LocusScore getContains(List<LocusScore> scores, int index) {
        if (index >= 0 && index < scores.size()) {
            return scores.get(index);
        }
        return null;
    }

    private float combineScores(LocusScore score0, LocusScore score1) {
        if (score0 == null && score1 == null) {
            throw new IllegalArgumentException("Both inputs cannot be null");
        }
        if (score0 == null) {
            score0 = new BasicScore(score1.getStart(), score1.getEnd(), 0.0f);
        } else if (score1 == null) {
            score1 = new BasicScore(score0.getStart(), score0.getEnd(), 0.0f);
        }
        switch (this.operation) {
            case ADD: {
                return score0.getScore() + score1.getScore();
            }
            case SUBTRACT: {
                return score0.getScore() - score1.getScore();
            }
            case MULTIPLY: {
                return score0.getScore() * score1.getScore();
            }
            case DIVIDE: {
                if (score1.getScore() == 0.0f) {
                    return 0.0f;
                }
                return score0.getScore() / score1.getScore();
            }
        }
        throw new IllegalStateException("Operation not recognized: " + this.operation);
    }

    @Override
    public double getDataMax() {
        return 0.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.PLUGIN;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.none;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public void dispose() {
        if (this.trackl != null) {
            this.trackl.dispose();
        }
        if (this.track2 != null) {
            this.track2.dispose();
        }
    }

    public static enum Operation {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/");

        private String stringRep;

        private Operation(String stringrep) {
            this.stringRep = stringrep;
        }
    }
}

