/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.iterators;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class FlatteningIterator
implements Iterator {
    private final Object blank = new Object();
    private final Stack<Iterator<?>> iterators = new Stack();
    private Object next = this.blank;

    public FlatteningIterator(Object ... objects) {
        this.iterators.push(Arrays.asList(objects).iterator());
    }

    @Override
    public void remove() {
    }

    private void moveToNext() {
        if (this.next == this.blank && !this.iterators.empty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.pop();
                this.moveToNext();
            } else {
                Object nextOne = this.iterators.peek().next();
                if (nextOne instanceof Iterator) {
                    this.iterators.push((Iterator)nextOne);
                    this.moveToNext();
                } else if (nextOne instanceof Iterable) {
                    this.iterators.push(((Iterable)nextOne).iterator());
                    this.moveToNext();
                } else if (nextOne instanceof Array) {
                    this.iterators.push(Arrays.asList((Array)nextOne).iterator());
                    this.moveToNext();
                } else {
                    this.next = nextOne;
                }
            }
        }
    }

    public Object next() {
        this.moveToNext();
        if (this.next == this.blank) {
            throw new NoSuchElementException();
        }
        Object nextOne = this.next;
        this.next = this.blank;
        return nextOne;
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return this.next != this.blank;
    }
}

