/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class RepositionableInputStream
extends InputStream
implements RepositionableStream {
    private InputStream delegate;
    private String resource;
    private long currentPosition = 0L;
    private long markedPosition;
    private boolean isLocalFile;
    private FileChannel channel;
    private static Logger LOG = Logger.getLogger(RepositionableInputStream.class);

    public RepositionableInputStream(String resource) throws IOException {
        this.resource = resource;
        this.delegate = RepositionableInputStream.getStream(resource);
        if (RepositionableInputStream.isLocalFile(resource)) {
            this.isLocalFile = true;
            this.channel = ((FileInputStream)this.delegate).getChannel();
        }
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        ++this.currentPosition;
        return read;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int read = this.delegate.read(bytes);
        this.currentPosition += (long)read;
        return read;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int read = this.delegate.read(bytes, i, i1);
        this.currentPosition += (long)read;
        return read;
    }

    @Override
    public long skip(long l) throws IOException {
        long skip = this.delegate.skip(l);
        this.currentPosition += l;
        return skip;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        if (this.isLocalFile && this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public synchronized void mark(int i) {
        this.markedPosition = this.currentPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.close();
        this.delegate = null;
        this.delegate = RepositionableInputStream.getStream(this.resource, this.markedPosition);
        this.currentPosition = this.markedPosition;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void position(long p) throws IOException {
        if (this.isLocalFile) {
            this.channel.position(p);
        } else if (p != this.currentPosition) {
            this.currentPosition = p;
            this.delegate.close();
            this.delegate = null;
            this.delegate = RepositionableInputStream.getStream(this.resource, p);
        }
    }

    @Override
    public long position() throws IOException {
        return this.currentPosition;
    }

    public static InputStream getStream(String resource) throws IOException {
        return RepositionableInputStream.getStream(resource, 0L);
    }

    public static InputStream getStream(String resource, long startOffset) throws IOException {
        try {
            URL url = new URL(resource);
            if (!"file".equals(url.getProtocol())) {
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestProperty("first-byte-pos", Long.toString(startOffset));
                LOG.debug(String.format("Opening URL=%s at startOffset=%d", resource, startOffset));
                return urlConnection.getInputStream();
            }
            resource = resource.replaceFirst("file://", "");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new FileInputStream(resource);
    }

    public static boolean isLocalFile(String resource) {
        try {
            URL url = new URL(resource);
            return "file".equals(url.getProtocol());
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    public static boolean resourceExist(String resource) {
        try {
            URL url = new URL(resource);
            if (!"file".equals(url.getProtocol())) {
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                int code = huc.getResponseCode();
                return code == 200;
            }
            resource = resource.replaceFirst("file://", "");
        }
        catch (MalformedURLException e) {
        }
        catch (ProtocolException e) {
            throw new RuntimeException("Unable to determe if URL exists, likely a non HTTP or file url: " + resource);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File(resource).exists();
    }

    public static RepositionableStream get(String resource) throws IOException {
        return new RepositionableInputStream(resource);
    }
}

