/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.GenotypeRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.ScatterplotRenderer;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.tribble.readers.AsciiLineReader;

public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);
    public static final Pattern TAB_PATTERN = Pattern.compile("\t");
    public static final Pattern COMMA_PATTERN = Pattern.compile(",");
    public static final Pattern SEMI_COLON_PATTERN = Pattern.compile(";");
    public static final Pattern EQ_PATTERN = Pattern.compile("=");

    public static BufferedReader openBufferedReader(String pathOrUrl) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(pathOrUrl)));
        return reader;
    }

    public static BufferedReader openBufferedReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStreamGZ(locator);
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStreamGZ(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(String path) throws IOException {
        return ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
    }

    public static InputStream openInputStreamGZ(ResourceLocator locator) throws IOException {
        if (locator.getServerURL() != null) {
            URL url = new URL(locator.getServerURL() + "?method=getContents&file=" + locator.getPath());
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            try {
                return new GZIPInputStream(is);
            }
            catch (Exception ex) {
                log.error("Error with gzip stream", ex);
                throw new RuntimeException("There was a server error loading file: " + locator.getTrackName() + ". Please report to igv-team@broadinstitute.org");
            }
        }
        InputStream inputStream = null;
        HttpUtils.getInstance();
        if (HttpUtils.isURL(locator.getPath())) {
            URL url = new URL(locator.getPath());
            inputStream = HttpUtils.getInstance().openConnectionStream(url);
        } else {
            String path = locator.getPath();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static int parseInt(String string) {
        return (int)Double.parseDouble(string);
    }

    public static long getContentLength(String path) {
        try {
            long contentLength = -1L;
            if (path.startsWith("http:") || path.startsWith("https:")) {
                URL url = new URL(path);
                contentLength = HttpUtils.getInstance().getContentLength(url);
            } else if (path.startsWith("ftp:")) {
                URL url = new URL(path);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(Globals.CONNECT_TIMEOUT);
                contentLength = connection.getContentLength();
            } else {
                contentLength = new File(path).length();
            }
            return contentLength;
        }
        catch (IOException e) {
            log.error("Error getting content length for: " + path, e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int estimateLineCount(String path) {
        AsciiLineReader reader = null;
        try {
            int nLines;
            String nextLine;
            int defaultLength = 100000;
            long fileLength = ParsingUtils.getContentLength(path);
            if (fileLength <= 0L) {
                int n = 100000;
                return n;
            }
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(path));
            int lines = 0;
            int nSkip = 10;
            while (nSkip-- > 0 && reader.readLine() != null) {
            }
            long startPos = reader.getPosition();
            while ((nextLine = reader.readLine()) != null & lines < 100) {
                ++lines;
            }
            if (lines == 0) {
                int n = 100000;
                return n;
            }
            double bytesPerLine = (reader.getPosition() - startPos) / (long)lines;
            int n = nLines = (int)((double)fileLength / bytesPerLine);
            return n;
        }
        catch (Exception e) {
            log.error("Error estimating line count", e);
            int n = 1000;
            return n;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    public static int split(String aString, String[] tokens, char delim) {
        return org.broad.tribble.util.ParsingUtils.split(aString, tokens, delim);
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        return org.broad.tribble.util.ParsingUtils.splitWhitespace(aString, tokens);
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e) {
                    log.error("Error parsing numer in line: " + nextLine);
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean parseTrackLine(String nextLine, TrackProperties trackProperties) throws NumberFormatException {
        boolean foundProperties = false;
        try {
            List<String> tokens = StringUtils.breakQuotedString(nextLine, ' ');
            for (String pair : tokens) {
                List<String> kv = StringUtils.breakQuotedString(pair, '=');
                if (kv.size() != 2) continue;
                foundProperties = true;
                String key = kv.get(0).toLowerCase().trim();
                String value = kv.get(1).replaceAll("\"", "");
                if (key.equals("coords")) {
                    if (value.equals("0")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ZERO);
                    } else if (value.equals("1")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ONE);
                    }
                }
                if (key.equals("name")) {
                    trackProperties.setName(value);
                    if (!value.equals("junctions")) continue;
                    trackProperties.setRendererClass(SpliceJunctionRenderer.class);
                    trackProperties.setHeight(60);
                    continue;
                }
                if (key.equals("description")) {
                    trackProperties.setDescription(value);
                    continue;
                }
                String valueLowerCase = value.toLowerCase();
                if (key.equals("itemrgb")) {
                    trackProperties.setItemRGB(valueLowerCase.equals("on") || value.equals("1"));
                    continue;
                }
                if (key.equals("usescore")) {
                    trackProperties.setUseScore(value.equals("1"));
                    continue;
                }
                if (key.equals("color")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setColor(color);
                    continue;
                }
                if (key.equals("altcolor")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setAltColor(color);
                    continue;
                }
                if (key.equals("midcolor")) {
                    Color color = ColorUtilities.stringToColor(value);
                    trackProperties.setMidColor(color);
                    continue;
                }
                if (key.equals("autoscale")) {
                    boolean autoscale = value.equals("on");
                    trackProperties.setAutoScale(autoscale);
                    continue;
                }
                if (key.equals("maxheightpixels")) {
                    String[] maxDefMin = value.split(":");
                    if (maxDefMin.length >= 2) {
                        int defIDX = maxDefMin.length == 2 ? 0 : 1;
                        trackProperties.setHeight(Integer.parseInt(maxDefMin[defIDX].trim()));
                        trackProperties.setMinHeight(Integer.parseInt(maxDefMin[defIDX + 1].trim()));
                        continue;
                    }
                    trackProperties.setHeight(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("url")) {
                    trackProperties.setUrl(value);
                    continue;
                }
                if (key.equals("graphtype")) {
                    if (value.equals("bar")) {
                        trackProperties.setRendererClass(BarChartRenderer.class);
                        continue;
                    }
                    if (value.equals("points")) {
                        trackProperties.setRendererClass(ScatterplotRenderer.class);
                        trackProperties.setWindowingFunction(WindowFunction.none);
                        continue;
                    }
                    if (value.equals("line")) {
                        trackProperties.setRendererClass(LineplotRenderer.class);
                        continue;
                    }
                    if (value.equals("heatmap")) {
                        trackProperties.setRendererClass(HeatmapRenderer.class);
                        continue;
                    }
                    if (value.equals("junctions")) {
                        trackProperties.setRendererClass(SpliceJunctionRenderer.class);
                        continue;
                    }
                    if (!value.equals("genotype")) continue;
                    trackProperties.setRendererClass(GenotypeRenderer.class);
                    continue;
                }
                if (key.toLowerCase().equals("viewlimits")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float min = Float.parseFloat(limits[0].trim());
                        float max = Float.parseFloat(limits[1].trim());
                        trackProperties.setMinValue(min);
                        trackProperties.setMaxValue(max);
                    }
                    catch (NumberFormatException e) {
                        log.error("viewLimits values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("midrange")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float from = Float.parseFloat(limits[0].trim());
                        float to = Float.parseFloat(limits[1].trim());
                        trackProperties.setNeutralFromValue(from);
                        trackProperties.setNeutralToValue(to);
                    }
                    catch (NumberFormatException e) {
                        log.error("midrange values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("ylinemark")) {
                    try {
                        float yLine = Float.parseFloat(value);
                        trackProperties.setyLine(yLine);
                    }
                    catch (NumberFormatException e) {
                        log.error("Number format exception in track line (ylinemark): " + nextLine);
                    }
                    continue;
                }
                if (key.equals("ylineonoff")) {
                    trackProperties.setDrawYLine(value.equals("on"));
                    continue;
                }
                if (key.equals("windowingfunction")) {
                    if (value.equals("maximum")) {
                        trackProperties.setWindowingFunction(WindowFunction.max);
                        continue;
                    }
                    if (value.equals("minimum")) {
                        trackProperties.setWindowingFunction(WindowFunction.min);
                        continue;
                    }
                    if (value.equals("mean")) {
                        trackProperties.setWindowingFunction(WindowFunction.mean);
                        continue;
                    }
                    if (value.equals("median")) {
                        trackProperties.setWindowingFunction(WindowFunction.median);
                        continue;
                    }
                    if (value.equals("percentile10")) {
                        trackProperties.setWindowingFunction(WindowFunction.percentile10);
                        continue;
                    }
                    if (value.equals("percentile90")) {
                        trackProperties.setWindowingFunction(WindowFunction.percentile90);
                        continue;
                    }
                    if (!value.equals("none")) continue;
                    trackProperties.setWindowingFunction(WindowFunction.none);
                    continue;
                }
                if (key.equals("maxfeaturewindow") || key.equals("featurevisibilitywindow") || key.equals("visibilitywindow")) {
                    try {
                        int windowSize = Integer.parseInt(value);
                        trackProperties.setFeatureVisibilityWindow(windowSize);
                    }
                    catch (NumberFormatException e) {
                        log.error(key + " must be numeric: " + nextLine);
                    }
                    continue;
                }
                if (key.equals("scaletype")) {
                    if (!value.equals("log")) continue;
                    trackProperties.setLogScale(true);
                    continue;
                }
                if (key.equals("gfftags")) {
                    boolean gffTags = !value.equals("0") && !valueLowerCase.equals("off");
                    trackProperties.setGffTags(gffTags);
                    continue;
                }
                if (key.equals("sortable")) {
                    boolean sortable = value.equals("1") || valueLowerCase.equals("true");
                    trackProperties.setSortable(sortable);
                    continue;
                }
                if (key.equals("alternateexoncolor")) {
                    trackProperties.setAlternateExonColor(valueLowerCase.equals("on") || value.equals("1"));
                    continue;
                }
                if (key.equals("visibility")) {
                    if (valueLowerCase.equals("1") || valueLowerCase.equals("dense")) {
                        trackProperties.setDisplayMode(Track.DisplayMode.COLLAPSED);
                        continue;
                    }
                    if (valueLowerCase.equals("2") || valueLowerCase.equals("3") || valueLowerCase.equals("pack")) {
                        trackProperties.setDisplayMode(Track.DisplayMode.EXPANDED);
                        continue;
                    }
                    if (!valueLowerCase.equals("4") && !valueLowerCase.equals("squish")) continue;
                    trackProperties.setDisplayMode(Track.DisplayMode.SQUISHED);
                    continue;
                }
                if (key.equals("genome") || key.equals("db")) {
                    trackProperties.setGenome(value);
                    continue;
                }
                if (key.equals("bigdataurl") || key.equals("dataurl")) {
                    trackProperties.setDataURL(value);
                    continue;
                }
                if (!key.equals("meta")) continue;
                trackProperties.setMetaData(value);
            }
        }
        catch (Exception exception) {
            MessageUtils.showMessage("Error parsing track line: " + nextLine + " (" + exception.getMessage() + ")");
        }
        return foundProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean pathExists(String covPath) {
        try {
            if (new File(covPath).exists()) return true;
            HttpUtils.getInstance();
            if (!HttpUtils.isURL(covPath)) return false;
            if (!HttpUtils.getInstance().resourceAvailable(new URL(covPath))) return false;
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

