/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.UCSCParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.util.ParsingUtils;

public class BEDFileParser
extends UCSCParser {
    private static Logger log = Logger.getLogger(BEDFileParser.class);
    private GFFParser.GFF3Helper tagHelper = new GFFParser.GFF3Helper();
    Genome genome;

    public BEDFileParser(Genome genome) {
        this.genome = genome;
    }

    @Override
    public BasicFeature parseLine(String[] tokens, int tokenCount) {
        Class rendererClass;
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.genome == null ? tokens[0] : this.genome.getChromosomeAlias(tokens[0]);
        int start = Integer.parseInt(tokens[1]) - this.startBase;
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        BasicFeature feature = null;
        boolean isSpliceJunction = false;
        if (this.trackProperties != null && (rendererClass = this.trackProperties.getRendererClass()) != null && rendererClass.isAssignableFrom(SpliceJunctionRenderer.class)) {
            isSpliceJunction = true;
        }
        feature = isSpliceJunction ? new SpliceJunctionFeature(chr, start, end) : new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            if (this.gffTags) {
                String geneSymbols;
                LinkedHashMap<String, String> atts = new LinkedHashMap<String, String>();
                this.tagHelper.parseAttributes(tokens[3], atts);
                String name = this.tagHelper.getName(atts);
                feature.setName(name);
                String id = (String)atts.get("ID");
                if (id != null) {
                    FeatureDB.put(id.toUpperCase(), feature);
                    feature.setIdentifier(id);
                } else {
                    feature.setIdentifier(name);
                }
                String alias = (String)atts.get("Alias");
                if (alias != null) {
                    FeatureDB.put(alias.toUpperCase(), feature);
                }
                if ((geneSymbols = (String)atts.get("Symbol")) != null) {
                    String[] symbols;
                    for (String sym : symbols = geneSymbols.split(",")) {
                        FeatureDB.put(sym.trim().toUpperCase(), feature);
                    }
                }
                String description = GFFParser.getDescription(atts);
                feature.setDescription(description);
            } else {
                String name = tokens[3].replaceAll("\"", "");
                feature.setName(name);
                feature.setIdentifier(name);
            }
        }
        if (tokenCount > 4) {
            try {
                float score = Float.parseFloat(tokens[4]);
                feature.setScore(score);
                if (isSpliceJunction) {
                    ((SpliceJunctionFeature)feature).setJunctionDepth((int)score);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return feature;
            }
        }
        if (tokenCount > 5) {
            int strand;
            String strandString = tokens[5].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 7) {
            feature.setThickStart(Integer.parseInt(tokens[6]));
            feature.setThickEnd(Integer.parseInt(tokens[7]));
        }
        if (tokenCount > 8) {
            String[] rgb = new String[3];
            int nTokens = ParsingUtils.split(tokens[8].replaceAll("\"", ""), rgb, ',');
            feature.setColor(rgb, nTokens);
        }
        if (tokenCount > 11) {
            this.createExons(start, tokens, feature, chr, feature.getStrand());
            if (isSpliceJunction) {
                SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                List<Exon> exons = feature.getExons();
                junctionFeature.setJunctionStart(start + exons.get(0).getLength());
                junctionFeature.setJunctionEnd(end - exons.get(1).getLength());
                new StringBuilder();
            }
        }
        return feature;
    }

    private void createExons(int start, String[] tokens, BasicFeature gene, String chr, Strand strand) throws NumberFormatException {
        int exonNumber;
        int cdStart = Integer.parseInt(tokens[6]) - this.startBase;
        int cdEnd = Integer.parseInt(tokens[7]);
        int exonCount = Integer.parseInt(tokens[9]);
        String[] exonSizes = new String[exonCount];
        String[] startsBuffer = new String[exonCount];
        ParsingUtils.split(tokens[10], exonSizes, ',');
        ParsingUtils.split(tokens[11], startsBuffer, ',');
        int n = exonNumber = strand == Strand.NEGATIVE ? exonCount : 1;
        if (startsBuffer.length == exonSizes.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonStart = start + Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + Integer.parseInt(exonSizes[i]);
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                exon.setCodingStart(cdStart);
                exon.setCodingEnd(cdEnd);
                exon.setNumber(exonNumber);
                gene.addExon(exon);
                if (strand == Strand.NEGATIVE) {
                    --exonNumber;
                    continue;
                }
                ++exonNumber;
            }
        }
    }
}

