/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cbio;

import biz.source_code.base64Coder.Base64Coder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DirectedMultigraph;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneNetwork
extends DirectedMultigraph<Node, Node> {
    private Logger log = Logger.getLogger(GeneNetwork.class);
    public static final String NODE_TAG = "node";
    public static final String EDGE_TAG = "edge";
    public static final String KEY = "key";
    public static final String LABEL = "label";
    static final String REAL_URL = "http://www.cbioportal.org/public-portal/network.do";
    static final String TEST_URL = "http://awabi.cbio.mskcc.org/public-portal/network.do";
    static String BASE_URL = "http://www.cbioportal.org/public-portal/network.do";
    private static final String common_parms = "format=gml&gzip=on";
    private static final String GENE_LIST = "gene_list";
    private Map<String, Node> nodeTable;
    private List<Node> schema = new ArrayList<Node>();
    private NamedNodeMap graphAttr;
    private Document origDocument;
    static Map<String, RegionScoreType> attributeMap = new HashMap<String, RegionScoreType>();
    private static Map<String, float[]> bounds = new HashMap<String, float[]>(8);
    private Set<Node> rejectedNodes = new HashSet<Node>();
    private Set<Node> rejectedEdges = new HashSet<Node>();
    private boolean filtersFinalized;
    public static final String PERCENT_ALTERED = "PERCENT_ALTERED";

    public GeneNetwork() {
        this(Node.class);
    }

    public GeneNetwork(EdgeFactory edgeFactory) {
        super(edgeFactory);
    }

    public GeneNetwork(Class clazz) {
        super(clazz);
    }

    private int filter(Predicate predicate, Iterable<Node> objects, Set rejectSet) {
        if (this.filtersFinalized) {
            throw new IllegalStateException("Cannot filter after filtering has been finalized");
        }
        int filtered = 0;
        for (Node v : objects) {
            String in_query = GeneNetwork.getNodeAttrValue(v, KEY, "IN_QUERY");
            if (Boolean.parseBoolean(in_query) || predicate.evaluate(v)) continue;
            filtered += rejectSet.add(v) ? 1 : 0;
        }
        return filtered;
    }

    public int filterNodes(Predicate predicate) {
        return this.filter(predicate, this.vertexSet(), this.rejectedNodes);
    }

    public int filterNodesRange(final String key, final float min, final float max) {
        Predicate<Node> pred = new Predicate<Node>(){

            @Override
            public boolean evaluate(Node object) {
                String sval = GeneNetwork.getNodeKeyData(object, key);
                if (sval != null) {
                    float fval = Float.parseFloat(sval);
                    return fval >= min && fval <= max;
                }
                return false;
            }
        };
        return this.filterNodes(pred);
    }

    public int filterEdges(Predicate predicate) {
        return this.filter(predicate, this.edgeSet(), this.rejectedEdges);
    }

    public Set<Node> vertexSetFiltered() {
        HashSet<Node> filteredSet = new HashSet<Node>(this.vertexSet());
        filteredSet.removeAll(this.rejectedNodes);
        return filteredSet;
    }

    public Set<Node> edgesOfFiltered(Node n) {
        if (this.rejectedNodes.contains(n)) {
            return new HashSet<Node>(0);
        }
        HashSet<Node> filteredEdges = new HashSet<Node>(this.edgesOf(n).size());
        for (Node edge : this.outgoingEdgesOf(n)) {
            if (this.rejectedNodes.contains(this.getEdgeTarget(edge)) || this.rejectedEdges.contains(edge)) continue;
            filteredEdges.add(edge);
        }
        for (Node edge : this.incomingEdgesOf(n)) {
            if (this.rejectedNodes.contains(this.getEdgeSource(edge)) || this.rejectedEdges.contains(edge)) continue;
            filteredEdges.add(edge);
        }
        return filteredEdges;
    }

    boolean finalizeFilters() {
        if (this.filtersFinalized) {
            throw new IllegalStateException("Cannot finalize filters twice");
        }
        boolean rejected = this.removeAllVertices(this.rejectedNodes);
        this.clearAllFilters();
        this.filtersFinalized = rejected |= this.removeAllEdges(this.rejectedEdges);
        return rejected;
    }

    public void clearNodeFilters() {
        if (this.filtersFinalized) {
            throw new IllegalStateException("Cannot clear filters after they have been finalized");
        }
        this.rejectedNodes.clear();
    }

    public void clearEdgeFilters() {
        if (this.filtersFinalized) {
            throw new IllegalStateException("Cannot clear filters after they have been finalized");
        }
        this.rejectedEdges.clear();
    }

    public void clearAllFilters() {
        this.clearNodeFilters();
        this.clearEdgeFilters();
    }

    public boolean pruneGraph() {
        Predicate<Node> min_connections = new Predicate<Node>(){

            @Override
            public boolean evaluate(Node object) {
                return GeneNetwork.this.edgesOf(object).size() >= 1;
            }
        };
        return this.filterNodes(min_connections) > 0;
    }

    public static GeneNetwork getFromCBIO(Iterable<String> geneList) throws IOException {
        String query = HttpUtils.buildURLString(geneList, "+");
        String url = BASE_URL + "?" + GENE_LIST + "=" + query + "&" + common_parms;
        GeneNetwork network = new GeneNetwork();
        network.loadNetwork(url);
        return network;
    }

    public int loadNetwork(String path) throws IOException {
        Object error = null;
        int numNodes = -1;
        try {
            Document document;
            InputStream cbioStream = ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
            this.origDocument = document = Utilities.createDOMDocumentFromXmlStream(cbioStream);
            this.addToSchema(document.getElementsByTagName(KEY));
            this.graphAttr = document.getElementsByTagName("graph").item(0).getAttributes();
            NodeList nodes = document.getElementsByTagName(NODE_TAG);
            this.nodeTable = new HashMap<String, Node>(nodes.getLength());
            for (int nn = 0; nn < nodes.getLength(); ++nn) {
                Node node = nodes.item(nn);
                String label = node.getAttributes().getNamedItem("id").getTextContent();
                this.nodeTable.put(label, node);
                this.addVertex(node);
            }
            NodeList edges = document.getElementsByTagName(EDGE_TAG);
            for (int ee = 0; ee < edges.getLength(); ++ee) {
                Node edge = edges.item(ee);
                NamedNodeMap attrs = edge.getAttributes();
                String source = attrs.getNamedItem("source").getTextContent();
                String target = attrs.getNamedItem("target").getTextContent();
                this.addEdge(this.nodeTable.get(source), this.nodeTable.get(target), edge);
            }
            numNodes = this.vertexSet().size();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return numNodes;
    }

    private void addSchema(Collection<String> dataKeys, String dataType, String typeFor) {
        for (String dataKey : dataKeys) {
            Element key = this.origDocument.createElement(KEY);
            key.setAttribute("id", dataKey);
            key.setAttribute("attr.name", dataKey);
            key.setAttribute("attr.type", dataType.toLowerCase());
            if (typeFor != null) {
                key.setAttribute("for", typeFor);
            }
            this.schema.add(key);
        }
    }

    private void addToSchema(NodeList keys) {
        for (int kk = 0; kk < keys.getLength(); ++kk) {
            this.schema.add(keys.item(kk));
        }
    }

    public static String getNodeAttrValue(Node node, String attrName, String attrValue) {
        NodeList elements = node.getChildNodes();
        for (int ee = 0; ee < elements.getLength(); ++ee) {
            Node el = elements.item(ee);
            try {
                NamedNodeMap map = el.getAttributes();
                Node label = map.getNamedItem(attrName);
                String textContent = label.getTextContent();
                if (textContent.compareToIgnoreCase(attrValue) != 0) continue;
                return el.getTextContent();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getNodeKeyData(Node node, String key) {
        return GeneNetwork.getNodeAttrValue(node, KEY, key);
    }

    public Document createDocument() {
        if (!this.filtersFinalized) {
            this.finalizeFilters();
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setStrictErrorChecking(false);
            Element globalElement = document.createElement("graphml");
            for (Node node : this.schema) {
                globalElement.appendChild(node);
            }
            Element graphEl = document.createElement("graph");
            for (int aa = 0; aa < this.graphAttr.getLength(); ++aa) {
                Node attr = this.graphAttr.item(aa);
                graphEl.setAttribute(attr.getNodeName(), attr.getTextContent());
            }
            for (Node v : this.vertexSet()) {
                graphEl.appendChild(v);
            }
            for (Node e : this.edgeSet()) {
                graphEl.appendChild(e);
            }
            globalElement.appendChild(graphEl);
            document.appendChild(globalElement);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Error outputting graph");
        }
    }

    public static int writeEncodedString(String string, OutputStream outputStream, boolean gzip, boolean base64encode) throws IOException {
        byte[] byteData;
        if (gzip) {
            ByteArrayOutputStreamChild gmlByteStream = new ByteArrayOutputStreamChild(string.length() / 20);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(gmlByteStream);
            gzipOutputStream.write(string.getBytes());
            gzipOutputStream.finish();
            byteData = gmlByteStream.getBuf();
            gmlByteStream.close();
        } else {
            byteData = string.getBytes();
        }
        int count = 0;
        if (base64encode) {
            char[] gmlData;
            for (char c : gmlData = Base64Coder.encode(byteData)) {
                outputStream.write(c);
                ++count;
            }
        } else {
            outputStream.write(byteData);
            outputStream.flush();
            count += byteData.length;
        }
        outputStream.flush();
        return count;
    }

    public int exportGraph(String outputFile) throws IOException {
        boolean gzip = outputFile.endsWith(".gz");
        String xmlString = Utilities.getString(this.createDocument());
        FileOutputStream stream = new FileOutputStream(outputFile);
        int count = GeneNetwork.writeEncodedString(xmlString, stream, gzip, false);
        stream.flush();
        ((OutputStream)stream).close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String outputForcBioView() throws IOException {
        String outPath = null;
        BufferedReader reader = null;
        OutputStream outputStream = null;
        try {
            String line;
            File temp = File.createTempFile("cbio", ".html");
            temp.deleteOnExit();
            outPath = temp.getAbsolutePath();
            InputStreamReader fReader = new InputStreamReader(GeneNetwork.class.getResourceAsStream("resources/post_stub.html"));
            reader = new BufferedReader(fReader);
            outputStream = new FileOutputStream(outPath);
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("allthegraphmldatagoeshere")) {
                    GeneNetwork.writeEncodedString(Utilities.getString(this.createDocument()), outputStream, true, true);
                    continue;
                }
                outputStream.write((line + FileUtils.LINE_SEPARATOR).getBytes());
                outputStream.flush();
            }
            outputStream.flush();
        }
        catch (IOException e) {
            this.log.error("Error writing cBio stub form to " + outPath);
            this.log.error(e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return outPath;
    }

    public void annotate(List<Track> tracks, Collection<String> node_attributes) {
        Set nodes = this.vertexSet();
        for (Node node : nodes) {
            float rel_data;
            String name = GeneNetwork.getNodeKeyData(node, LABEL);
            ScoreData data = this.collectScoreData(name, tracks, node_attributes);
            if (data == null || (rel_data = data.getPercentAltered()) == 0.0f && !Globals.isTesting()) continue;
            for (String attr : node_attributes) {
                Element newData = node.getOwnerDocument().createElement("data");
                newData.setAttribute(KEY, attr);
                newData.setTextContent("" + data.get(attr));
                node.appendChild(newData);
            }
            Element newData = node.getOwnerDocument().createElement("data");
            newData.setAttribute(KEY, PERCENT_ALTERED);
            newData.setTextContent("" + data.getPercentAltered());
            node.appendChild(newData);
        }
        this.addSchema(Arrays.asList(PERCENT_ALTERED), "float", NODE_TAG);
        this.addSchema(node_attributes, "float", NODE_TAG);
    }

    public ScoreData collectScoreData(String name, List<Track> tracks, Iterable<String> attributes) {
        ReferenceFrame frame;
        int zoom = 0;
        List<NamedFeature> features = FeatureDB.getFeaturesList(name, Integer.MAX_VALUE);
        List<ReferenceFrame> frames = Globals.isHeadless() ? null : FrameManager.getFrames();
        ReferenceFrame referenceFrame = frame = Globals.isHeadless() ? null : FrameManager.getDefaultFrame();
        if (frames != null) {
            for (ReferenceFrame frm : frames) {
                if (!frm.getName().equalsIgnoreCase(name)) continue;
                frame = frm;
            }
        }
        String frameName = frame != null ? frame.getName() : null;
        ScoreData<String, Float> results = new ScoreData<String, Float>(RegionScoreType.values().length);
        int initCapacity = tracks.size() / 10;
        HashSet allSamples = new HashSet(initCapacity);
        HashSet anyAlteration = new HashSet(initCapacity);
        HashSet<String> samplesForType = new HashSet<String>(initCapacity);
        HashSet<String> alteredSamplesForType = new HashSet<String>(initCapacity);
        for (String attr : attributes) {
            if (!bounds.containsKey(attr)) {
                throw new IllegalArgumentException("Have no bounds for " + attr);
            }
            RegionScoreType type = attributeMap.get(attr);
            float[] curBounds = bounds.get(attr);
            samplesForType.clear();
            alteredSamplesForType.clear();
            for (NamedFeature feat : features) {
                if (!name.equalsIgnoreCase(feat.getName())) continue;
                int featStart = feat.getStart();
                int featEnd = feat.getEnd();
                for (Track track : tracks) {
                    String sample = track.getSample();
                    if (!track.isRegionScoreType(type) || alteredSamplesForType.contains(sample)) continue;
                    samplesForType.add(sample);
                    float score = track.getRegionScore(feat.getChr(), featStart, featEnd, zoom, type, frameName, tracks);
                    if (!(score >= curBounds[0]) || !(score <= curBounds[1]) || Float.isNaN(score)) continue;
                    alteredSamplesForType.add(sample);
                }
            }
            allSamples.addAll(samplesForType);
            anyAlteration.addAll(alteredSamplesForType);
            float percentAltered = (float)alteredSamplesForType.size() / (float)samplesForType.size();
            results.put(attr, Float.valueOf(percentAltered));
        }
        results.setPercentAltered((float)anyAlteration.size() / (float)allSamples.size());
        return results;
    }

    public void annotateAll(List<Track> tracks) {
        this.annotate(tracks, attributeMap.keySet());
    }

    static {
        attributeMap.put("PERCENT_MUTATED", RegionScoreType.MUTATION_COUNT);
        attributeMap.put("PERCENT_CNA_AMPLIFIED", RegionScoreType.AMPLIFICATION);
        attributeMap.put("PERCENT_CNA_HOMOZYGOUSLY_DELETED", RegionScoreType.DELETION);
        attributeMap.put("PERCENT_MRNA_WAY_UP", RegionScoreType.EXPRESSION);
        attributeMap.put("PERCENT_MRNA_WAY_DOWN", RegionScoreType.EXPRESSION);
        float max_val = 2048.0f;
        float mut = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_MUTATION_THRESHOLD", "0.1"));
        bounds.put("PERCENT_MUTATED", new float[]{mut, max_val});
        float amp = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_AMPLIFICATION_THRESHOLD", "0.9"));
        float[] ampbounds = new float[]{amp, max_val};
        bounds.put("PERCENT_CNA_AMPLIFIED", ampbounds);
        bounds.put("PERCENT_CNA_HOMOZYGOUSLY_DELETED", ampbounds);
        float exp = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_EXPRESSION_THRESHOLD", "0.1"));
        bounds.put("PERCENT_MRNA_WAY_UP", new float[]{exp, max_val});
        bounds.put("PERCENT_MRNA_WAY_DOWN", new float[]{-max_val, -exp});
    }

    private static class ByteArrayOutputStreamChild
    extends ByteArrayOutputStream {
        public ByteArrayOutputStreamChild() {
        }

        public ByteArrayOutputStreamChild(int size) {
            super(size);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }

    public static class ScoreData<K, V>
    extends HashMap<K, V> {
        private float percentAltered;

        public ScoreData() {
        }

        public ScoreData(int size) {
            super(size);
        }

        public void setPercentAltered(float percentAltered) {
            this.percentAltered = percentAltered;
        }

        public float getPercentAltered() {
            return this.percentAltered;
        }
    }
}

