/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.datastrutures.IntervalTree;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignmentIO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class MAFIO
implements MultipleAlignmentIO {
    SeekableStream fileHandle;
    String alignmentFile;
    private IntervalTree<Long> index;

    public MAFIO(String alignmentFile, boolean keepFileHandle) throws IOException, ParseException {
        this.alignmentFile = alignmentFile;
        if (keepFileHandle) {
            this.fileHandle = SeekableStreamFactory.getStreamFor(alignmentFile);
        }
        this.checkIndex(alignmentFile);
    }

    public MAFIO() {
    }

    @Override
    public String getPreferredFileExtension() {
        return ".maf";
    }

    public void destroyFileHandle() throws IOException {
        if (this.fileHandle != null) {
            this.fileHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAFAlignment load(List<String> sequencesToLoad, int start, int end) throws IOException, ParseException {
        MAFAlignment alignment = null;
        boolean closeFile = false;
        if (this.fileHandle == null) {
            closeFile = true;
            this.fileHandle = SeekableStreamFactory.getStreamFor(this.alignmentFile);
        }
        try {
            alignment = new MAFAlignment(this.index);
            alignment.load(this.fileHandle, start, end, sequencesToLoad);
        }
        finally {
            if (closeFile) {
                this.fileHandle.close();
                this.fileHandle = null;
            }
        }
        return alignment;
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma) throws IOException {
    }

    @Override
    public void write(BufferedWriter bw, MultipleAlignment ma, List<String> sequenceOrder) throws IOException {
    }

    private void checkIndex(String fileName) throws IOException, ParseException {
        String idxFileName = fileName + ".index";
        if (FileUtils.resourceExists(idxFileName)) {
            this.loadIndex(idxFileName);
        } else {
            if (FileUtils.isRemote(fileName)) {
                throw new RuntimeException("Index file not found: " + idxFileName);
            }
            this.createIndex(fileName);
            this.writeIndex(idxFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndex(String idxFile) throws IOException {
        this.index = new IntervalTree();
        BufferedReader br = null;
        try {
            br = ParsingUtils.openBufferedReader(idxFile);
            String line = null;
            int l = 0;
            while ((line = br.readLine()) != null) {
                if (l % 100 == 0) {
                    String[] info = line.split("\t");
                    int start = Integer.parseInt(info[0]);
                    int end = Integer.parseInt(info[1]) + start;
                    long offset = Long.parseLong(info[2]);
                    this.index.put(start, end, offset);
                }
                ++l;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String alignmentFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(alignmentFile, "r");
        this.index = new IntervalTree();
        String[] lineInfo = null;
        long lastOffset = 0L;
        try {
            String line;
            boolean readNext = false;
            while ((line = raf.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.startsWith("a ")) {
                    readNext = true;
                    lastOffset = raf.getFilePointer() - (long)line.getBytes().length - 1L;
                    continue;
                }
                if (line.startsWith("s ")) {
                    if (readNext) {
                        lineInfo = line.split("\\s+");
                        int start = Integer.parseInt(lineInfo[2]);
                        int end = Integer.parseInt(lineInfo[3]) + start;
                        this.index.put(start, end, lastOffset);
                    }
                    readNext = false;
                    continue;
                }
                if (line.startsWith("i ") || line.startsWith("q ")) continue;
                readNext = false;
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeIndex(String indexFileName) throws IOException {
        Iterator<IntervalTree.Node<Long>> idxEntryIt = this.index.iterator();
        BufferedWriter bw = new BufferedWriter(new FileWriter(indexFileName));
        while (idxEntryIt.hasNext()) {
            IntervalTree.Node<Long> entry = idxEntryIt.next();
            bw.write(String.valueOf(entry.getStart()));
            bw.write("\t" + String.valueOf(entry.getEnd() - entry.getStart()));
            bw.write("\t" + String.valueOf(entry.getValue()));
            bw.newLine();
        }
        bw.close();
    }
}

