/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.Matrix;

public class Dataset {
    private boolean caching = true;
    public Chromosome[] chromosomes;
    Map<String, Matrix> matrices = new HashMap<String, Matrix>(625);
    private DatasetReader reader;

    public Dataset(DatasetReader reader) {
        this.reader = reader;
        this.readChromosomes();
    }

    public void readChromosomes() {
    }

    public Matrix getMatrix(Chromosome chr1, Chromosome chr2) {
        int t2;
        int t1 = Math.min(chr1.getIndex(), chr2.getIndex());
        String key = Matrix.generateKey(t1, t2 = Math.max(chr1.getIndex(), chr2.getIndex()));
        Matrix m = this.matrices.get(key);
        if (m == null && this.reader != null) {
            try {
                m = this.reader.readMatrix(key);
                if (this.caching) {
                    this.matrices.put(key, m);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    public Chromosome[] getChromosomes() {
        return this.chromosomes;
    }

    public void setChromosomes(Chromosome[] chromosomes) {
        this.chromosomes = chromosomes;
    }
}

