/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broad.igv.Globals;
import org.broad.igv.dev.affective.AffectiveChromosome;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;

public class AffectiveGenome
implements Genome {
    TreeMap<Date, Chromosome> chromosomeMap;
    long length = 0L;
    private Map<String, Date> chrDateMap = new HashMap<String, Date>();
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();

    public AffectiveGenome() {
        this.chromosomeMap = new TreeMap(new Comparator<Date>(){

            @Override
            public int compare(Date date, Date date1) {
                if (date == null || date1 == null) {
                    return 0;
                }
                return date.compareTo(date1);
            }
        });
    }

    @Override
    public Chromosome getChromosome(String chrName) {
        if (!this.chrDateMap.containsKey(chrName)) {
            try {
                AffectiveChromosome.dateFormat.parse(chrName);
            }
            catch (ParseException e) {
                return null;
            }
            this.createChromosome(chrName);
        }
        Date date = this.chrDateMap.get(chrName);
        return this.chromosomeMap.get(date);
    }

    public void createChromosome(String chrName) {
        if (this.chrDateMap.containsKey(chrName)) {
            return;
        }
        AffectiveChromosome chromosome = new AffectiveChromosome(chrName);
        this.chrDateMap.put(chromosome.getName(), chromosome.date);
        this.chromosomeMap.put(chromosome.date, chromosome);
        this.length += (long)chromosome.getLength();
        if (!Globals.isHeadless()) {
            // empty if block
        }
    }

    @Override
    public String getId() {
        return "affective";
    }

    @Override
    public String getHomeChromosome() {
        if (this.getChromosomeNames().size() == 1) {
            return this.getChromosomeNames().get(0);
        }
        return "All";
    }

    @Override
    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    @Override
    public List<String> getChromosomeNames() {
        ArrayList<String> names = new ArrayList<String>(this.chromosomeMap.size());
        for (Chromosome chromosome : this.chromosomeMap.values()) {
            names.add(chromosome.getName());
        }
        return names;
    }

    @Override
    public String getChromosomeAlias(String str) {
        return str;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (Chromosome chromosome : this.chromosomeMap.values()) {
                if (chr.equals(chromosome.getName())) break;
                offset += (long)chromosome.getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    @Override
    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    @Override
    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        for (Chromosome chromosome : this.chromosomeMap.values()) {
            int chrLen = chromosome.getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(chromosome.getName(), bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = this.chromosomeMap.lastEntry().getValue().getName();
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    @Override
    public String getNextChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    @Override
    public String getPrevChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    @Override
    public byte[] getSequence(String chr, int start, int end) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Affective";
    }

    @Override
    public byte getReference(String chr, int pos) {
        return 0;
    }

    public void addChrAliases(Map<String, String> aliases) {
    }

    public void loadUserDefinedAliases() {
    }
}

