/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.SAMQueryIterator;
import org.broad.igv.util.HttpUtils;

public class CGIAlignmentReader
implements AlignmentReader {
    private static Logger log = Logger.getLogger(CGIAlignmentReader.class);
    String baseURL;
    String queryScript = "query.cgi";
    String headerScript = "samHeader.cgi";
    String seqNameScript = "getSequenceNames.cgi";
    String query;
    SAMFileHeader header;

    public CGIAlignmentReader(String url) throws MalformedURLException {
        URL u = new URL(url);
        int port = u.getPort();
        this.baseURL = u.getProtocol() + "://" + u.getHost();
        if (port > 0) {
            this.baseURL = this.baseURL + ":" + port;
        }
        this.baseURL = this.baseURL + u.getPath();
        this.query = u.getQuery();
        this.loadHeader();
    }

    String getHeaderURL() {
        return this.baseURL.replace(this.queryScript, this.headerScript) + "?" + this.query;
    }

    String getSequenceNamesURL() {
        return this.baseURL.replace(this.queryScript, this.seqNameScript) + "?" + this.query;
    }

    String getQueryURL() {
        return this.baseURL + "?" + this.query;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() {
        InputStream is = null;
        try {
            URL url = new URL(this.getHeaderURL());
            is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedLineReader reader = new BufferedLineReader(is);
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            this.header = codec.decode(reader, null);
        }
        catch (Exception ex) {
            log.info("Error loading header : " + ex.getMessage());
            this.header = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Error closing url stream", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSequenceNames() {
        InputStream is = null;
        try {
            String nextLine;
            URL url = new URL(this.getSequenceNamesURL());
            is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            HashSet<String> seqNames = new HashSet<String>();
            while ((nextLine = br.readLine()) != null) {
                String[] tokens;
                for (String seq : tokens = nextLine.split("\\s+")) {
                    seqNames.add(seq);
                }
            }
            HashSet<String> hashSet = seqNames;
            return hashSet;
        }
        catch (IOException e) {
            log.error("Error fetching sequence names", e);
            Set<String> set = null;
            return set;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error(e);
                }
            }
        }
    }

    @Override
    public SAMFileHeader getHeader() throws IOException {
        return this.header;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        try {
            URL url = new URL(this.getQueryURL());
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            SAMFileReader reader = new SAMFileReader(new BufferedInputStream(is, 500000));
            reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(iter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) throws IOException {
        try {
            String parameters = "&chr=" + sequence + "&start=" + start + "&end=" + end + "&contained=" + contained;
            URL url = new URL(this.getQueryURL() + parameters);
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            SAMFileReader reader = new SAMFileReader(new BufferedInputStream(is, 500000));
            reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(sequence, start, end, contained, iter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasIndex() {
        return false;
    }

    public static void main(String[] args) throws IOException {
        Globals.setHeadless(true);
        CGIAlignmentReader reader = new CGIAlignmentReader("http://philtest.batcave.net/query.cgi?file=input.sam");
        String chr = "gi|66043271|ref|NC_007005.1|";
        int start = 800;
        int end = 900;
        CloseableIterator<Alignment> iter = reader.query(chr, start, end, false);
        while (iter.hasNext()) {
            Alignment a = (Alignment)iter.next();
            System.out.println(a);
        }
    }
}

