/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public class BBCompressionUtils {
    private static Logger log = Logger.getLogger(BBCompressionUtils.class);

    public static byte[] decompress(byte[] data, int uncompressBufSize) {
        byte[] inbuf = data;
        int rem = data.length;
        int count = 0;
        int off = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(1.5 * (double)inbuf.length));
        byte[] outbuf = new byte[uncompressBufSize];
        while (rem > 0) {
            Inflater decompressor = new Inflater();
            decompressor.setInput(inbuf);
            try {
                uncompressBufSize = outbuf.length;
                count = decompressor.inflate(outbuf, 0, uncompressBufSize);
                rem = decompressor.getRemaining();
                if (rem > 0) {
                    inbuf = new byte[rem];
                    System.arraycopy(data, off += inbuf.length - rem, inbuf, 0, rem);
                    uncompressBufSize -= count;
                }
                bos.write(outbuf, 0, count);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] data, int compressBufSize) {
        Deflater compressor = new Deflater();
        compressor.setLevel(-1);
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[compressBufSize];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }
}

