/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.tribble.AsciiFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TabixFeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature>
implements FeatureReader<T> {
    private static final Logger log = Logger.getLogger("BasicFeatureSource");
    String path;
    protected final FeatureCodec codec;
    protected Object header;

    public static final AbstractFeatureReader getFeatureReader(String featureFile, FeatureCodec codec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureFile, codec, true);
    }

    public static final AbstractFeatureReader getFeatureReader(String featureResource, FeatureCodec codec, boolean requireIndex) throws TribbleException {
        try {
            if (featureResource.endsWith(".gz") && ParsingUtils.resourceExists(featureResource + ".tbi")) {
                return new TabixFeatureReader(featureResource, codec);
            }
            return new AsciiFeatureReader(featureResource, codec, requireIndex);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e);
        }
        catch (TribbleException e) {
            e.setSource(featureResource);
            throw e;
        }
    }

    public static final AbstractFeatureReader getFeatureReader(String featureResource, FeatureCodec codec, Index index) throws TribbleException {
        try {
            return new AsciiFeatureReader(featureResource, codec, index);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", featureResource, e);
        }
    }

    protected AbstractFeatureReader(String path, FeatureCodec codec) {
        this.path = path;
        this.codec = codec;
    }

    @Override
    public Object getHeader() {
        return this.header;
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

