/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;

public class MergedAlignmentReader
implements AlignmentReader {
    List<AlignmentReader> readers;
    List<String> sequenceNames;
    Map<String, Integer> sequenceNameIndex;

    public MergedAlignmentReader(List<AlignmentReader> readers) {
        this.readers = readers;
        this.loadSequenceNames();
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new MergedFileIterator();
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) throws IOException {
        return new MergedFileIterator(chr, start, end, contained);
    }

    @Override
    public void close() throws IOException {
        for (AlignmentReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    public void loadSequenceNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(50);
        for (AlignmentReader reader : this.readers) {
            names.addAll(reader.getSequenceNames());
        }
        this.sequenceNames = new ArrayList<String>(names);
        this.sequenceNameIndex = new HashMap<String, Integer>(this.sequenceNames.size());
        for (int i = 0; i < this.sequenceNames.size(); ++i) {
            this.sequenceNameIndex.put(this.sequenceNames.get(i), i);
        }
    }

    @Override
    public boolean hasIndex() {
        return this.readers.iterator().next().hasIndex();
    }

    public class MergedFileIterator
    implements CloseableIterator<Alignment> {
        List<CloseableIterator<Alignment>> allIterators = new ArrayList<CloseableIterator<Alignment>>();
        PriorityQueue<RecordIterWrapper> iteratorQueue;

        public MergedFileIterator() {
            try {
                this.create(null, -1, -1, false);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }

        public MergedFileIterator(String chr, int start, int end, boolean contained) throws IOException {
            this.create(chr, start, end, contained);
        }

        private void create(String chr, int start, int end, boolean contained) throws IOException {
            this.iteratorQueue = new PriorityQueue<RecordIterWrapper>(MergedAlignmentReader.this.readers.size(), new AlignmentStartComparator());
            boolean iterate = start == end && start == -1;
            for (AlignmentReader reader : MergedAlignmentReader.this.readers) {
                CloseableIterator<Alignment> iter = iterate ? reader.iterator() : reader.query(chr, start, end, contained);
                this.allIterators.add(iter);
                if (!iter.hasNext()) continue;
                this.iteratorQueue.add(new RecordIterWrapper(iter));
            }
        }

        @Override
        public boolean hasNext() {
            return this.iteratorQueue.size() > 0;
        }

        @Override
        public Alignment next() {
            RecordIterWrapper wrapper = this.iteratorQueue.poll();
            Alignment next = wrapper.advance();
            if (wrapper.hasNext()) {
                this.iteratorQueue.add(wrapper);
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }

        @Override
        public void close() {
            for (CloseableIterator<Alignment> iter : this.allIterators) {
                iter.close();
            }
            this.allIterators.clear();
            this.iteratorQueue.clear();
        }

        class AlignmentStartComparator
        implements Comparator<RecordIterWrapper> {
            AlignmentStartComparator() {
            }

            @Override
            public int compare(RecordIterWrapper wrapper1, RecordIterWrapper wrapper2) {
                int idx2;
                Alignment a1 = wrapper1.nextRecord;
                Alignment a2 = wrapper2.nextRecord;
                int idx1 = MergedAlignmentReader.this.sequenceNameIndex.get(a1.getChr());
                if (idx1 > (idx2 = MergedAlignmentReader.this.sequenceNameIndex.get(a2.getChr()).intValue())) {
                    return 1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return a1.getAlignmentStart() - a2.getAlignmentStart();
            }
        }

        class RecordIterWrapper {
            Alignment nextRecord;
            CloseableIterator<Alignment> iterator;

            RecordIterWrapper(CloseableIterator<Alignment> iter) {
                this.iterator = iter;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
            }

            Alignment advance() {
                Alignment tmp = this.nextRecord;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
                return tmp;
            }

            boolean hasNext() {
                return this.nextRecord != null;
            }

            void close() {
                if (this.iterator != null) {
                    System.out.println("Closing " + this);
                    this.iterator.close();
                    this.iterator = null;
                }
            }
        }
    }
}

