/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.readers.AsciiLineReader;

public class FastaIndex {
    static Logger log = Logger.getLogger(FastaIndex.class);
    static Pattern WHITE_SPACE = Pattern.compile("\\s+");
    private final LinkedHashMap<String, FastaSequenceIndexEntry> sequenceEntries = new LinkedHashMap();

    public FastaIndex(String indexPath) throws IOException {
        this.parseIndexFile(indexPath);
    }

    public Set<String> getSequenceNames() {
        return this.sequenceEntries.keySet();
    }

    public FastaSequenceIndexEntry getIndexEntry(String name) {
        return this.sequenceEntries.get(name);
    }

    public int getSequenceSize(String name) {
        FastaSequenceIndexEntry entry = this.sequenceEntries.get(name);
        return entry == null ? -1 : (int)entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndexFile(String inputPath, String outputPath) throws DataLoadException, IOException {
        AsciiLineReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new AsciiLineReader(ParsingUtils.openInputStream(inputPath));
            writer = new BufferedWriter(new FileWriter(outputPath));
            String line = null;
            String curContig = null;
            int basesPerLine = -1;
            int bytesPerLine = -1;
            long location = 0L;
            long size = 0L;
            long lastPosition = 0L;
            int numInconsistentLines = -1;
            boolean haveTasks = true;
            while (haveTasks) {
                line = reader.readLine();
                if (line == null || line.trim().length() == 0) {
                    line = null;
                }
                if (line == null || line.startsWith(">")) {
                    if (numInconsistentLines >= 2) {
                        throw new DataLoadException("Fasta file has uneven line lengths in contig " + curContig, inputPath);
                    }
                    if (curContig != null) {
                        FastaIndex.writeLine(writer, curContig, size, location, basesPerLine, bytesPerLine);
                    }
                    if (line == null) {
                        haveTasks = false;
                        break;
                    }
                    curContig = WHITE_SPACE.split(line)[0];
                    curContig = curContig.substring(1);
                    location = reader.getPosition();
                    size = 0L;
                    basesPerLine = -1;
                    bytesPerLine = -1;
                    numInconsistentLines = -1;
                } else {
                    int basesThisLine = line.length();
                    int bytesThisLine = (int)(reader.getPosition() - lastPosition);
                    if (numInconsistentLines < 0) {
                        basesPerLine = basesThisLine;
                        bytesPerLine = bytesThisLine;
                        numInconsistentLines = 0;
                    } else if (basesPerLine != basesThisLine || bytesPerLine != bytesThisLine) {
                        ++numInconsistentLines;
                    }
                    size += (long)basesThisLine;
                }
                lastPosition = reader.getPosition();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static void writeLine(Writer writer, String contig, long size, long location, int basesPerLine, int bytesPerLine) throws IOException {
        String delim = "\t";
        String line = contig + delim + size + delim + location + delim + basesPerLine + delim + bytesPerLine;
        writer.write(line);
        String newline = "\n";
        if (bytesPerLine - basesPerLine == 2) {
            newline = "\r\n";
        }
        writer.write(newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIndexFile(String indexFile) throws IOException {
        BufferedReader reader = null;
        String[] tokens = new String[5];
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(indexFile);
            while ((nextLine = reader.readLine()) != null) {
                int nTokens = ParsingUtils.splitWhitespace(nextLine, tokens);
                if (nTokens != 5) {
                    throw new RuntimeException("Error.  Unexpected number of tokens parsing: " + indexFile);
                }
                String contig = tokens[0];
                contig = GenomeImporter.SEQUENCE_NAME_SPLITTER.split(contig, 2)[0];
                long size = Long.parseLong(tokens[1]);
                long location = Long.parseLong(tokens[2]);
                int basesPerLine = Integer.parseInt(tokens[3]);
                int bytesPerLine = Integer.parseInt(tokens[4]);
                this.add(new FastaSequenceIndexEntry(contig, location, size, basesPerLine, bytesPerLine));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void add(FastaSequenceIndexEntry indexEntry) {
        FastaSequenceIndexEntry ret = this.sequenceEntries.put(indexEntry.getContig(), indexEntry);
        if (ret != null) {
            throw new RuntimeException("Contig '" + indexEntry.getContig() + "' already exists in fasta index.");
        }
    }

    static class FastaSequenceIndexEntry {
        private String contig;
        private long position;
        private long size;
        private int basesPerLine;
        private int bytesPerLine;

        public FastaSequenceIndexEntry(String contig, long position, long size, int basesPerLine, int bytesPerLine) {
            this.contig = contig;
            this.position = position;
            this.size = size;
            this.basesPerLine = basesPerLine;
            this.bytesPerLine = bytesPerLine;
        }

        public String getContig() {
            return this.contig;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public int getBasesPerLine() {
            return this.basesPerLine;
        }

        public int getBytesPerLine() {
            return this.bytesPerLine;
        }

        public String toString() {
            return String.format("contig %s; position %d; size %d; basesPerLine %d; bytesPerLine %d", this.contig, this.position, this.size, this.basesPerLine, this.bytesPerLine);
        }
    }
}

