/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.TrackGroupEvent;
import org.broad.igv.ui.event.TrackGroupEventListener;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantMenu;
import org.broad.igv.variant.VariantRenderer;
import org.broad.tribble.Feature;

public class VariantTrack
extends FeatureTrack
implements TrackGroupEventListener {
    private static Logger log = Logger.getLogger(VariantTrack.class);
    static final DecimalFormat numFormat = new DecimalFormat("#.###");
    private static final Color OFF_WHITE = new Color(170, 170, 170);
    private static final int GROUP_BORDER_WIDTH = 3;
    private static final Color BAND1_COLOR = new Color(245, 245, 245);
    private static final Color BAND2_COLOR = Color.white;
    private static final Color borderGray = new Color(200, 200, 200);
    private static final int DEFAULT_EXPANDED_GENOTYPE_HEIGHT = 15;
    private final int DEFAULT_SQUISHED_GENOTYPE_HEIGHT = 4;
    private static final int DEFAULT_VARIANT_BAND_HEIGHT = 25;
    private static final int MAX_FILTER_LINES = 15;
    public static int METHYLATION_MIN_BASE_COUNT = 10;
    private VariantRenderer renderer = new VariantRenderer(this);
    private boolean enableMethylationRateSupport;
    private int top;
    private int squishedHeight = 4;
    private int variantBandHeight = 25;
    List<String> allSamples;
    private boolean grouped;
    private String groupByAttribute;
    LinkedHashMap<String, List<String>> samplesByGroups = new LinkedHashMap();
    private ColorMode coloring = ColorMode.GENOTYPE;
    private boolean hideFiltered = false;
    private boolean renderID = true;
    private Variant selectedVariant;
    private List<SampleBounds> sampleBounds = new ArrayList<SampleBounds>();
    private List<String> selectedSamples = new ArrayList<String>();
    Map<String, String> alignmentFiles;
    static Map<String, String> fullNames = new HashMap<String, String>();

    public VariantTrack(ResourceLocator locator, FeatureSource source, List<String> samples, boolean enableMethylationRateSupport) {
        super(locator, source);
        this.enableMethylationRateSupport = enableMethylationRateSupport;
        if (enableMethylationRateSupport) {
            this.coloring = ColorMode.METHYLATION_RATE;
        }
        this.allSamples = samples;
        this.setupGroupsFromAttributes();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        this.setRenderID(false);
        int cnt = Math.max(1, this.allSamples.size());
        int beta = 10000000;
        double p = Math.pow(cnt, 1.5);
        int visWindow = (int)Math.min(500000.0, (double)beta / p * 1000.0);
        this.setVisibilityWindow(visWindow);
        IGV.getInstance().addGroupEventListener(this);
        String bamListPath = locator.getPath() + ".mapping";
        if (ParsingUtils.pathExists(bamListPath)) {
            this.loadAlignmentMappings(bamListPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAlignmentMappings(String bamListPath) {
        this.alignmentFiles = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(bamListPath);
            while ((nextLine = br.readLine()) != null) {
                boolean isAbsolute;
                String[] tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
                if (tokens.length < 2) {
                    log.info("Skipping bam mapping file line: " + nextLine);
                    continue;
                }
                String alignmentPath = tokens[1];
                if (alignmentPath.startsWith("http://") || alignmentPath.startsWith("ftp:")) {
                    isAbsolute = true;
                } else {
                    String absolutePath = new File(alignmentPath).getAbsolutePath();
                    String prefix = absolutePath.substring(0, 3);
                    isAbsolute = alignmentPath.startsWith(prefix);
                }
                if (!isAbsolute) {
                    alignmentPath = FileUtils.getAbsolutePath(alignmentPath, bamListPath);
                }
                this.alignmentFiles.put(tokens[0], alignmentPath);
            }
        }
        catch (IOException e) {
            MessageUtils.showMessage("<html>Error loading bam mapping file: " + bamListPath + "<br>" + e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getBamFileForSample(String sample) {
        return this.alignmentFiles == null ? null : this.alignmentFiles.get(sample);
    }

    private void setupGroupsFromAttributes() {
        AttributeManager manager = AttributeManager.getInstance();
        String newGroupByAttribute = IGV.getInstance().getGroupByAttribute();
        if (newGroupByAttribute == this.groupByAttribute || newGroupByAttribute != null && newGroupByAttribute.equals(this.groupByAttribute)) {
            return;
        }
        this.samplesByGroups.clear();
        this.groupByAttribute = newGroupByAttribute;
        if (this.groupByAttribute == null) {
            this.grouped = false;
            return;
        }
        for (String sample : this.allSamples) {
            String sampleGroup = manager.getAttribute(sample, newGroupByAttribute);
            List<String> sampleList = this.samplesByGroups.get(sampleGroup);
            if (sampleList == null) {
                sampleList = new ArrayList<String>();
                this.samplesByGroups.put(sampleGroup, sampleList);
            }
            sampleList.add(sample);
        }
        this.grouped = this.samplesByGroups.size() > 1;
        this.groupByAttribute = newGroupByAttribute;
    }

    public void sortSamples(Comparator<String> comparator) {
        Collections.sort(this.allSamples, comparator);
        for (List<String> samples : this.samplesByGroups.values()) {
            Collections.sort(samples, comparator);
        }
    }

    public boolean isEnableMethylationRateSupport() {
        return this.enableMethylationRateSupport;
    }

    public int getGenotypeBandHeight() {
        switch (this.getDisplayMode()) {
            case SQUISHED: {
                return this.getSquishedHeight();
            }
            case COLLAPSED: {
                return 0;
            }
        }
        return 15;
    }

    @Override
    public int getHeight() {
        int sampleCount = this.allSamples.size();
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED || sampleCount == 0) {
            return this.variantBandHeight;
        }
        int groupCount = this.samplesByGroups.size();
        int margins = groupCount * 3;
        return this.variantBandHeight + margins + sampleCount * this.getGenotypeBandHeight();
    }

    @Override
    public void setHeight(int height) {
        int sampleCount;
        Track.DisplayMode displayMode = this.getDisplayMode();
        if (displayMode == Track.DisplayMode.COLLAPSED) {
            return;
        }
        int groupCount = this.samplesByGroups.size();
        int margins = (groupCount - 1) * 3;
        int expandedHeight = this.variantBandHeight + margins + (sampleCount = this.allSamples.size()) * this.getGenotypeBandHeight();
        if (height < expandedHeight) {
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
            this.squishedHeight = Math.max(1, (height - this.variantBandHeight - margins) / sampleCount);
        } else if (displayMode != Track.DisplayMode.EXPANDED) {
            this.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    @Override
    protected void renderFeatureImpl(RenderContext context, Rectangle trackRectangle, PackedFeatures packedFeatures) {
        int bottomY;
        int variantBandY;
        List features;
        Graphics2D g2D = context.getGraphics();
        this.top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        Rectangle visibleRectangle = context.getVisibleRect();
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = this.getGenotypeBandHeight();
        rect.y = trackRectangle.y + this.variantBandHeight;
        this.drawBackground(g2D, rect, visibleRectangle, BackgroundType.DATA);
        if (this.top > visibleRectangle.y && (double)this.top < visibleRectangle.getMaxY()) {
            g2D.drawLine(left, this.top + 1, right, this.top + 1);
        }
        if ((features = packedFeatures.getFeatures()).size() > 0) {
            double locScale = context.getScale();
            double origin = context.getOrigin();
            int lastPX = -1;
            double pXMin = rect.getMinX();
            double pXMax = rect.getMaxX();
            for (Feature feature : features) {
                boolean isSelected;
                int end;
                int dX;
                int start;
                int pX;
                Variant variant = (Variant)feature;
                if (this.hideFiltered && variant.isFiltered() || (double)((pX = (int)(((double)(start = variant.getStart()) - origin) / locScale)) + (dX = (int)Math.max(2.0, (double)((end = variant.getEnd()) - start) / locScale))) < pXMin) continue;
                if ((double)pX > pXMax) break;
                int w = dX;
                int x = pX;
                if (w < 3) {
                    w = 3;
                    --x;
                }
                if (pX + dX <= lastPX) continue;
                rect.y = this.top;
                rect.height = this.variantBandHeight;
                if (rect.intersects(visibleRectangle)) {
                    this.renderer.renderSiteBand(variant, rect, x, w, context);
                }
                if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
                    rect.y += rect.height;
                    rect.height = this.getGenotypeBandHeight();
                    if (this.grouped) {
                        for (Map.Entry<String, List<String>> entry : this.samplesByGroups.entrySet()) {
                            for (String sample : entry.getValue()) {
                                if (rect.intersects(visibleRectangle)) {
                                    this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, sample, this.coloring, this.hideFiltered);
                                }
                                rect.y += rect.height;
                            }
                            g2D.setColor(OFF_WHITE);
                            g2D.fillRect(rect.x, rect.y, rect.width, 3);
                            rect.y += 3;
                        }
                    } else {
                        for (String sample : this.allSamples) {
                            if (rect.intersects(visibleRectangle)) {
                                this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, sample, this.coloring, this.hideFiltered);
                            }
                            rect.y += rect.height;
                        }
                    }
                }
                boolean bl = isSelected = this.selectedVariant != null && this.selectedVariant == variant;
                if (isSelected) {
                    Graphics2D selectionGraphics = context.getGraphic2DForColor(Color.black);
                    selectionGraphics.drawRect(x, this.top, w, this.getHeight());
                }
                lastPX = pX + dX;
            }
        } else {
            rect.height = this.variantBandHeight;
            rect.y = trackRectangle.y;
            g2D.setColor(Color.gray);
            GraphicUtils.drawCenteredText("No Variants Found", trackRectangle, g2D);
        }
        if (this.allSamples.size() > 0 && (variantBandY = trackRectangle.y + this.variantBandHeight) >= visibleRectangle.y && (double)variantBandY <= visibleRectangle.getMaxY()) {
            Graphics2D borderGraphics = context.getGraphic2DForColor(Color.black);
            borderGraphics.drawLine(left, variantBandY, right, variantBandY);
        }
        if ((bottomY = trackRectangle.y + trackRectangle.height) >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            g2D.drawLine(left, bottomY, right, bottomY);
        }
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        int variantBandY;
        int bottomY;
        this.top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.setFont(FontManager.getFont(this.fontSize));
        g2D.setColor(BAND2_COLOR);
        if (this.top > visibleRectangle.y && (double)this.top < visibleRectangle.getMaxY()) {
            g2D.setColor(Color.black);
            g2D.drawLine(left, this.top + 1, right, this.top + 1);
        }
        g2D.setColor(Color.black);
        rect.height = this.variantBandHeight;
        if (rect.intersects(visibleRectangle)) {
            GraphicUtils.drawWrappedText(this.getName(), rect, g2D, false);
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
            this.sampleBounds.clear();
            this.drawBackground(g2D, rect, visibleRectangle, BackgroundType.NAME);
        }
        if ((bottomY = trackRectangle.y + trackRectangle.height) >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            g2D.setColor(borderGray);
            g2D.drawLine(left, bottomY, right, bottomY);
        }
        if (this.allSamples.size() > 0 && (variantBandY = trackRectangle.y + this.variantBandHeight) >= visibleRectangle.y && (double)variantBandY <= visibleRectangle.getMaxY()) {
            g2D.setColor(Color.black);
            g2D.drawLine(left, variantBandY, right, variantBandY);
        }
    }

    @Override
    public void renderAttributes(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle, List<String> attributeNames, List<MouseableRegion> mouseRegions) {
        int variantBandY;
        this.top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.setColor(Color.black);
        if (this.top > visibleRectangle.y && (double)this.top < visibleRectangle.getMaxY()) {
            g2D.drawLine(left, this.top + 1, right, this.top + 1);
        }
        rect.height = this.variantBandHeight;
        if (rect.intersects(visibleRectangle)) {
            super.renderAttributes(g2D, rect, visibleRectangle, attributeNames, mouseRegions);
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return;
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        Rectangle bandRectangle = new Rectangle(rect);
        this.drawBackground(g2D, rect, visibleRectangle, BackgroundType.ATTRIBUTE);
        if (this.grouped) {
            for (List<String> sampleList : this.samplesByGroups.values()) {
                this.renderAttibuteBand(g2D, bandRectangle, visibleRectangle, attributeNames, sampleList, mouseRegions);
                bandRectangle.y += 3;
            }
        } else {
            this.renderAttibuteBand(g2D, bandRectangle, visibleRectangle, attributeNames, this.allSamples, mouseRegions);
        }
        int bottomY = trackRectangle.y + trackRectangle.height;
        if (bottomY >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            g2D.setColor(borderGray);
            g2D.drawLine(left, bottomY, right, bottomY);
        }
        if (this.allSamples.size() > 0 && (variantBandY = trackRectangle.y + this.variantBandHeight) >= visibleRectangle.y && (double)variantBandY <= visibleRectangle.getMaxY()) {
            g2D.setColor(Color.black);
            g2D.drawLine(left, variantBandY, right, variantBandY);
        }
    }

    private void renderAttibuteBand(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, List<String> attributeNames, List<String> sampleList, List<MouseableRegion> mouseRegions) {
        for (String sample : sampleList) {
            if (bandRectangle.intersects(visibleRectangle)) {
                int x = bandRectangle.x;
                for (String name : attributeNames) {
                    String key = name.toUpperCase();
                    String attributeValue = AttributeManager.getInstance().getAttribute(sample, key);
                    if (attributeValue != null) {
                        Rectangle rect = new Rectangle(x, bandRectangle.y, 10, bandRectangle.height);
                        g2D.setColor(AttributeManager.getInstance().getColor(key, attributeValue));
                        g2D.fill(rect);
                        mouseRegions.add(new MouseableRegion(rect, key, attributeValue));
                    }
                    x += 11;
                }
            }
            bandRectangle.y += bandRectangle.height;
        }
    }

    private void drawBackground(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, BackgroundType type) {
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return;
        }
        boolean coloredLast = true;
        Rectangle textRectangle = new Rectangle(bandRectangle);
        --textRectangle.height;
        int bandFontSize = Math.min(this.fontSize, (int)bandRectangle.getHeight() - 1);
        Font font = FontManager.getFont(bandFontSize);
        Font oldFont = g2D.getFont();
        g2D.setFont(font);
        if (this.grouped) {
            for (Map.Entry<String, List<String>> sampleGroup : this.samplesByGroups.entrySet()) {
                String group;
                int y0 = bandRectangle.y;
                List<String> sampleList = sampleGroup.getValue();
                coloredLast = this.colorBand(g2D, bandRectangle, visibleRectangle, coloredLast, textRectangle, sampleList, type);
                g2D.setColor(OFF_WHITE);
                g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, 3);
                bandRectangle.y += 3;
                if (type != BackgroundType.NAME || bandRectangle.height >= 3 || (group = sampleGroup.getKey()) == null) continue;
                g2D.setColor(Color.black);
                g2D.setFont(oldFont);
                int y2 = bandRectangle.y;
                Rectangle textRect = new Rectangle(bandRectangle.x, y0, bandRectangle.width, y2 - y0);
                GraphicUtils.drawWrappedText(group, textRect, g2D, true);
            }
        } else {
            coloredLast = this.colorBand(g2D, bandRectangle, visibleRectangle, coloredLast, textRectangle, this.allSamples, type);
        }
        g2D.setFont(oldFont);
    }

    private boolean colorBand(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, boolean coloredLast, Rectangle textRectangle, List<String> sampleList, BackgroundType type) {
        boolean supressFill = this.getDisplayMode() == Track.DisplayMode.SQUISHED && this.squishedHeight < 4;
        for (String sample : sampleList) {
            if (coloredLast) {
                g2D.setColor(BAND1_COLOR);
                coloredLast = false;
            } else {
                g2D.setColor(BAND2_COLOR);
                coloredLast = true;
            }
            if (bandRectangle.intersects(visibleRectangle)) {
                if (!supressFill) {
                    g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                }
                if (type == BackgroundType.NAME) {
                    this.sampleBounds.add(new SampleBounds(bandRectangle.y, bandRectangle.y + bandRectangle.height, sample));
                    if (bandRectangle.height >= 3) {
                        String printName = sample;
                        textRectangle.y = bandRectangle.y + 1;
                        g2D.setColor(Color.black);
                        GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                    }
                    if (this.selectedSamples.contains(sample)) {
                        g2D.setColor(Color.green);
                        int d = bandRectangle.height;
                        g2D.fillRect(bandRectangle.x + bandRectangle.width - 17, bandRectangle.y, 15, d);
                    }
                } else if (type == BackgroundType.ATTRIBUTE) {
                    // empty if block
                }
            }
            bandRectangle.y += bandRectangle.height;
        }
        return coloredLast;
    }

    public void setRenderID(boolean value) {
        this.renderID = value;
    }

    public boolean getHideFiltered() {
        return this.hideFiltered;
    }

    public void setHideFiltered(boolean value) {
        this.hideFiltered = value;
    }

    public ColorMode getColorMode() {
        return this.coloring;
    }

    public void setColorMode(ColorMode mode) {
        this.coloring = mode;
    }

    @Override
    public String getNameValueString(int y) {
        if (y < this.top + this.variantBandHeight) {
            return this.getName();
        }
        String sample = this.getSampleAtPosition(y);
        return sample;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        try {
            double maxDistance = 10.0 * frame.getScale();
            Variant variant = this.getFeatureClosest(position, maxDistance, frame);
            if (variant == null) {
                return null;
            }
            if (y < this.top + this.variantBandHeight) {
                return this.getVariantToolTip(variant);
            }
            if (this.sampleBounds == null && this.sampleBounds.isEmpty()) {
                return null;
            }
            String sample = this.getSampleAtPosition(y);
            if (sample != null) {
                return this.getSampleToolTip(sample, variant);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getSampleAtPosition(int y) {
        if (this.sampleBounds.isEmpty()) {
            return null;
        }
        String sample = null;
        int sampleCount = this.sampleBounds.size();
        int firstSampleY = this.sampleBounds.get((int)0).top;
        int idx = Math.max(0, Math.min((y - firstSampleY) / this.getGenotypeBandHeight(), sampleCount - 1));
        SampleBounds bounds = this.sampleBounds.get(idx);
        if (bounds.contains(y)) {
            sample = bounds.sample;
        } else if (bounds.top > y) {
            while (idx > 0) {
                if (!(bounds = this.sampleBounds.get(--idx)).contains(y)) continue;
                sample = bounds.sample;
            }
        } else {
            while (idx < sampleCount - 1) {
                if (!(bounds = this.sampleBounds.get(++idx)).contains(y)) continue;
                sample = bounds.sample;
            }
        }
        return sample;
    }

    protected Variant getFeatureClosest(double position, double maxDistance, ReferenceFrame frame) {
        PackedFeatures packedFeatures = (PackedFeatures)this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return null;
        }
        Feature feature = null;
        List features = packedFeatures.getFeatures();
        if (features != null) {
            feature = FeatureUtils.getFeatureClosest(position, features);
        }
        if (feature == null || position < (double)feature.getStart() - maxDistance || position > (double)feature.getEnd() + maxDistance) {
            return null;
        }
        return (Variant)feature;
    }

    private String getVariantToolTip(Variant variant) {
        String id = variant.getID();
        StringBuffer toolTip = new StringBuffer();
        toolTip.append("Chr:" + variant.getChr());
        toolTip.append("<br>Position:" + variant.getStart());
        toolTip.append("<br>ID: " + id);
        toolTip.append("<br>Reference: " + variant.getReference());
        Set<Allele> alternates = variant.getAlternateAlleles();
        if (alternates.size() > 0) {
            toolTip.append("<br>Alternate: " + alternates.toString());
        }
        toolTip.append("<br>Qual: " + numFormat.format(variant.getPhredScaledQual()));
        toolTip.append("<br>Type: " + variant.getType());
        if (variant.isFiltered()) {
            toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        toolTip.append("<br><b>Alleles:</b>");
        toolTip.append(this.getAlleleToolTip(variant));
        double af = variant.getAlleleFreq();
        if (af < 0.0 && variant.getSampleNames().size() > 0) {
            af = variant.getAlleleFraction();
        }
        toolTip.append("<br>Allele Frequency: " + (af >= 0.0 ? numFormat.format(af) : "Unknown") + "<br>");
        if (variant.getSampleNames().size() > 0) {
            double afrac = variant.getAlleleFraction();
            toolTip = toolTip.append("<br>Minor Allele Fraction: " + numFormat.format(afrac) + "<br>");
        }
        toolTip.append("<br><b>Genotypes:</b>");
        toolTip.append(this.getGenotypeToolTip(variant) + "<br>");
        toolTip.append(this.getVariantInfo(variant) + "<br>");
        return toolTip.toString();
    }

    protected String getVariantInfo(Variant variant) {
        Set<String> keys = variant.getAttributes().keySet();
        if (keys.size() > 0) {
            String toolTip = "<br><b>Variant Attributes</b>";
            int count = 0;
            String k = "AF";
            String afValue = variant.getAttributeAsString(k);
            if (afValue != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(k) + ": " + variant.getAttributeAsString(k));
            }
            if ((afValue = variant.getAttributeAsString(k = "GMAF")) != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(k) + ": " + variant.getAttributeAsString(k));
            }
            for (String key : keys) {
                ++count;
                if (key.equals("AF") || key.equals("GMAF")) continue;
                if (count > 15) {
                    toolTip = toolTip.concat("<br>....");
                    break;
                }
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(key) + ": " + variant.getAttributeAsString(key));
            }
            return toolTip;
        }
        return " ";
    }

    private String getSampleInfo(Genotype genotype) {
        Set<String> keys = genotype.getAttributes().keySet();
        if (keys.size() > 0) {
            String tooltip = "<br><b>Sample Attributes</b>";
            for (String key : keys) {
                try {
                    tooltip = tooltip.concat("<br>" + VariantTrack.getFullName(key) + ": " + genotype.getAttributeAsString(key));
                }
                catch (IllegalArgumentException iae) {
                    tooltip = tooltip.concat("<br>" + key + ": " + genotype.getAttributeAsString(key));
                }
            }
            return tooltip;
        }
        return null;
    }

    public void clearSelectedVariant() {
        this.selectedVariant = null;
    }

    public List<String> getAllSamples() {
        return this.allSamples;
    }

    public int getSquishedHeight() {
        return this.squishedHeight;
    }

    public void setSquishedHeight(int squishedHeight) {
        this.squishedHeight = squishedHeight;
    }

    @Override
    public void onTrackGroupEvent(TrackGroupEvent e) {
        this.setupGroupsFromAttributes();
    }

    public boolean hasAlignmentFiles() {
        return this.alignmentFiles != null && !this.alignmentFiles.isEmpty();
    }

    public Collection<String> getSelectedSamples() {
        return this.selectedSamples;
    }

    static String getFullName(String key) {
        return fullNames.containsKey(key) ? fullNames.get(key) : key;
    }

    private String getSampleToolTip(String sample, Variant variant) {
        double goodBaseCount = variant.getGenotype(sample).getAttributeAsDouble("GB");
        if (Double.isNaN(goodBaseCount)) {
            goodBaseCount = 0.0;
        }
        if (this.isEnableMethylationRateSupport() && goodBaseCount < 10.0) {
            return sample;
        }
        String id = variant.getID();
        StringBuffer toolTip = new StringBuffer();
        toolTip = toolTip.append("Chr:" + variant.getChr());
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        toolTip = toolTip.append("<br>ID: " + id + "<br>");
        toolTip = toolTip.append("<br><b>Sample Information</b>");
        toolTip = toolTip.append("<br>Sample: " + sample);
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        Genotype genotype = variant.getGenotype(sample);
        if (genotype != null) {
            toolTip = toolTip.append("<br>Bases: " + genotype.getGenotypeString());
            toolTip = toolTip.append("<br>Quality: " + numFormat.format(genotype.getPhredScaledQual()));
            toolTip = toolTip.append("<br>Type: " + genotype.getType());
        }
        if (variant.isFiltered()) {
            toolTip = toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip = toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        if (genotype != null) {
            toolTip = toolTip.append(this.getSampleInfo(genotype) + "<br>");
        }
        return toolTip.toString();
    }

    private String getFilterTooltip(Variant variant) {
        Collection<String> filters = variant.getFilters();
        String toolTip = "<br>";
        for (String filter : filters) {
            toolTip = toolTip.concat("- " + filter + "<br>");
        }
        return toolTip;
    }

    private String getAlleleToolTip(Variant counts) {
        double noCall = counts.getNoCallCount() * 2;
        double aNum = (counts.getHetCount() + counts.getHomRefCount() + counts.getHomVarCount()) * 2;
        double aCount = (counts.getHomVarCount() * 2 + counts.getHetCount()) * 2;
        String toolTip = "<br>No Call: " + (int)noCall;
        toolTip = toolTip.concat("<br>Allele Num: " + (int)aNum);
        toolTip = toolTip.concat("<br>Allele Count: " + (int)aCount);
        return toolTip;
    }

    private String getGenotypeToolTip(Variant counts) {
        int noCall = counts.getNoCallCount();
        int homRef = counts.getHomRefCount();
        int nonVar = noCall + homRef;
        int het = counts.getHetCount();
        int homVar = counts.getHomVarCount();
        int var = het + homVar;
        String toolTip = "<br>Non Variant: " + nonVar;
        toolTip = toolTip.concat("<br> - No Call: " + noCall);
        toolTip = toolTip.concat("<br> - Hom Ref: " + homRef);
        toolTip = toolTip.concat("<br>Variant: " + var);
        toolTip = toolTip.concat("<br> - Het: " + het);
        toolTip = toolTip.concat("<br> - Hom Var: " + homVar);
        return toolTip;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        double maxDistance;
        double position;
        Variant f;
        ReferenceFrame referenceFrame = te.getFrame();
        this.selectedVariant = null;
        if (referenceFrame != null && referenceFrame.getName() != null && (f = this.getFeatureClosest(position = te.getChromosomePosition(), maxDistance = 10.0 * referenceFrame.getScale(), referenceFrame)) != null) {
            this.selectedVariant = f;
            IGV.getInstance().doRefresh();
        }
        return new VariantMenu(this, this.selectedVariant);
    }

    @Override
    public void handleNameClick(MouseEvent e) {
        String sampleAtPosition = this.getSampleAtPosition(e.getY());
        if (e.isPopupTrigger()) {
            return;
        }
        if (e.isMetaDown() || e.isControlDown()) {
            if (sampleAtPosition != null && !this.selectedSamples.contains(sampleAtPosition)) {
                this.selectedSamples.add(sampleAtPosition);
            }
        } else if (e.isShiftDown() && !this.selectedSamples.isEmpty()) {
            int idx = this.getSampleIndex(sampleAtPosition);
            int lastIDX = this.getSampleIndex(this.selectedSamples.get(this.selectedSamples.size() - 1));
            if (idx >= 0 && lastIDX >= 0) {
                this.selectedSamples.clear();
                for (int i = Math.min(idx, lastIDX); i <= Math.max(idx, lastIDX); ++i) {
                    String s = this.sampleBounds.get((int)i).sample;
                    this.selectedSamples.add(s);
                }
            }
        } else if (sampleAtPosition != null) {
            if (this.selectedSamples.size() == 1 && this.selectedSamples.contains(sampleAtPosition)) {
                this.selectedSamples.clear();
                IGV.getInstance().repaint();
                return;
            }
            this.selectedSamples.clear();
            this.selectedSamples.add(sampleAtPosition);
        }
        IGV.getInstance().repaint();
    }

    private int getSampleIndex(String sample) {
        for (int i = 0; i < this.sampleBounds.size(); ++i) {
            if (!sample.equals(this.sampleBounds.get((int)i).sample)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        String selectedSample;
        if (!this.hasAlignmentFiles()) {
            return false;
        }
        ReferenceFrame referenceFrame = te.getFrame();
        double position = te.getChromosomePosition();
        double maxDistance = 10.0 * referenceFrame.getScale();
        Variant f = this.getFeatureClosest(position, maxDistance, te.getFrame());
        this.selectedSamples.clear();
        if (f != null && (selectedSample = this.getSampleAtPosition(te.getMouseEvent().getY())) != null) {
            int idx;
            String s;
            Genotype gt;
            int i;
            Genotype genotype = f.getGenotype(selectedSample);
            String type = genotype.getType();
            for (i = idx = this.getSampleIndex(selectedSample); i < this.sampleBounds.size() && (gt = f.getGenotype(s = this.sampleBounds.get((int)i).sample)) != null && type.equals(gt.getType()); ++i) {
                this.selectedSamples.add(s);
            }
            for (i = idx - 1; i >= 0 && (gt = f.getGenotype(s = this.sampleBounds.get((int)i).sample)) != null && type.equals(gt.getType()); --i) {
                this.selectedSamples.add(s);
            }
        }
        IGV.getInstance().doRefresh();
        return true;
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attributes = super.getPersistentState();
        attributes.put(IGVSessionReader.SessionAttribute.RENDER_NAME.getText(), String.valueOf(this.renderID));
        ColorMode mode = this.getColorMode();
        if (mode != null) {
            attributes.put(IGVSessionReader.SessionAttribute.COLOR_MODE.getText(), mode.toString());
        }
        if (this.squishedHeight != 4) {
            attributes.put("SQUISHED_ROW_HEIGHT", String.valueOf(this.squishedHeight));
        }
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        String squishedHeightText;
        String colorModeText;
        super.restorePersistentState(attributes);
        String rendername = attributes.get(IGVSessionReader.SessionAttribute.RENDER_NAME.getText());
        if (rendername != null) {
            this.setRenderID(rendername.equalsIgnoreCase("true"));
        }
        if ((colorModeText = attributes.get(IGVSessionReader.SessionAttribute.COLOR_MODE.getText())) != null) {
            try {
                this.setColorMode(ColorMode.valueOf(colorModeText));
            }
            catch (Exception e) {
                log.error("Error interpreting display mode: " + colorModeText);
            }
        }
        if ((squishedHeightText = attributes.get("SQUISHED_ROW_HEIGHT")) != null) {
            try {
                this.squishedHeight = Integer.parseInt(squishedHeightText);
            }
            catch (Exception e) {
                log.error("Error restoring squished height: " + squishedHeightText);
            }
        }
    }

    public void loadSelectedBams() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean proceed;
                int nSamples = VariantTrack.this.selectedSamples.size();
                if (nSamples == 0) {
                    return;
                }
                HashSet<String> bams = new HashSet<String>(nSamples);
                String name = "";
                int n = 0;
                for (String sample : VariantTrack.this.selectedSamples) {
                    bams.add(VariantTrack.this.getBamFileForSample(sample));
                    if (++n >= 7) continue;
                    if (n == 6) {
                        name = name + "...";
                        continue;
                    }
                    name = name + sample;
                    if (n >= nSamples) continue;
                    name = name + ", ";
                }
                if (bams.size() > 20 && !(proceed = MessageUtils.confirm("Are you sure you want to load " + nSamples + " bams?"))) {
                    return;
                }
                String bamList = "";
                for (String bam : bams) {
                    bamList = bamList + bam + ",";
                }
                ResourceLocator loc = new ResourceLocator(bamList);
                loc.setType("alist");
                loc.setName(name);
                List<Track> tracks = IGV.getInstance().load(loc);
                TrackPanel panel = IGV.getInstance().getVcfBamPanel();
                panel.clearTracks();
                panel.addTracks(tracks);
            }
        };
        LongRunningTask.submit(runnable);
    }

    static {
        fullNames.put("AA", "Ancestral Allele");
        fullNames.put("AC", "Allele Count in Genotypes");
        fullNames.put("AN", "Total Alleles in Genotypes");
        fullNames.put("AF", "Allele Frequency");
        fullNames.put("DP", "Depth");
        fullNames.put("MQ", "Mapping Quality");
        fullNames.put("NS", "Number of Samples with Data");
        fullNames.put("BQ", "RMS Base Quality");
        fullNames.put("SB", "Strand Bias");
        fullNames.put("DB", "dbSNP Membership");
        fullNames.put("GQ", "Genotype Quality");
        fullNames.put("GL", "Genotype Likelihoods");
    }

    static class SampleBounds {
        int top;
        int bottom;
        String sample;

        SampleBounds(int top, int bottom, String sample) {
            this.top = top;
            this.bottom = bottom;
            this.sample = sample;
        }

        boolean contains(int y) {
            return y >= this.top && y <= this.bottom;
        }
    }

    public static enum BackgroundType {
        NAME,
        ATTRIBUTE,
        DATA;

    }

    public static enum ColorMode {
        GENOTYPE,
        METHYLATION_RATE,
        ALLELE;

    }
}

