/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.util;

import com.google.protobuf.ByteString;
import edu.cornell.med.icb.goby.alignments.AlignmentCodec;
import edu.cornell.med.icb.goby.reads.ReadCodec;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.ServiceLoader;

public class CodecHelper {
    private static final ServiceLoader<ReadCodec> readCodecLoader = ServiceLoader.load(ReadCodec.class);
    private static final ServiceLoader<AlignmentCodec> alignmentCodecLoader = ServiceLoader.load(AlignmentCodec.class);
    private static Byte2ObjectMap<ReadCodec> codeToReadCodec = new Byte2ObjectOpenHashMap<ReadCodec>(5);
    private static Byte2ObjectMap<AlignmentCodec> codeToAlignmentCodec = new Byte2ObjectOpenHashMap<AlignmentCodec>(5);

    public static void reload() {
        readCodecLoader.reload();
        alignmentCodecLoader.reload();
        for (ReadCodec readCodec : readCodecLoader) {
            codeToReadCodec.put(readCodec.registrationCode(), readCodec);
        }
        for (AlignmentCodec alignmentCodec : alignmentCodecLoader) {
            codeToAlignmentCodec.put(alignmentCodec.registrationCode(), alignmentCodec);
        }
    }

    public static ReadCodec locateReadCodec(ByteString compressedData) {
        if (codeToReadCodec.size() == 0) {
            CodecHelper.reload();
        }
        byte codecId = compressedData.byteAt(0);
        return (ReadCodec)codeToReadCodec.get(codecId);
    }

    public static AlignmentCodec locateAlignmentCodec(ByteString compressedData) {
        byte codecId = compressedData.byteAt(0);
        return (AlignmentCodec)codeToAlignmentCodec.get(codecId);
    }

    static {
        CodecHelper.reload();
    }
}

