/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.modes;

import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Switch;
import edu.cornell.med.icb.goby.modes.GenericToolsDriver;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public abstract class AbstractCommandLineMode {
    private String jarFilename;

    protected AbstractCommandLineMode(String jarFilename) {
        this.setJarFilename(jarFilename);
    }

    public String getJarFilename() {
        return this.jarFilename;
    }

    public void setJarFilename(String jarFilename) {
        this.jarFilename = jarFilename;
    }

    public abstract String getModeName();

    public String getShortModeName() {
        String[] shortModeNameParts = this.getModeName().split("-");
        StringBuilder shortModeNameBuilder = new StringBuilder(shortModeNameParts.length);
        for (String shortModeNamePart : shortModeNameParts) {
            shortModeNameBuilder.append(shortModeNamePart.charAt(0));
        }
        return shortModeNameBuilder.toString();
    }

    public abstract String getModeDescription();

    private boolean isJSAPHelpId(String id) {
        return "help".equals(id) || "wikihelp".equals(id) || "htmlhelp".equals(id);
    }

    public void printUsage(JSAP jsap) {
        String modeName = this.getModeName();
        String modeDescription = this.getModeDescription();
        Parameter modeId = jsap.getByID("mode");
        if (modeId != null) {
            jsap.unregisterParameter(modeId);
        }
        System.err.println("Usage: ");
        System.err.println("java -jar " + this.jarFilename + " (-m|--mode) " + modeName + " " + jsap.getUsage());
        System.err.println();
        System.err.println("Description: ");
        System.err.println(WordUtils.wrap(modeDescription, 79));
        System.err.println();
        System.err.println("Options: ");
        System.err.println(jsap.getHelp(79));
    }

    public void printUsageAsWikiTable(JSAP jsap) {
        PrintStream stream = System.out;
        stream.println("{| class=\"wikitable\" style=\"margin: 1em auto 1em auto; background:#efefef;\" valign=\"top\" align=\"center\" border=\"1\" cellpadding=\"5\" width=\"80%\"");
        stream.println("|- valign=\"bottom\" align=\"left\" style=\"background:#ffdead;\"");
        stream.println("!width=\"15%\"| Flag");
        stream.println("!width=\"10%\" | Arguments");
        stream.println("!width=\"5%\"| Required");
        stream.println("! Description");
        stream.println();
        IDMap idMap = jsap.getIDMap();
        Iterator iterator = idMap.idIterator();
        while (iterator.hasNext()) {
            boolean required;
            String id = (String)iterator.next();
            if ("mode".equals(id) || this.isJSAPHelpId(id)) continue;
            Parameter parameter = jsap.getByID(id);
            stream.println("|- valign=\"top\" align=\"left\"");
            stream.print("| <nowiki>");
            if (parameter instanceof Flagged) {
                Flagged flagged = (Flagged)((Object)parameter);
                Character characterFlag = flagged.getShortFlagCharacter();
                String longFlag = flagged.getLongFlag();
                if (characterFlag != null && StringUtils.isNotBlank(longFlag)) {
                    stream.print("(-" + characterFlag + "|--" + longFlag + ")");
                } else if (characterFlag != null) {
                    stream.print("-" + characterFlag);
                } else if (StringUtils.isNotBlank(longFlag)) {
                    stream.print("--" + longFlag);
                }
            } else {
                stream.print("n/a");
            }
            stream.println("</nowiki>");
            stream.print("| ");
            if (parameter instanceof Switch) {
                stream.println("n/a");
            } else {
                stream.println(id);
            }
            if (parameter instanceof Option) {
                Option option = (Option)parameter;
                required = option.required();
            } else {
                required = !(parameter instanceof Switch);
            }
            stream.println("| " + BooleanUtils.toStringYesNo(required));
            stream.println("| " + parameter.getHelp());
            if (parameter.getDefault() != null) {
                stream.print("Default value: ");
                for (String defaultValue : parameter.getDefault()) {
                    stream.print(" ");
                    stream.print(defaultValue);
                }
            }
            stream.println();
        }
        stream.println("|}");
    }

    public void printUsageAsHtmlTable(JSAP jsap) {
        PrintStream writer = System.out;
        writer.println("<table style=\"background: #efefef;\" border=\"1\" cellpadding=\"5\">");
        writer.println("<tbody>");
        writer.println("<tr style=\"background: #ffdead;\" align=\"left\" valign=\"bottom\">");
        writer.println("<th style=\"width: 15%\">Flag</th>");
        writer.println("<th style=\"width: 10%\">Arguments</th>");
        writer.println("<th style=\"width: 5%\">Required</th>");
        writer.println("<th>Description</th>");
        writer.println("</tr>");
        IDMap idMap = jsap.getIDMap();
        Iterator iterator = idMap.idIterator();
        while (iterator.hasNext()) {
            boolean required;
            String id = (String)iterator.next();
            if ("mode".equals(id) || this.isJSAPHelpId(id)) continue;
            Parameter parameter = jsap.getByID(id);
            writer.println("<tr align=\"left\" valign=\"top\">");
            writer.print("<td><code>");
            if (parameter instanceof Flagged) {
                Flagged flagged = (Flagged)((Object)parameter);
                Character characterFlag = flagged.getShortFlagCharacter();
                String longFlag = flagged.getLongFlag();
                if (characterFlag != null && StringUtils.isNotBlank(longFlag)) {
                    writer.print("(-" + characterFlag + "|--" + longFlag + ")");
                } else if (characterFlag != null) {
                    writer.print("-" + characterFlag);
                } else if (StringUtils.isNotBlank(longFlag)) {
                    writer.print("--" + longFlag);
                }
            } else {
                writer.print("n/a");
            }
            writer.println("</code></td>");
            writer.print("<td>");
            if (parameter instanceof Switch) {
                writer.print("n/a");
            } else {
                writer.print(id);
            }
            writer.println("</td>");
            if (parameter instanceof Option) {
                Option option = (Option)parameter;
                required = option.required();
            } else {
                required = !(parameter instanceof Switch);
            }
            writer.println("<td>" + BooleanUtils.toStringYesNo(required) + "</td>");
            writer.print("<td>");
            String htmlHelpString = StringEscapeUtils.escapeHtml(parameter.getHelp());
            writer.print(StringUtils.replace(htmlHelpString, "-", "&#45;"));
            if (parameter.getDefault() != null) {
                writer.print(" Default value: ");
                for (String defaultValue : parameter.getDefault()) {
                    writer.print(" ");
                    writer.print(StringUtils.replace(defaultValue, "-", "&#45;"));
                }
            }
            writer.println("</td>");
            writer.println("</tr>");
        }
        writer.println("</tbody>");
        writer.println("</table>");
    }

    public JSAP loadJsapFromResource() throws IOException, JSAPException {
        return this.loadJsapFromResource(null);
    }

    public JSAP loadJsapFromResource(Map<String, String> helpValues) throws IOException, JSAPException {
        JSAP jsap;
        Class<?> thisClass = this.getClass();
        String className = ClassUtils.getShortCanonicalName(thisClass);
        try {
            jsap = new JSAP(thisClass.getResource(className + ".jsap"));
        }
        catch (NullPointerException e) {
            jsap = new JSAP();
        }
        JSAP jsapSource = new JSAP(GenericToolsDriver.class.getResource(ClassUtils.getShortCanonicalName(GenericToolsDriver.class) + ".jsap"));
        Iterator idsIt = jsapSource.getIDMap().idIterator();
        while (idsIt.hasNext()) {
            String id = (String)idsIt.next();
            if (jsap.getByID(id) != null) {
                jsap.unregisterParameter(jsap.getByID(id));
            }
            jsap.registerParameter(jsapSource.getByID(id));
        }
        if (helpValues == null) {
            return jsap;
        }
        IDMap idMap = jsap.getIDMap();
        Iterator idIterator = idMap.idIterator();
        while (idIterator.hasNext()) {
            String id = (String)idIterator.next();
            Parameter param = jsap.getByID(id);
            String help = param.getHelp();
            String[] defaults = param.getDefault();
            for (Map.Entry<String, String> entry : helpValues.entrySet()) {
                if (help.contains(entry.getKey())) {
                    param.setHelp(StringUtils.replace(help, entry.getKey(), entry.getValue()));
                }
                if (defaults == null) continue;
                for (int i = 0; i < defaults.length; ++i) {
                    if (!defaults[i].contains(entry.getKey())) continue;
                    defaults[i] = StringUtils.replace(defaults[i], entry.getKey(), entry.getValue());
                }
            }
        }
        return jsap;
    }

    public JSAPResult parseJsap(JSAP jsap, String[] args) {
        JSAPResult jsapResult = jsap.parse(args);
        if (this.getModeName() != null) {
            if (jsap.getByID("help") != null && jsapResult.getBoolean("help")) {
                this.printUsage(jsap);
                System.exit(1);
            } else if (jsap.getByID("htmlhelp") != null && jsapResult.getBoolean("htmlhelp")) {
                this.printUsageAsHtmlTable(jsap);
                System.exit(2);
            } else if (jsap.getByID("wikihelp") != null && jsapResult.getBoolean("wikihelp")) {
                this.printUsageAsWikiTable(jsap);
                System.exit(3);
            }
        }
        return jsapResult;
    }

    public abstract AbstractCommandLineMode configure(String[] var1) throws IOException, JSAPException;

    public abstract void execute() throws IOException;

    protected JSAPResult parseJsapArguments(String[] args, Map<String, String> helpValues) throws IOException, JSAPException {
        JSAP jsap = this.loadJsapFromResource(helpValues);
        JSAPResult jsapResult = this.parseJsap(jsap, args);
        this.abortOnError(jsap, jsapResult);
        return jsapResult;
    }

    protected JSAPResult parseJsapArguments(String[] args) throws IOException, JSAPException {
        JSAP jsap = this.loadJsapFromResource();
        JSAPResult jsapResult = this.parseJsap(jsap, args);
        this.abortOnError(jsap, jsapResult);
        return jsapResult;
    }

    private void abortOnError(JSAP jsap, JSAPResult jsapResult) {
        if (!jsapResult.success()) {
            System.err.println();
            Iterator errs = jsapResult.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println();
            this.printUsage(jsap);
            System.exit(1);
        }
    }
}

