/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.methyl.BBMethylDataSource;
import org.broad.igv.methyl.CachingMethylSource;
import org.broad.igv.methyl.MethylDataSource;
import org.broad.igv.methyl.MethylScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class MethylTrack
extends AbstractTrack {
    public static final int ONE_MB = 1000000;
    public static final int TEN_MB = 10000000;
    private MethylDataSource dataSource;
    private Interval loadedInterval;
    private Renderer renderer;
    private int resolutionThreshold;
    private boolean loading = false;

    public MethylTrack(ResourceLocator dataResourceLocator, Genome genome) throws IOException {
        super(dataResourceLocator);
        this.setHeight(60);
        this.renderer = new PointsRenderer();
        boolean isWGBS = dataResourceLocator.getPath().contains("BiSeq_cpgMethylation");
        this.resolutionThreshold = isWGBS ? 1000000 : 10000000;
        this.dataSource = new CachingMethylSource(new BBMethylDataSource(dataResourceLocator.getPath(), genome), this.resolutionThreshold);
        this.loadedInterval = new Interval("", -1, -1, Collections.<MethylScore>emptyList());
        this.setDataRange(new DataRange(0.0f, 100.0f));
    }

    @Override
    public void render(final RenderContext context, Rectangle rect) {
        int end;
        int start;
        if (context.getChr().equals("All") || context.getScale() * (double)rect.width > (double)this.resolutionThreshold) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(rect);
            textRect.height = Math.min(rect.height, 20);
            textRect.height = Math.min(rect.height, 20);
            String message = context.getChr().equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, textRect, g);
            return;
        }
        final String chr = context.getChr();
        if (this.loadedInterval.contains(chr, start = (int)context.getOrigin(), end = (int)context.getEndLocation())) {
            this.renderer.render(this.loadedInterval.scores, context, rect, this);
        } else if (!this.loading) {
            this.loading = true;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int width = (end - start) / 2;
                        int expandedStart = Math.max(0, start - width);
                        int expandedEnd = end + width;
                        ArrayList<MethylScore> scores = new ArrayList<MethylScore>(1000);
                        Iterator<MethylScore> iter = MethylTrack.this.dataSource.query(chr, expandedStart, expandedEnd);
                        while (iter.hasNext()) {
                            scores.add(iter.next());
                        }
                        MethylTrack.this.loadedInterval = new Interval(chr, expandedStart, expandedEnd, scores);
                        context.getPanel().repaint();
                    }
                    finally {
                        MethylTrack.this.loading = false;
                    }
                }
            };
            LongRunningTask.submit(runnable);
        }
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    static class Interval {
        String chr;
        int start;
        int end;
        List<MethylScore> scores;

        Interval(String chr, int start, int end, List<MethylScore> scores) {
            this.chr = chr;
            this.end = end;
            this.scores = scores;
            this.start = start;
        }

        boolean contains(String chr, int start, int end) {
            return this.chr.equals(chr) && this.start <= start && this.end >= end;
        }
    }
}

