/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

public class MethylScore
implements LocusScore {
    String chr;
    int start;
    int end;
    short percentMethylated;
    short totalCount;

    public MethylScore(String chr, int start, int end, short percentMethylated, short totalCount) {
        this.chr = chr;
        this.end = end;
        this.percentMethylated = percentMethylated;
        this.start = start;
        this.totalCount = totalCount;
    }

    @Override
    public float getScore() {
        return this.percentMethylated;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        String totalCountString = this.totalCount < Short.MAX_VALUE ? String.valueOf(this.totalCount) : "> 32767";
        return this.percentMethylated + "%" + " [" + totalCountString + "]";
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }
}

