/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.LineReader;

public class REPMaskCodec
implements FeatureCodec {
    String[] tokens = new String[15];
    int startBase = 0;
    FeatureFileHeader header;
    Genome genome;

    public REPMaskCodec(Genome genome) {
        this.genome = genome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readHeader(LineReader reader) {
        this.header = new FeatureFileHeader();
        this.header.setTrackType(TrackType.REPMASK);
        int nLines = 0;
        try {
            while (true) {
                String nextLine;
                if (!((nextLine = reader.readLine()) != null && (nextLine.startsWith("#") || nextLine.startsWith("track")) || nextLine.startsWith("browser"))) {
                    return this.header;
                }
                ++nLines;
                if (nextLine.startsWith("#type")) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length <= 1) continue;
                    try {
                        this.header.setTrackType(TrackType.valueOf(tokens[1]));
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!nextLine.startsWith("track")) continue;
                TrackProperties tp = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, tp);
                this.header.setTrackProperties(tp);
            }
        }
        catch (IOException e) {
            throw new CodecLineParsingException("Error parsing header", e);
        }
    }

    @Override
    public boolean canDecode(String path) {
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public BasicFeature decode(String nextLine) {
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#")) {
            return null;
        }
        int tokenCount = ParsingUtils.splitWhitespace(nextLine, this.tokens);
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.genome == null ? this.tokens[0] : this.genome.getChromosomeAlias(this.tokens[0]);
        int start = Integer.parseInt(this.tokens[1]) - this.startBase;
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(this.tokens[2]);
        }
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            int strand;
            String strandString = this.tokens[3].trim();
            int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 4) {
            String name = this.tokens[4].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        return feature;
    }

    public Class getFeatureType() {
        return BasicFeature.class;
    }
}

