/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.broad.igv.dev.affective.AffectiveDataSource;
import org.broad.igv.dev.affective.AffectiveGenome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class AffectiveUtils {
    public static int POINTS_PER_SECOND = 8;
    public static int DAY_LENGTH_HOURS = 9;
    public static int START_TIME_HR = 8;
    public static int START_TIME = START_TIME_HR * 60 * 60 * POINTS_PER_SECOND;
    public static final GenomeListItem GENOME_DESCRIPTOR = new GenomeListItem("Affective", "", "affective", false);
    private static AffectiveGenome genome;

    public static void createCytoband(String[] args) throws IOException {
        File root = new File("/Users/jrobinso/IGV/Miriah/Participant3");
        boolean start = false;
        block0: for (File dir : root.listFiles()) {
            File[] files = dir.listFiles();
            if (!dir.isDirectory()) continue;
            for (File f : files) {
                if (!f.getName().endsWith(".csv")) continue;
                int nLines = 0;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while (br.readLine() != null) {
                    ++nLines;
                }
                System.out.println(dir.getName().replace("Day ", "") + "\t" + 0 + "\t" + nLines);
                continue block0;
            }
        }
    }

    public static Genome getGenome() {
        genome = new AffectiveGenome();
        return genome;
    }

    public static void loadTDFFile(ResourceLocator locator, List<Track> newTracks, Genome genome, TDFReader reader) {
        String name;
        TrackType type = reader.getTrackType();
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        if ((name = locator.getName()) != null && props != null) {
            props.setName(name);
        }
        if (name == null) {
            name = props == null ? locator.getTrackName() : props.getName();
        }
        int trackNumber = 0;
        String path = locator.getPath();
        boolean multiTrack = reader.getTrackNames().length > 1;
        for (String heading : reader.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            AffectiveDataSource dataSource = new AffectiveDataSource(reader, trackNumber, heading, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            String displayName = name == null || multiTrack ? heading : name;
            track.setName(displayName);
            track.setTrackType(type);
            if (props != null) {
                track.setProperties(props);
            }
            if (trackName.endsWith("-axis")) {
                track.setDataRange(new DataRange(0.0f, 1.5f));
            } else if (trackName.equals("Battery")) {
                track.setDataRange(new DataRange(-1.0f, 0.0f, 1.0f));
                track.setRendererClass(PointsRenderer.class);
            } else if (trackName.endsWith("Celsius")) {
                track.setDataRange(new DataRange(20.0f, 30.0f));
                track.setRendererClass(PointsRenderer.class);
            } else if (trackName.startsWith("EDA")) {
                track.setDataRange(new DataRange(0.0f, 10.0f));
                track.setColor(new Color(0, 150, 0));
            }
            newTracks.add(track);
            ++trackNumber;
        }
    }
}

