/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.io.File;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;

public class ResourceLocator {
    String name;
    String path;
    String indexPath;
    String infolink;
    String url;
    String description;
    String type;
    String coverage;
    String trackLine;
    Color color;
    String serverURL;
    private String sampleId;

    public ResourceLocator(String path) {
        this(null, path);
    }

    public ResourceLocator(String serverURL, String path) {
        if (serverURL != null) {
            this.serverURL = serverURL.replace("broad.mit.edu", "broadinstitute.org");
        }
        this.path = path != null && path.startsWith("file://") ? path.substring(7) : path;
    }

    public boolean exists() {
        return ParsingUtils.pathExists(this.path);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceLocator other = (ResourceLocator)obj;
        if (!(this.serverURL == other.serverURL || this.serverURL != null && this.serverURL.equals(other.serverURL))) {
            return false;
        }
        return this.path == other.path || this.path != null && this.path.equals(other.path);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.serverURL != null ? this.serverURL.hashCode() : 0);
        hash = 29 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.path + (this.serverURL == null ? "" : " " + this.serverURL);
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return new File(this.path).getName();
    }

    @Deprecated
    public String getServerURL() {
        return this.serverURL;
    }

    public boolean isLocal() {
        return this.serverURL == null && !FileUtils.isRemote(this.path);
    }

    public void setInfolink(String infolink) {
        this.infolink = infolink;
    }

    public String getInfolink() {
        return this.infolink;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTrackName() {
        return this.name != null ? this.name : new File(this.getPath()).getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public static enum AttributeType {
        SERVER_URL("serverURL"),
        PATH("path"),
        DESCRIPTION("description"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        ID("id"),
        SAMPLE_ID("sampleId"),
        NAME("name"),
        URL("url"),
        RESOURCE_TYPE("resourceType"),
        TRACK_LINE("trackLine"),
        COVERAGE("coverage");

        private String name;

        private AttributeType(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }
    }
}

