/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;

public class FeatureTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(FeatureTrack.class);
    public static final int MINIMUM_FEATURE_SPACING = 5;
    public static final int DEFAULT_MARGIN = 5;
    public static final int NO_FEATURE_ROW_SELECTED = -1;
    protected static final Color SELECTED_FEATURE_ROW_COLOR = new Color(100, 100, 100, 30);
    private static final int DEFAULT_EXPANDED_HEIGHT = 35;
    private static final int DEFAULT_SQUISHED_HEIGHT = 12;
    private int expandedRowHeight = 35;
    private int squishedRowHeight = 12;
    boolean fatalLoadError = false;
    Track.DisplayMode lastFeatureMode = null;
    protected List<Rectangle> levelRects = new ArrayList<Rectangle>();
    protected Map<String, PackedFeatures<IGVFeature>> packedFeaturesMap = new HashMap<String, PackedFeatures<IGVFeature>>();
    private FeatureRenderer renderer = new IGVFeatureRenderer();
    private DataRenderer coverageRenderer;
    private boolean showFeatures = true;
    protected FeatureSource source;
    protected boolean featuresLoading = false;
    protected int selectedFeatureRowIndex = -1;
    protected IGVFeature selectedFeature = null;
    int margin = 5;
    private static boolean drawBorder = true;
    private boolean alternateExonColor = false;

    public FeatureTrack(String id, String name) {
        super(id, name);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
        this.setSortable(false);
    }

    public FeatureTrack(String id, String name, FeatureSource source) {
        super(id, name);
        this.init(source);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, String name, FeatureSource source) {
        super(locator, id, name);
        this.init(source);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, FeatureSource source) {
        super(locator);
        this.init(source);
        this.getMinimumHeight();
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, FeatureSource source) {
        super(locator, id);
        this.init(source);
    }

    protected void init(FeatureSource source) {
        this.source = source;
        this.setMinimumHeight(10);
        this.setColor(Color.blue.darker());
        this.coverageRenderer = new BarChartRenderer();
        if (source.getFeatureWindowSize() > 0) {
            this.visibilityWindow = source.getFeatureWindowSize();
        }
    }

    @Override
    public int getHeight() {
        if (!this.isVisible()) {
            return 0;
        }
        int rowHeight = this.getDisplayMode() == Track.DisplayMode.SQUISHED ? this.squishedRowHeight : this.expandedRowHeight;
        int minHeight = rowHeight * Math.max(1, this.getNumberOfFeatureLevels());
        return Math.max(minHeight, super.getHeight());
    }

    @Override
    public void setHeight(int newHeight) {
        super.setHeight(newHeight);
    }

    public int getExpandedRowHeight() {
        return this.expandedRowHeight;
    }

    public void setExpandedRowHeight(int expandedRowHeight) {
        this.expandedRowHeight = expandedRowHeight;
    }

    public int getSquishedRowHeight() {
        return this.squishedRowHeight;
    }

    public void setSquishedRowHeight(int squishedRowHeight) {
        this.squishedRowHeight = squishedRowHeight;
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (FeatureRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error("Error instatiating renderer ", ex);
        }
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    @Override
    public void setProperties(TrackProperties trackProperties) {
        super.setProperties(trackProperties);
        if (trackProperties.getFeatureVisibilityWindow() >= 0) {
            this.setVisibilityWindow(trackProperties.getFeatureVisibilityWindow());
        }
        this.alternateExonColor = trackProperties.isAlternateExonColor();
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    public int getNumberOfFeatureLevels() {
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED && this.packedFeaturesMap.size() > 0) {
            int n = 0;
            for (PackedFeatures<IGVFeature> pf : this.packedFeaturesMap.values()) {
                if (pf == null) continue;
                n = Math.max(n, pf.getRowCount());
            }
            return n;
        }
        return 1;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType scoreType, String frameName) {
        try {
            if (scoreType == RegionScoreType.MUTATION_COUNT && this.getTrackType() == TrackType.MUTATION) {
                Iterator features = this.source.getFeatures(chr, start, end);
                int count = 0;
                if (features != null) {
                    Feature f;
                    while (features.hasNext() && (f = (Feature)features.next()).getStart() <= end) {
                        if (f.getEnd() < start) continue;
                        ++count;
                    }
                }
                return count;
            }
        }
        catch (IOException e) {
            log.error("Error counting features.", e);
        }
        return -3.4028235E38f;
    }

    @Override
    public FeatureRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(IGVFeatureRenderer.class);
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        if (this.showFeatures) {
            List<Feature> allFeatures = this.getAllFeatureAt(position, y, frame);
            if (allFeatures == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            boolean firstFeature = true;
            int maxNumber = 10;
            int n = 1;
            for (Feature feature : allFeatures) {
                if (feature != null && feature instanceof IGVFeature) {
                    String url;
                    if (!firstFeature) {
                        buf.append("<br/>--------------<br/>");
                    }
                    IGVFeature igvFeature = (IGVFeature)feature;
                    String vs = igvFeature.getValueString(position, null);
                    buf.append(vs);
                    if (IGV.getInstance().isSuppressTooltip() && (url = this.getFeatureURL(igvFeature)) != null) {
                        buf.append("<br/><a href=\"" + url + "\">" + url + "</a>");
                    }
                    firstFeature = false;
                    if (n > maxNumber) {
                        buf.append("...");
                        break;
                    }
                }
                ++n;
            }
            return buf.toString();
        }
        int zoom = Math.max(0, frame.getZoom());
        if (this.source == null) {
            return null;
        }
        List<LocusScore> scores = this.source.getCoverageScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return "";
        }
        double bpPerPixel = frame.getScale();
        int minWidth = (int)(2.0 * bpPerPixel);
        LocusScore score = (LocusScore)FeatureUtils.getFeatureAt(position, minWidth, scores);
        return score == null ? null : "Mean count: " + score.getScore();
    }

    private String getFeatureURL(IGVFeature igvFeature) {
        String trackURL;
        String url = igvFeature.getURL();
        if (url == null && (trackURL = this.getUrl()) != null && igvFeature.getIdentifier() != null) {
            String encodedID = URLEncoder.encode(igvFeature.getIdentifier());
            url = trackURL.replaceAll("\\$\\$", encodedID);
        }
        return url;
    }

    List<Feature> getFeatures(String chr, int start, int end) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            Iterator iter = this.source.getFeatures(chr, start, end);
            while (iter.hasNext()) {
                features.add((Feature)iter.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return features;
    }

    private List<Feature> getAllFeatureAt(double position, int y, ReferenceFrame frame) {
        PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return null;
        }
        List<Feature> feature = null;
        int levelNumber = 0;
        if (this.levelRects != null) {
            for (int i = 0; i < this.levelRects.size(); ++i) {
                Rectangle r = this.levelRects.get(i);
                if (y < r.y || !((double)y <= r.getMaxY())) continue;
                levelNumber = i;
                break;
            }
        }
        int nLevels = this.getNumberOfFeatureLevels();
        List<IGVFeature> features = null;
        features = nLevels > 1 && levelNumber < nLevels ? packedFeatures.getRows().get(levelNumber).getFeatures() : packedFeatures.getFeatures();
        if (features != null) {
            double bpPerPixel = frame.getScale();
            double minWidth = 5.0 * bpPerPixel;
            int maxFeatureLength = packedFeatures.getMaxFeatureLength();
            feature = FeatureUtils.getAllFeaturesAt(position, maxFeatureLength, minWidth, features);
        }
        return feature;
    }

    public Feature getFeatureAt(String chr, double position, int y, ReferenceFrame frame) {
        int featureRow = 0;
        if (this.levelRects != null) {
            for (int i = 0; i < this.levelRects.size(); ++i) {
                Rectangle r = this.levelRects.get(i);
                if (y < r.y || !((double)y <= r.getMaxY())) continue;
                featureRow = i;
                break;
            }
        }
        return this.getFeatureAtPositionInFeatureRow(position, featureRow, frame);
    }

    public Feature getFeatureAtPositionInFeatureRow(double position, int featureRow, ReferenceFrame frame) {
        PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return null;
        }
        Feature feature = null;
        int nLevels = this.getNumberOfFeatureLevels();
        List<IGVFeature> features = null;
        features = nLevels > 1 && featureRow < nLevels ? packedFeatures.getRows().get(featureRow).getFeatures() : packedFeatures.getFeatures();
        if (features != null) {
            double bpPerPixel = frame.getScale();
            int minWidth = (int)(2.0 * bpPerPixel);
            feature = FeatureUtils.getFeatureAt(position, minWidth, features);
        }
        return feature;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.count;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED && this.levelRects != null) {
            for (int i = 0; i < this.levelRects.size(); ++i) {
                Rectangle rect = this.levelRects.get(i);
                if (!rect.contains(e.getPoint())) continue;
                if (i == this.selectedFeatureRowIndex) {
                    this.setSelectedFeatureRowIndex(-1);
                } else {
                    this.setSelected(true);
                    this.setSelectedFeatureRowIndex(i);
                }
                IGV.getInstance().doRefresh();
                break;
            }
        }
        this.selectedFeature = null;
        Feature f = this.getFeatureAtMousePosition(te);
        if (f != null && f instanceof IGVFeature) {
            IGVFeature igvFeature = (IGVFeature)f;
            this.selectedFeature = this.selectedFeature == null ? igvFeature : (igvFeature.contains(this.selectedFeature) && this.selectedFeature.contains(igvFeature) ? null : igvFeature);
            if (IGV.getInstance().isSuppressTooltip()) {
                this.openTooltipWindow(te);
            } else {
                String url = this.getFeatureURL(igvFeature);
                if (url != null) {
                    try {
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException e1) {
                        log.error("Error launching url: " + url);
                    }
                    e.consume();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Feature getFeatureAtMousePosition(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame referenceFrame = te.getFrame();
        if (referenceFrame != null) {
            double location = referenceFrame.getChromosomePosition(e.getX());
            Feature f = this.getFeatureAt(referenceFrame.getChrName(), location, e.getY(), referenceFrame);
            return f;
        }
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        this.renderFeatures(context, rect);
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        this.lastFeatureMode = null;
        super.setDisplayMode(mode);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        Rectangle renderRect = new Rectangle(rect);
        renderRect.y += this.margin;
        renderRect.height -= this.margin;
        this.showFeatures = this.isShowFeatures(context);
        if (this.showFeatures) {
            if (this.lastFeatureMode != null) {
                super.setDisplayMode(this.lastFeatureMode);
                this.lastFeatureMode = null;
            }
            this.renderFeatures(context, renderRect);
        } else {
            if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED && !(this instanceof VariantTrack)) {
                this.lastFeatureMode = this.getDisplayMode();
                super.setDisplayMode(Track.DisplayMode.COLLAPSED);
            }
            this.renderCoverage(context, renderRect);
        }
        if (drawBorder) {
            Graphics2D borderGraphics = context.getGraphic2DForColor(UIConstants.TRACK_BORDER_GRAY);
            borderGraphics.draw(rect);
        }
    }

    protected boolean isShowFeatures(RenderContext context) {
        double windowSize = context.getEndLocation() - context.getOrigin();
        int vw = this.getVisibilityWindow();
        return vw <= 0 && !context.getChr().equals("All") || windowSize <= (double)vw && !context.getChr().equals("All");
    }

    protected void renderCoverage(RenderContext context, Rectangle inputRect) {
        if (this.source == null) {
            return;
        }
        List<LocusScore> scores = this.source.getCoverageScores(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom());
        if (scores == null) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(inputRect);
            textRect.height = Math.min(inputRect.height, 20);
            String message = context.getChr().equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, textRect, g);
        } else {
            float max = this.getMaxEstimate(scores);
            ContinuousColorScale cs = this.getColorScale();
            if (cs != null) {
                cs.setPosEnd(max);
            }
            this.setDataRange(new DataRange(0.0f, 0.0f, max));
            this.coverageRenderer.render(scores, context, inputRect, (Track)this);
        }
    }

    private float getMaxEstimate(List<LocusScore> scores) {
        float max = 0.0f;
        int n = Math.min(200, scores.size());
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, scores.get(i).getScore());
        }
        return max;
    }

    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        block7: {
            if (this.featuresLoading || this.fatalLoadError) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("renderFeatures: " + this.getName());
            }
            String chr = context.getChr();
            int start = (int)context.getOrigin();
            int end = (int)context.getEndLocation() + 1;
            PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(context.getReferenceFrame().getName());
            if (packedFeatures == null || !packedFeatures.containsInterval(chr, start, end)) {
                this.loadFeatures(chr, start, end, context);
                if (!IGV.getInstance().isExportingSnapshot()) {
                    return;
                }
            }
            try {
                this.renderFeatureImpl(context, inputRect, packedFeatures);
            }
            catch (TribbleException e) {
                log.error("Tribble error", e);
                if (this.fatalLoadError) break block7;
                this.fatalLoadError = true;
                boolean unload = MessageUtils.confirm("<html> Error loading features: " + e.getMessage() + "<br>Unload track " + this.getName() + "?");
                if (unload) {
                    List<Track> tmp = Arrays.asList(this);
                    IGV.getInstance().removeTracks(tmp);
                    IGV.getInstance().doRefresh();
                }
                this.fatalLoadError = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFeatureImpl(RenderContext context, Rectangle inputRect, PackedFeatures packedFeatures) {
        FeatureRenderer renderer = this.getRenderer();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
            List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
            if (rows != null && rows.size() > 0) {
                int nLevels = rows.size();
                List<Rectangle> list = this.levelRects;
                synchronized (list) {
                    this.levelRects.clear();
                    double h = inputRect.getHeight() / (double)nLevels;
                    Rectangle rect = new Rectangle(inputRect.x, inputRect.y, inputRect.width, (int)h);
                    int i = 0;
                    for (PackedFeatures.FeatureRow row : rows) {
                        this.levelRects.add(new Rectangle(rect));
                        renderer.render(row.features, context, this.levelRects.get(i), this);
                        if (this.selectedFeatureRowIndex == i) {
                            Graphics2D fontGraphics = context.getGraphic2DForColor(SELECTED_FEATURE_ROW_COLOR);
                            fontGraphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                        }
                        rect.y = (int)((double)rect.y + h);
                        ++i;
                    }
                }
            }
        } else {
            List features = packedFeatures.getFeatures();
            if (features != null) {
                renderer.render(features, context, inputRect, this);
            }
        }
    }

    protected synchronized void loadFeatures(final String chr, final int start, final int end, final RenderContext context) {
        this.featuresLoading = true;
        boolean aSync = !(this.source instanceof FeatureCollectionSource);
        NamedRunnable runnable = new NamedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int expandedEnd;
                    int delta;
                    int expandedStart;
                    Iterator iter;
                    Chromosome c;
                    FeatureTrack.this.featuresLoading = true;
                    int maxEnd = end;
                    Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
                    if (genome != null && (c = genome.getChromosome(chr)) != null) {
                        maxEnd = Math.max(c.getLength(), end);
                    }
                    if ((iter = FeatureTrack.this.source.getFeatures(chr, expandedStart = start - (delta = (end - start) / 2), expandedEnd = end + delta)) == null) {
                        PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd);
                        FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                    } else {
                        PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd, iter, this.getName());
                        FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                    }
                    IGV.getInstance().layoutMainPanel();
                    if (context.getPanel() != null) {
                        context.getPanel().repaint();
                    }
                }
                catch (Throwable e) {
                    PackedFeatures pf = new PackedFeatures(chr, start, end);
                    FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                    String msg = "Error loading features for interval: " + chr + ":" + start + "-" + end + " <br>" + e.toString();
                    MessageUtils.showMessage(msg);
                    log.error(msg, e);
                }
                finally {
                    FeatureTrack.this.featuresLoading = false;
                }
            }

            @Override
            public String getName() {
                return "Load features: " + FeatureTrack.this.getName();
            }
        };
        if (aSync) {
            LongRunningTask.submit(runnable);
        } else {
            runnable.run();
        }
    }

    public Feature nextFeature(String chr, double center, boolean forward, ReferenceFrame frame) throws IOException {
        Feature f;
        block13: {
            f = null;
            boolean canScroll = forward && !frame.windowAtEnd() || !forward && frame.getOrigin() > 0.0;
            PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
            if (packedFeatures == null || !packedFeatures.containsInterval(chr, (int)center - 1, (int)center + 1)) break block13;
            if (packedFeatures.getFeatures().size() > 0 && canScroll) {
                Feature feature = f = forward ? FeatureUtils.getFeatureAfter(center + 1.0, packedFeatures.getFeatures()) : FeatureUtils.getFeatureBefore(center - 1.0, packedFeatures.getFeatures());
            }
            if (f == null) {
                int binSize = this.source.getFeatureWindowSize();
                Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
                if (forward) {
                    int nextStart = packedFeatures.getEnd();
                    String nextChr = chr;
                    while (nextChr != null) {
                        int chrLength = genome.getChromosome(nextChr).getLength();
                        while (nextStart < chrLength) {
                            int nextEnd = binSize > 0 ? nextStart + this.source.getFeatureWindowSize() : chrLength;
                            Iterator iter = this.source.getFeatures(nextChr, nextStart, nextEnd);
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Feature feat = (Feature)iter.next();
                                    if (feat.getStart() <= nextStart) continue;
                                    return feat;
                                }
                            }
                            nextStart = nextEnd;
                        }
                        nextChr = genome.getNextChrName(nextChr);
                        nextStart = 0;
                    }
                } else {
                    int nextEnd = packedFeatures.getStart();
                    String nextChr = chr;
                    while (nextChr != null) {
                        while (nextEnd > 0) {
                            int nextStart = binSize > 0 ? Math.max(0, nextEnd - this.source.getFeatureWindowSize()) : 0;
                            Iterator iter = this.source.getFeatures(nextChr, nextStart, nextEnd);
                            if (iter != null && iter.hasNext()) {
                                Feature prevFeature = null;
                                while (iter.hasNext()) {
                                    Feature feat = (Feature)iter.next();
                                    if (feat.getStart() >= nextEnd) continue;
                                    prevFeature = feat;
                                }
                                if (prevFeature != null) {
                                    return prevFeature;
                                }
                            }
                            nextEnd = nextStart;
                        }
                        if ((nextChr = genome.getPrevChrName(nextChr)) == null) continue;
                        nextEnd = genome.getChromosome(nextChr).getLength();
                    }
                }
            }
        }
        return f;
    }

    @Override
    public void setVisibilityWindow(int windowSize) {
        super.setVisibilityWindow(windowSize);
        this.packedFeaturesMap.clear();
        this.source.setFeatureWindowSize(this.visibilityWindow);
    }

    public int getSelectedFeatureRowIndex() {
        return this.selectedFeatureRowIndex;
    }

    public void setSelectedFeatureRowIndex(int selectedFeatureRowIndex) {
        this.selectedFeatureRowIndex = selectedFeatureRowIndex;
    }

    public IGVFeature getSelectedFeature() {
        return this.selectedFeature;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> stateMap = super.getPersistentState();
        return stateMap;
    }

    public static boolean isDrawBorder() {
        return drawBorder;
    }

    public static void setDrawBorder(boolean drawBorder) {
        FeatureTrack.drawBorder = drawBorder;
    }

    public boolean isAlternateExonColor() {
        return this.alternateExonColor;
    }
}

