/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.tribble.Feature;

public class EncodePeakCodec
extends UCSCCodec {
    Genome genome;

    public EncodePeakCodec() {
        this.genome = null;
    }

    public EncodePeakCodec(Genome genome) {
        this.genome = genome;
    }

    public Feature decode(String nextLine) {
        int peak;
        int strandChar;
        if (nextLine.trim().length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(nextLine);
        int tokenCount = tokens.length;
        if (tokenCount < 9) {
            return null;
        }
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getChromosomeAlias(c);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        feature.setName(tokens[3]);
        feature.setScore(Float.parseFloat(tokens[4]));
        String strandString = tokens[5].trim();
        int n = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        if (strandChar == 45) {
            feature.setStrand(Strand.NEGATIVE);
        } else if (strandChar == 43) {
            feature.setStrand(Strand.POSITIVE);
        } else {
            feature.setStrand(Strand.NONE);
        }
        StringBuffer desc = new StringBuffer();
        desc.append("Signal value: " + tokens[6]);
        desc.append("<br>P value: " + tokens[7]);
        desc.append("<br>Q value: " + tokens[8]);
        if (tokens.length > 9 && (peak = Integer.parseInt(tokens[9])) >= 0) {
            desc.append("<br>Peak: " + (feature.getStart() + peak + 1));
        }
        feature.setDescription(desc.toString());
        return feature;
    }

    @Override
    public boolean canDecode(String s) {
        return s.toLowerCase().contains("narrowpeak");
    }
}

