/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.feature.genome.FastaIndexedSequence;
import org.broad.igv.feature.genome.Sequence;

public class FastaDirectorySequence
implements Sequence {
    Map<String, FastaIndexedSequence> sequenceMap;

    public FastaDirectorySequence(String directoryPath, String[] fastaFiles) throws IOException {
        this.readIndeces(directoryPath, fastaFiles);
    }

    private void readIndeces(String directoryPath, String[] fastaFiles) throws IOException {
        this.sequenceMap = new LinkedHashMap<String, FastaIndexedSequence>();
        for (String file : fastaFiles) {
            String fastaPath = directoryPath + "/" + file;
            FastaIndexedSequence fastaSequence = new FastaIndexedSequence(fastaPath);
            for (String chr : fastaSequence.getChromosomeNames()) {
                this.sequenceMap.put(chr, fastaSequence);
            }
        }
    }

    public Collection<FastaIndexedSequence> getFastaSequences() {
        return this.sequenceMap.values();
    }

    @Override
    public byte[] readSequence(String chr, int start, int end) {
        if (!this.sequenceMap.containsKey(chr)) {
            return null;
        }
        return this.sequenceMap.get(chr).readSequence(chr, start, end);
    }
}

