/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broad.igv.dev.affective.Annotation;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;

public class AffectiveAnnotationTrack
extends AbstractTrack {
    int samplingRate = 8;
    List<MouseableRegion> mouseRegions = new ArrayList<MouseableRegion>();
    Map<String, List<Annotation>> annotationMap;
    private int rowHeight = 12;
    private int topMargin = 10;
    ColorPalette pallete;
    PaletteColorTable colorTable;

    public AffectiveAnnotationTrack(String id, String name, Map<String, List<Annotation>> annotationMap) {
        super(id, name);
        this.annotationMap = annotationMap;
        this.colorTable = new PaletteColorTable(ColorUtilities.getNextPalette());
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public int getHeight() {
        return this.topMargin + this.annotationMap.size() * this.rowHeight;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle clipRect) {
        Font font = FontManager.getFont(this.rowHeight - 2);
        g2D.setFont(font);
        int rowTop = trackRectangle.y + this.topMargin;
        for (Map.Entry<String, List<Annotation>> entry : this.annotationMap.entrySet()) {
            g2D.drawString(entry.getKey(), 10, rowTop + this.rowHeight - 2);
            rowTop += this.rowHeight;
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.mouseRegions.clear();
        String date = context.getChr();
        if (this.annotationMap == null || this.annotationMap.isEmpty()) {
            return;
        }
        int rowTop = rect.y + this.topMargin;
        int h = this.rowHeight - 2;
        double startTime = context.getOrigin();
        double endTime = context.getEndLocation();
        for (Map.Entry<String, List<Annotation>> entry : this.annotationMap.entrySet()) {
            int py = rowTop + 1;
            double scale = context.getScale();
            double origin = context.getOrigin();
            List<Annotation> annotations = entry.getValue();
            for (Annotation annot : annotations) {
                if (!date.equals(annot.date)) continue;
                int ts = annot.startTime * this.samplingRate;
                int te = annot.endTime * this.samplingRate;
                int px = (int)(((double)ts - origin) / scale);
                int w = (int)Math.max(3.0, (double)(te - ts) / scale);
                Color c = this.colorTable.get(annot.description);
                Graphics2D g = context.getGraphic2DForColor(c);
                g.fillRect(px, py, w, h);
                MouseableRegion mr = new MouseableRegion(new Rectangle(ts, py, te - ts, h), "", annot.descriptiveText);
                this.mouseRegions.add(mr);
            }
            rowTop += this.rowHeight;
        }
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        for (MouseableRegion mr : this.mouseRegions) {
            if (!mr.containsPoint(position, y)) continue;
            return mr.getText();
        }
        return null;
    }
}

