/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.File;
import java.io.OutputStream;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMTextWriter;
import org.broad.igv.sam.SamAlignment;

public class SAMWriter {
    private SAMFileHeader header;

    public SAMWriter(SAMFileHeader header) {
        this.header = header;
    }

    public void writeToFile(File outFile, Iterable<SamAlignment> alignments) {
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, true, outFile);
        this.writeAlignments(writer, alignments);
    }

    public void writeToStream(OutputStream stream, Iterable<SamAlignment> alignments, boolean bam) {
        SAMFileWriterImpl writer = bam ? new BAMFileWriter(stream, new File("")) : new SAMTextWriter(stream);
        writer.setHeader(this.header);
        this.writeAlignments(writer, alignments);
    }

    private void writeAlignments(SAMFileWriter writer, Iterable<SamAlignment> alignments) {
        for (SamAlignment alignment : alignments) {
            writer.addAlignment(alignment.getRecord());
        }
        writer.close();
    }
}

