/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import org.broad.igv.feature.GisticScore;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class GisticTrackRenderer {
    public void setOverlayMode(boolean mode) {
    }

    public void render(Track track, RenderContext context, Rectangle rect) {
        if (!(track instanceof GisticTrack)) {
            return;
        }
        this.plotScores(track, context, rect);
    }

    protected void plotScoresOn(List<GisticScore> scores, Graphics2D g2D, Rectangle rect, int xEnd, double scale, RenderContext vc, int xStart, int yStart) {
        double origin = vc.getOrigin();
        double locScale = vc.getScale();
        int lastY = yStart;
        double lastX = xStart;
        for (GisticScore score : scores) {
            double scaledY = scale * (double)this.transform(score.getQValue());
            int y = (int)(rect.getMaxY() - scaledY);
            double x1 = ((double)(score.getStart() - 1) - origin) / locScale;
            double x2 = ((double)score.getEnd() - origin) / locScale;
            if (x2 > rect.getX() && lastX < rect.getMaxX()) {
                g2D.drawLine((int)lastX, lastY, (int)x1, y);
                g2D.drawLine((int)x1, y, (int)x2, y);
            }
            lastY = y;
            lastX = x2;
        }
        if ((double)xEnd > rect.getX() && lastX < rect.getMaxX()) {
            g2D.drawLine((int)lastX, lastY, xEnd, yStart);
        }
    }

    private void plotScores(Track track, RenderContext context, Rectangle rect) {
        GisticTrack gisticTrack = (GisticTrack)track;
        String chr = context.getChr();
        float maxQValue = this.transform(track.getDataRange().getMaximum());
        if (maxQValue > 0.0f) {
            Graphics2D g2D;
            double scale = (rect.getHeight() - 5.0) / (double)maxQValue;
            int xStart = (int)rect.getX();
            int yStart = (int)rect.getMaxY();
            int xEnd = (int)rect.getWidth();
            List<GisticScore> scores = gisticTrack.getAmpScores(chr);
            if (scores != null) {
                g2D = context.getGraphic2DForColor(Color.RED);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.plotScoresOn(scores, g2D, rect, xEnd, scale, context, xStart, yStart);
            }
            if ((scores = gisticTrack.getDelScores(chr)) != null) {
                g2D = context.getGraphic2DForColor(Color.BLUE);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.plotScoresOn(scores, g2D, rect, xEnd, scale, context, xStart, yStart);
            }
        }
    }

    public float transform(double value) {
        return (float)Math.log(1.0 + value);
    }

    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
    }
}

