/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.seg.Segment;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

public class SegmentedAsciiDataSet
implements SegmentedDataSet {
    TrackType trackType = TrackType.COPY_NUMBER;
    float dataMax = -3.4028235E38f;
    float dataMin = Float.MAX_VALUE;
    private boolean logNormalized = false;
    private Map<String, Map<String, List<LocusScore>>> segments = new HashMap<String, Map<String, List<LocusScore>>>();
    private Set<String> chromosomes = new HashSet<String>();
    private List<String> headings = new ArrayList<String>();
    private Map<String, List<LocusScore>> wholeGenomeScoresCache = new HashMap<String, List<LocusScore>>();
    private long lastRefreshTime = 0L;
    private TrackProperties trackProperties;
    Genome genome;

    public SegmentedAsciiDataSet(Genome genome) {
        this.genome = genome;
    }

    public SegmentedAsciiDataSet(ResourceLocator locator, Genome genome) {
        this.genome = genome;
        this.sortLists();
    }

    public void sortLists() {
        for (Map.Entry<String, Map<String, List<LocusScore>>> sampleEntry : this.segments.entrySet()) {
            for (Map.Entry<String, List<LocusScore>> chrEntry : sampleEntry.getValue().entrySet()) {
                List<LocusScore> tmp = chrEntry.getValue();
                FeatureUtils.sortFeatureList(tmp);
            }
        }
    }

    public void addSegment(String heading, String c, int start, int end, float value, String desc) {
        List<LocusScore> segmentList;
        String chr = this.genome == null ? c : this.genome.getChromosomeAlias(c);
        Map<String, List<LocusScore>> chrSegments = this.segments.get(heading);
        if (chrSegments == null) {
            this.headings.add(heading);
            chrSegments = new HashMap<String, List<LocusScore>>();
            this.segments.put(heading, chrSegments);
        }
        if ((segmentList = chrSegments.get(chr)) == null) {
            segmentList = new ArrayList<LocusScore>();
            chrSegments.put(chr, segmentList);
        }
        segmentList.add(new Segment(start, start, end, end, value, desc));
        this.dataMax = Math.max(this.dataMax, value);
        this.dataMin = Math.min(this.dataMin, value);
        if (value < 0.0f) {
            this.logNormalized = true;
        }
        this.chromosomes.add(chr);
    }

    public Set<String> getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public List<LocusScore> getSegments(String heading, String chr) {
        Map<String, List<LocusScore>> chrSegments = this.segments.get(heading);
        return chrSegments == null ? null : chrSegments.get(chr);
    }

    public List<String> getDataHeadings() {
        return this.headings;
    }

    @Override
    public List<String> getSampleNames() {
        return this.headings;
    }

    @Override
    public TrackType getType() {
        return this.trackType;
    }

    @Override
    public boolean isLogNormalized() {
        return this.logNormalized;
    }

    @Override
    public double getDataMax(String chr) {
        return this.dataMax;
    }

    @Override
    public double getDataMin(String chr) {
        return this.dataMin;
    }

    @Override
    public List<LocusScore> getWholeGenomeScores(String heading) {
        List<LocusScore> wholeGenomeScores = this.wholeGenomeScoresCache.get(heading);
        if (wholeGenomeScores == null || wholeGenomeScores.isEmpty()) {
            int locationUnit = 1000;
            int maxScreenSize = 4000;
            double minFeatureSize = 0.0;
            long offset = 0L;
            wholeGenomeScores = new ArrayList<LocusScore>(1000);
            for (String chr : this.genome.getChromosomeNames()) {
                List<LocusScore> chrSegments = this.getSegments(heading, chr);
                if (chrSegments != null) {
                    int lastgEnd = -1;
                    for (LocusScore score : chrSegments) {
                        Segment seg = (Segment)score;
                        int gStart = (int)((offset + (long)score.getStart()) / (long)locationUnit);
                        int gEnd = (int)((offset + (long)score.getEnd()) / (long)locationUnit);
                        if (!((double)(gEnd - gStart) > minFeatureSize)) continue;
                        wholeGenomeScores.add(new Segment(gStart, gStart, gEnd, gEnd, seg.getScore(), seg.getDescription()));
                    }
                }
                offset += (long)this.genome.getChromosome(chr).getLength();
            }
            this.wholeGenomeScoresCache.put(heading, wholeGenomeScores);
        }
        return wholeGenomeScores;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public void setTrackType(TrackType trackType) {
        this.trackType = trackType;
    }

    public void setTrackProperties(TrackProperties props) {
        this.trackProperties = props;
    }

    public TrackProperties getTrackProperties() {
        if (this.trackProperties == null) {
            this.trackProperties = new TrackProperties();
        }
        return this.trackProperties;
    }
}

