/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.util.LRUCache;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureReader;

public class CachingFeatureReader
implements FeatureReader {
    private static Logger log = Logger.getLogger(CachingFeatureReader.class);
    private static int maxBinCount = 1000;
    private static int defaultBinSize = 16000;
    private int binSize;
    FeatureReader reader;
    LRUCache<String, Bin> cache;

    public CachingFeatureReader(FeatureReader reader) {
        this(reader, maxBinCount, defaultBinSize);
    }

    public CachingFeatureReader(FeatureReader reader, int binCount, int binSize) {
        this.reader = reader;
        this.cache = new LRUCache(this, binCount);
        this.binSize = binSize;
    }

    public void setBinSize(int newSize) {
        this.binSize = newSize;
        this.cache.clear();
    }

    @Override
    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    @Override
    public Object getHeader() {
        return this.reader.getHeader();
    }

    public CloseableTribbleIterator iterator() throws IOException {
        return this.reader.iterator();
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
        this.reader.close();
    }

    public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
        List<Bin> tiles;
        int startBin = 0;
        int endBin = 0;
        if (this.binSize > 0) {
            startBin = start / this.binSize;
            endBin = end / this.binSize;
        }
        if ((tiles = this.getBins(chr, startBin, endBin)).size() == 0) {
            return null;
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (Bin t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Feature> alignments = new ArrayList<Feature>(recordCount);
        alignments.addAll(tiles.get(0).getOverlappingRecords());
        for (Bin t : tiles) {
            alignments.addAll(t.getContainedRecords());
        }
        return new BinIterator(start, end, alignments);
    }

    private List<Bin> getBins(String seq, int startBin, int endBin) {
        ArrayList<Bin> tiles = new ArrayList<Bin>(endBin - startBin + 1);
        ArrayList<Bin> tilesToLoad = new ArrayList<Bin>(endBin - startBin + 1);
        for (int t = startBin; t <= endBin; ++t) {
            String key = seq + "_" + t;
            Bin tile = this.cache.get(key);
            if (tile == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Tile cache miss: " + t);
                }
                int start = t * this.binSize;
                int end = start + this.binSize;
                tile = new Bin(t, start, end);
                this.cache.put(key, tile);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                if (tilesToLoad.size() > 0 && !this.loadTiles(seq, tilesToLoad)) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad);
        }
        return tiles;
    }

    private boolean loadTiles(String seq, List<Bin> tiles) {
        int end;
        assert (tiles.size() > 0);
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getBinNumber();
            end = tiles.get(tiles.size() - 1).getBinNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start + 1;
        end = tiles.get(tiles.size() - 1).end;
        CloseableTribbleIterator iter = null;
        int featureCount = 0;
        long t0 = System.currentTimeMillis();
        try {
            iter = this.reader.query(seq, start, end);
            while (iter != null && iter.hasNext()) {
                Feature record = (Feature)iter.next();
                int aStart = record.getStart();
                int aEnd = record.getEnd();
                int idx0 = 0;
                int idx1 = 0;
                if (this.binSize > 0) {
                    idx0 = Math.max(0, (aStart - start) / this.binSize);
                    idx1 = Math.min(tiles.size() - 1, (aEnd - start) / this.binSize);
                }
                for (int i = idx0; i <= idx1; ++i) {
                    Bin t = tiles.get(i);
                    if (this.binSize == 0 || aStart >= t.start && aStart < t.end) {
                        t.containedRecords.add(record);
                        continue;
                    }
                    if (aEnd < t.start || aStart >= t.start) continue;
                    t.overlappingRecords.add(record);
                }
            }
            for (Bin t : tiles) {
                t.setLoaded(true);
            }
            if (log.isDebugEnabled()) {
                long dt = System.currentTimeMillis() - t0;
                long rate = dt == 0L ? Long.MAX_VALUE : (long)featureCount / dt;
                log.debug("Loaded " + featureCount + " reads in " + dt + "ms.  (" + rate + " reads/ms)");
            }
            boolean dt = true;
            return dt;
        }
        catch (IOException e) {
            log.error("IOError loading alignment data", e);
            throw new RuntimeException(e);
        }
        finally {
            if (iter != null) {
                // empty if block
            }
        }
    }

    public class BinIterator
    implements CloseableTribbleIterator {
        Iterator<Feature> currentSamIterator;
        int end;
        Feature nextRecord;
        int start;
        List<Feature> alignments;

        BinIterator(int start, int end, List<Feature> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }

        @Override
        public Iterator iterator() {
            return this;
        }
    }

    static class Bin {
        private boolean loaded = false;
        private int start;
        private int end;
        private int binNumber;
        private List<Feature> containedRecords;
        private List<Feature> overlappingRecords;

        Bin(int binNumber, int start, int end) {
            this.binNumber = binNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Feature>(1000);
            this.overlappingRecords = new ArrayList<Feature>(100);
        }

        public int getBinNumber() {
            return this.binNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public List<Feature> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Feature> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }
}

