/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.vcf;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFAllele;
import org.broad.igv.variant.vcf.VCFGenotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFVariant
implements Variant {
    private static Logger log = Logger.getLogger(Variant.class);
    VariantContext variantContext;
    Set<Allele> alternateAlleles;
    private ZygosityCount zygosityCount;
    private boolean isIndel;
    String chr;
    private double alleleFreq;
    private double methylationRate = Double.NaN;
    private double coveredSampleFraction = Double.NaN;

    public VCFVariant(VariantContext variantContext, String chr) {
        this.variantContext = variantContext;
        this.chr = chr;
        this.isIndel = variantContext.getType() == VariantContext.Type.INDEL;
        this.init();
    }

    private void init() {
        this.zygosityCount = new ZygosityCount();
        for (String sample : this.getSampleNames()) {
            Genotype genotype = this.getGenotype(sample);
            this.zygosityCount.incrementCount(genotype);
        }
        String afString = null;
        try {
            afString = this.variantContext.getAttributeAsString("AF", "-1");
            this.alleleFreq = Double.parseDouble(afString);
        }
        catch (NumberFormatException e) {
            this.alleleFreq = -1.0;
            log.error("Error parsing allele fraction: " + afString);
        }
        if (this.alleleFreq < 0.0) {
            try {
                afString = this.variantContext.getAttributeAsString("GMAF", "-1");
                this.alleleFreq = Double.parseDouble(afString);
            }
            catch (NumberFormatException e) {
                this.alleleFreq = -1.0;
                log.error("Error parsing allele fraction: " + afString);
            }
        }
    }

    private void computeMethylationRate() {
        double methTotal = 0.0;
        int samplesWithData = 0;
        int size = this.getSampleNames().size();
        if (size > 0) {
            for (String sample : this.getSampleNames()) {
                Genotype genotype = this.getGenotype(sample);
                double mr = genotype.getAttributeAsDouble("MR");
                double goodBaseCount = genotype.getAttributeAsDouble("MR");
                if (Double.isNaN(mr) || Double.isNaN(goodBaseCount) || !(goodBaseCount > (double)VariantTrack.METHYLATION_MIN_BASE_COUNT)) continue;
                methTotal += mr;
                ++samplesWithData;
            }
            this.methylationRate = samplesWithData == 0 ? 0.0 : methTotal / (double)samplesWithData;
            this.coveredSampleFraction = (double)samplesWithData / (double)size;
        }
    }

    @Override
    public String getID() {
        return this.variantContext.getID();
    }

    @Override
    public boolean isFiltered() {
        return this.variantContext.isFiltered();
    }

    @Override
    public String getAttributeAsString(String key) {
        return this.variantContext.getAttributeAsString(key, null);
    }

    @Override
    public String getReference() {
        return this.variantContext.getReference().toString();
    }

    @Override
    public Set<Allele> getAlternateAlleles() {
        if (this.alternateAlleles == null) {
            List<org.broadinstitute.sting.utils.variantcontext.Allele> tmp = this.variantContext.getAlternateAlleles();
            this.alternateAlleles = new HashSet<Allele>(tmp.size());
            for (org.broadinstitute.sting.utils.variantcontext.Allele a : tmp) {
                this.alternateAlleles.add(new VCFAllele(a.getBases()));
            }
        }
        return this.alternateAlleles;
    }

    @Override
    public double getPhredScaledQual() {
        return this.variantContext.getPhredScaledQual();
    }

    @Override
    public String getType() {
        return this.variantContext.getType().toString();
    }

    @Override
    public double getAlleleFreq() {
        return this.alleleFreq;
    }

    @Override
    public double getAlleleFraction() {
        int total = this.getHomVarCount() + this.getHetCount() + this.getHomRefCount();
        return total == 0 ? -1.0 : ((double)this.getHomVarCount() + (double)this.getHetCount() / 2.0) / (double)total;
    }

    @Override
    public double getMethlationRate() {
        if (Double.isNaN(this.methylationRate)) {
            this.computeMethylationRate();
        }
        return this.methylationRate;
    }

    @Override
    public double getCoveredSampleFraction() {
        if (Double.isNaN(this.coveredSampleFraction)) {
            this.computeMethylationRate();
        }
        return this.coveredSampleFraction;
    }

    @Override
    public Collection<String> getSampleNames() {
        return this.variantContext.getSampleNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.variantContext.getAttributes();
    }

    @Override
    public Genotype getGenotype(String sample) {
        return new VCFGenotype(this.variantContext.getGenotype(sample));
    }

    @Override
    public Collection<String> getFilters() {
        return this.variantContext.getFilters();
    }

    @Override
    public int getHomVarCount() {
        return this.zygosityCount.getHomVar();
    }

    @Override
    public int getHetCount() {
        return this.zygosityCount.getHet();
    }

    @Override
    public int getHomRefCount() {
        return this.zygosityCount.getHomRef();
    }

    @Override
    public int getNoCallCount() {
        return this.zygosityCount.getNoCall();
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.isIndel ? this.variantContext.getStart() : this.variantContext.getStart() - 1;
    }

    @Override
    public int getEnd() {
        return this.variantContext.getEnd();
    }

    @Override
    public String getPositionString() {
        if (this.variantContext.getStart() == this.variantContext.getEnd()) {
            return String.valueOf(this.variantContext.getStart());
        }
        return String.format("%d-%d", this.variantContext.getStart(), this.variantContext.getEnd());
    }

    public String toString() {
        return String.format("VCFVariant[%s:%d-%d]", this.getChr(), this.getStart(), this.getEnd());
    }

    public static class ZygosityCount {
        private int homVar = 0;
        private int het = 0;
        private int homRef = 0;
        private int noCall = 0;

        public void incrementCount(Genotype genotype) {
            if (genotype != null) {
                if (genotype.isHomVar()) {
                    ++this.homVar;
                } else if (genotype.isHet()) {
                    ++this.het;
                } else if (genotype.isHomRef()) {
                    ++this.homRef;
                } else {
                    ++this.noCall;
                }
            }
        }

        public int getHomVar() {
            return this.homVar;
        }

        public int getHet() {
            return this.het;
        }

        public int getHomRef() {
            return this.homRef;
        }

        public int getNoCall() {
            return this.noCall;
        }
    }
}

