/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.AbstractAlignment;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;

public class SamAlignment
extends AbstractAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(SamAlignment.class);
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    private int start;
    private int end;
    private int alignmentStart;
    private int alignmentEnd;
    private int readLength;
    private boolean readNegativeStrandFlag;
    private boolean duplicateReadFlag;
    private boolean readUnmappedFlag;
    private boolean readPairedFlag;
    private boolean properPairFlag;
    private SAMRecord record;
    private String cigarString;
    private String readSequence;
    private boolean firstRead = false;
    private boolean secondRead = false;
    private String mateSequence = null;
    private String pairOrientation = "";
    private Color defaultColor = AlignmentRenderer.grey1;
    private String readGroup;
    private String library;
    private String sample;
    private boolean firstInPair;
    private Strand firstOfPairStrand;
    private Strand secondOfPairStrand;
    protected static final char[] NT2COMP = new char[]{'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N'};

    public SamAlignment(SAMRecord record) {
        String flowOrder = null;
        String keySequence = null;
        this.record = record;
        String refName = record.getReferenceName();
        Genome genome = Globals.isHeadless() ? null : IGV.getInstance().getGenomeManager().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getChromosomeAlias(refName);
        this.start = this.alignmentStart = record.getAlignmentStart() - 1;
        this.end = this.alignmentEnd = Math.max(this.alignmentStart, record.getAlignmentEnd());
        this.cigarString = record.getCigarString();
        this.setMappingQuality(record.getMappingQuality());
        this.readName = record.getReadName().trim();
        this.readNegativeStrandFlag = record.getReadNegativeStrandFlag();
        this.duplicateReadFlag = record.getDuplicateReadFlag();
        this.readUnmappedFlag = record.getReadUnmappedFlag();
        this.readPairedFlag = record.getReadPairedFlag();
        this.setInferredInsertSize(record.getInferredInsertSize());
        this.readSequence = record.getReadString();
        this.readLength = record.getReadLength();
        this.firstInPair = record.getReadPairedFlag() ? record.getFirstOfPairFlag() : true;
        this.setMatePair(record, genome);
        this.setPairOrientation(record);
        this.setPairStrands();
        SAMFileHeader header = record.getHeader();
        if (header != null) {
            SAMReadGroupRecord rgRec;
            this.readGroup = (String)record.getAttribute("RG");
            if (this.readGroup != null && (rgRec = header.getReadGroup(this.readGroup)) != null) {
                String platform = rgRec.getPlatform();
                this.sample = rgRec.getSample();
                this.library = rgRec.getLibrary();
                flowOrder = rgRec.getFlowOrder();
                keySequence = rgRec.getKeySequence();
            }
        }
        this.createAlignmentBlocks(record.getCigarString(), record.getReadBases(), record.getBaseQualities(), this.getFlowSignals(record, flowOrder, keySequence), flowOrder, this.getFlowSignalsStart());
        Object colorTag = record.getAttribute("YC");
        if (colorTag != null) {
            try {
                this.defaultColor = ColorUtilities.stringToColor(colorTag.toString());
            }
            catch (Exception e) {
                log.error("Error interpreting color tag: " + colorTag, e);
                this.defaultColor = AlignmentRenderer.grey1;
            }
        }
    }

    private void setMatePair(SAMRecord record, Genome genome) {
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            this.properPairFlag = record.getProperPairFlag();
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart(), record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
            this.firstRead = record.getFirstOfPairFlag();
            this.secondRead = record.getSecondOfPairFlag();
        }
    }

    private void setPairOrientation(SAMRecord record) {
        if (record.getReadPairedFlag() && !this.readUnmappedFlag && !record.getMateUnmappedFlag() && record.getReferenceName().equals(record.getMateReferenceName())) {
            int s1 = record.getReadNegativeStrandFlag() ? 82 : 70;
            int s2 = record.getMateNegativeStrandFlag() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (record.getFirstOfPairFlag()) {
                o1 = 49;
                o2 = 50;
            } else if (record.getSecondOfPairFlag()) {
                o1 = 50;
                o2 = 49;
            }
            char[] tmp = new char[4];
            if (record.getInferredInsertSize() > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            this.pairOrientation = new String(tmp);
        }
    }

    private void setPairStrands() {
        if (this.isPaired()) {
            ReadMate mate;
            this.firstOfPairStrand = this.isFirstOfPair() ? this.getReadStrand() : ((mate = this.getMate()) != null && mate.isMapped() ? mate.getStrand() : Strand.NONE);
            this.secondOfPairStrand = this.isSecondOfPair() ? (this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : ((mate = this.getMate()).isMapped() && this.isProperPair() ? (mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : Strand.NONE);
        } else {
            this.firstOfPairStrand = this.getReadStrand();
            this.secondOfPairStrand = Strand.NONE;
        }
    }

    private void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities) {
        this.createAlignmentBlocks(cigarString, readBases, readBaseQualities, null, null, -1);
    }

    private void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities, short[] flowSignals, String flowOrder, int flowOrderStart) {
        boolean showSoftClipped = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
        int nInsertions = 0;
        int nBlocks = 0;
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuffer buffer = new StringBuffer(4);
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlock[1];
            this.alignmentBlocks[0] = new AlignmentBlock(this.getStart(), readBases, readBaseQualities, this);
            return;
        }
        boolean firstOperator = true;
        int softClippedBaseCount = 0;
        int nGaps = 0;
        char prevOp = '\u0000';
        for (int i = 0; i < cigarString.length(); ++i) {
            char next = cigarString.charAt(i);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            if (op == 'H') {
                buffer = new StringBuffer(4);
                continue;
            }
            int nBases = Integer.parseInt(buffer.toString());
            if (this.operatorIsMatch(showSoftClipped, op)) {
                if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                    ++nGaps;
                }
                ++nBlocks;
            } else if (op == 'D' || op == 'N') {
                ++nGaps;
            } else if (op == 'I') {
                ++nInsertions;
                ++nGaps;
            }
            if (firstOperator && op == 'S') {
                softClippedBaseCount += nBases;
            }
            operators.add(new CigarOperator(nBases, op));
            buffer = new StringBuffer(4);
            prevOp = op;
            firstOperator = false;
        }
        this.alignmentBlocks = new AlignmentBlock[nBlocks];
        this.insertions = new AlignmentBlock[nInsertions];
        if (nGaps > 0) {
            this.gapTypes = new char[nGaps];
        }
        if (showSoftClipped) {
            this.start -= softClippedBaseCount;
        }
        int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
        int blockStart = this.start;
        int blockIdx = 0;
        int insertionIdx = 0;
        int gapIdx = 0;
        FlowOrderAndSignalsBlockHelper fBlockHelper = null;
        if (null != flowSignals && 0 < readBases.length) {
            fBlockHelper = new FlowOrderAndSignalsBlockHelper(flowSignals, flowOrder, flowOrderStart, readBases, this.readNegativeStrandFlag);
        }
        prevOp = '\u0000';
        for (CigarOperator op : operators) {
            try {
                if (op.operator == 'H') continue;
                if (this.operatorIsMatch(showSoftClipped, op.operator)) {
                    byte[] blockBases = new byte[op.nBases];
                    byte[] blockQualities = new byte[op.nBases];
                    short[][][] blockFlowSignals = null;
                    AlignmentBlock block = null;
                    Arrays.fill(blockQualities, (byte)126);
                    int nBasesAvailable = readBases.length - fromIdx;
                    if (readBases == null || readBases.length == 0) {
                        Arrays.fill(blockBases, (byte)61);
                    } else if (nBasesAvailable < op.nBases) {
                        Arrays.fill(blockBases, (byte)63);
                    } else {
                        System.arraycopy(readBases, fromIdx, blockBases, 0, op.nBases);
                    }
                    nBasesAvailable = readBaseQualities.length - fromIdx;
                    if (readBaseQualities == null || readBaseQualities.length == 0 || nBasesAvailable < op.nBases) {
                        Arrays.fill(blockQualities, (byte)126);
                    } else {
                        System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, op.nBases);
                    }
                    if (null != fBlockHelper) {
                        blockFlowSignals = fBlockHelper.createBlockFlowSignals(readBases, fromIdx, op.nBases);
                        block = AlignmentBlock.getInstance(blockStart, blockBases, blockQualities, blockFlowSignals, this);
                    } else {
                        block = AlignmentBlock.getInstance(blockStart, blockBases, blockQualities, this);
                    }
                    if (op.operator == 'S') {
                        block.setSoftClipped(true);
                    }
                    this.alignmentBlocks[blockIdx++] = block;
                    fromIdx += op.nBases;
                    blockStart += op.nBases;
                    if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                        this.gapTypes[gapIdx++] = 79;
                    }
                } else if (op.operator == 'D' || op.operator == 'N') {
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'I') {
                    AlignmentBlock block = null;
                    short[][][] blockFlowSignals = null;
                    this.gapTypes[gapIdx++] = 79;
                    byte[] blockBases = new byte[op.nBases];
                    byte[] blockQualities = new byte[op.nBases];
                    if (readBases == null || readBases.length == 0) {
                        Arrays.fill(blockBases, (byte)61);
                    } else {
                        System.arraycopy(readBases, fromIdx, blockBases, 0, op.nBases);
                    }
                    if (readBaseQualities == null || readBaseQualities.length == 0) {
                        Arrays.fill(blockQualities, (byte)126);
                    } else {
                        System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, op.nBases);
                    }
                    if (null != fBlockHelper) {
                        blockFlowSignals = fBlockHelper.createBlockFlowSignals(readBases, fromIdx, op.nBases);
                        block = AlignmentBlock.getInstance(blockStart, blockBases, blockQualities, blockFlowSignals, this);
                    } else {
                        block = AlignmentBlock.getInstance(blockStart, blockBases, blockQualities, this);
                    }
                    this.insertions[insertionIdx++] = block;
                    fromIdx += op.nBases;
                }
            }
            catch (Exception e) {
                log.error("Error processing CIGAR string", e);
            }
            prevOp = op.operator;
        }
        if (showSoftClipped && operators.size() > 0) {
            CigarOperator last = (CigarOperator)operators.get(operators.size() - 1);
            if (last.operator == 'S') {
                this.end += last.nBases;
            }
        }
    }

    private boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    public boolean isFirstInPair() {
        return this.firstInPair;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.readNegativeStrandFlag;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicateReadFlag;
    }

    @Override
    public boolean isMapped() {
        return !this.readUnmappedFlag;
    }

    public int getReadLength() {
        return this.readLength;
    }

    @Override
    public boolean isPaired() {
        return this.readPairedFlag;
    }

    @Override
    public boolean isProperPair() {
        return this.properPairFlag;
    }

    @Override
    public boolean isFirstOfPair() {
        return this.firstRead;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.secondRead;
    }

    public LocusScore copy() {
        return new SamAlignment(this.record);
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public String getCigarString() {
        return this.cigarString;
    }

    @Override
    public String getReadSequence() {
        return this.readSequence;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getSample() {
        return this.sample;
    }

    @Override
    public String getReadGroup() {
        return this.readGroup;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    public String toString() {
        return this.record.getSAMString();
    }

    @Override
    public char[] getGapTypes() {
        return this.gapTypes;
    }

    @Override
    public Object getAttribute(String key) {
        return key.length() == 2 ? this.record.getAttribute(key) : null;
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueStringImpl(location, false);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        return this.getValueStringImpl(position, true);
    }

    String getValueStringImpl(double position, boolean truncate) {
        List<SAMRecord.SAMTagAndValue> attributes;
        StringBuffer buf = new StringBuffer(super.getValueString(position, null));
        if (this.isPaired()) {
            boolean sectionBreak = false;
            if (this.record.getFirstOfPairFlag()) {
                buf.append("<br>First in pair");
                sectionBreak = true;
            }
            if (this.record.getSecondOfPairFlag()) {
                buf.append("<br>Second in pair");
                sectionBreak = true;
            }
            if (this.record.getNotPrimaryAlignmentFlag()) {
                buf.append("<br>Alignment NOT primary");
                sectionBreak = true;
            }
            if (this.record.getReadFailsVendorQualityCheckFlag()) {
                buf.append("<br>FAILED Vendor Quality Check");
                sectionBreak = true;
            }
            if (sectionBreak) {
                buf.append("<br>-------------------");
            }
        }
        if ((attributes = this.record.getAttributes()) != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                buf.append("<br>" + tag.tag + " = ");
                if (tag.value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = tag.value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            buf.append("<br>-------------------");
        }
        if (this.mateSequence != null) {
            buf.append("<br>Unmapped mate sequence: " + this.mateSequence);
            buf.append("<br>-------------------");
        }
        return buf.toString();
    }

    @Override
    public String getMateSequence() {
        return this.mateSequence;
    }

    @Override
    public void setMateSequence(String mateSequence) {
        this.mateSequence = mateSequence;
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public boolean isVendorFailedRead() {
        return this.record.getReadFailsVendorQualityCheckFlag();
    }

    @Override
    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstOfPairStrand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.secondOfPairStrand;
    }

    public int getFlowSignalsStart() {
        Object attribute = this.record.getAttribute("ZF");
        int toRet = -1;
        if (attribute != null && attribute instanceof Integer) {
            toRet = (Integer)attribute;
        }
        return toRet;
    }

    public short[] getFlowSignals(SAMRecord record, String flowOrder, String keySequence) {
        int i;
        short[] r = null;
        if (null == flowOrder || null == keySequence) {
            return null;
        }
        int startFlow = this.getFlowSignalsStart();
        if (startFlow < 0) {
            return null;
        }
        char firstBase = this.readNegativeStrandFlag ? NT2COMP[record.getReadBases()[record.getReadLength() - 1]] : (char)record.getReadBases()[0];
        short keySignalOverlap = 0;
        for (i = keySequence.length() - 1; 0 <= i && keySequence.charAt(i) == firstBase; --i) {
            keySignalOverlap += 100;
        }
        Object attribute = record.getAttribute("FZ");
        if (null == attribute) {
            return null;
        }
        if (attribute instanceof short[]) {
            short[] signals = (short[])attribute;
            r = new short[signals.length - startFlow];
            for (i = startFlow; i < signals.length; ++i) {
                r[i - startFlow] = signals[i];
            }
        } else if (attribute instanceof int[]) {
            int[] signals = (int[])attribute;
            r = new short[signals.length - startFlow];
            System.arraycopy(signals, startFlow, r, 0, r.length);
        } else if (attribute instanceof byte[]) {
            byte[] signals = (byte[])attribute;
            r = new short[signals.length - startFlow];
            for (i = startFlow; i < signals.length; ++i) {
                r[i - startFlow] = signals[i];
            }
        } else {
            return null;
        }
        if (0 < keySignalOverlap && 0 < r.length) {
            r[0] = r[0] <= keySignalOverlap ? (short)0 : (short)(r[0] - keySignalOverlap);
        }
        return r;
    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }

    private class FlowOrderAndSignalsBlockHelper {
        private short[] flowSignals = null;
        private String flowOrder = null;
        private int flowSignalsIndex = -1;
        private int flowOrderIndex = -1;
        private int prevFlowSignalsStart = -1;
        private int prevFlowSignalsEnd = -1;
        private boolean readNegativeStrandFlag;
        private boolean[] incorporations = null;

        public FlowOrderAndSignalsBlockHelper(short[] flowSignals, String flowOrder, int flowOrderStart, byte[] readBases, boolean readNegativeStrandFlag) {
            if (null == flowSignals || null == flowOrder || flowOrderStart < 0) {
                return;
            }
            this.flowSignals = flowSignals;
            this.flowOrder = flowOrder;
            this.flowOrderIndex = flowOrderStart;
            this.flowSignalsIndex = 0;
            this.readNegativeStrandFlag = readNegativeStrandFlag;
            if (this.readNegativeStrandFlag) {
                this.incorporations = new boolean[this.flowSignals.length];
                for (int i = readBases.length - 1; 0 <= i; --i) {
                    while (this.flowOrder.charAt(this.flowOrderIndex) != NT2COMP[readBases[i]]) {
                        ++this.flowOrderIndex;
                        ++this.flowSignalsIndex;
                        this.incorporations[this.flowSignalsIndex] = false;
                        if (this.flowOrder.length() > this.flowOrderIndex) continue;
                        this.flowOrderIndex = 0;
                    }
                    this.incorporations[this.flowSignalsIndex] = true;
                }
                this.prevFlowSignalsStart = this.flowSignalsIndex + 1;
                this.prevFlowSignalsEnd = this.flowSignals.length - 1;
            } else {
                this.prevFlowSignalsEnd = 0;
                this.prevFlowSignalsStart = 0;
                while (this.flowOrder.charAt(this.flowOrderIndex) != readBases[0]) {
                    ++this.flowOrderIndex;
                    ++this.flowSignalsIndex;
                    if (this.flowOrder.length() > this.flowOrderIndex) continue;
                    this.flowOrderIndex = 0;
                }
                this.prevFlowSignalsEnd = this.flowSignalsIndex - 1;
            }
        }

        public short[][][] createBlockFlowSignals(byte[] readBases, int fromIdx, int nBases) {
            Object blockFlowSignals = null;
            if (null == this.flowSignals) {
                return null;
            }
            blockFlowSignals = new short[nBases][][];
            Arrays.fill((Object[])blockFlowSignals, null);
            int i = fromIdx;
            int idx = 0;
            while (0 <= this.flowSignalsIndex && this.flowSignalsIndex < this.flowSignals.length && i < fromIdx + nBases) {
                short s = this.flowSignals[this.flowSignalsIndex];
                int nextFlowSignalsStart = -1;
                int nextFlowSignalsEnd = -1;
                int j = i + 1;
                if (j < readBases.length) {
                    if (this.readNegativeStrandFlag) {
                        nextFlowSignalsEnd = this.flowSignalsIndex - 1;
                        while (!this.incorporations[this.flowSignalsIndex] || this.flowOrder.charAt(this.flowOrderIndex) != NT2COMP[readBases[j]]) {
                            --this.flowOrderIndex;
                            --this.flowSignalsIndex;
                            if (this.flowOrderIndex >= 0) continue;
                            this.flowOrderIndex = this.flowOrder.length() - 1;
                        }
                        nextFlowSignalsStart = this.flowSignalsIndex + 1;
                    } else {
                        nextFlowSignalsStart = this.flowSignalsIndex + 1;
                        while (this.flowOrder.charAt(this.flowOrderIndex) != readBases[j]) {
                            ++this.flowOrderIndex;
                            ++this.flowSignalsIndex;
                            if (this.flowOrder.length() > this.flowOrderIndex) continue;
                            this.flowOrderIndex = 0;
                        }
                        nextFlowSignalsEnd = this.flowSignalsIndex - 1;
                    }
                }
                blockFlowSignals[idx] = new short[3][];
                if (0 <= this.prevFlowSignalsStart && this.prevFlowSignalsStart <= this.prevFlowSignalsEnd && this.prevFlowSignalsEnd < this.flowSignals.length) {
                    blockFlowSignals[idx][0] = new short[this.prevFlowSignalsEnd - this.prevFlowSignalsStart + 1];
                    if (this.readNegativeStrandFlag) {
                        for (j = this.prevFlowSignalsEnd; this.prevFlowSignalsStart <= j; --j) {
                            blockFlowSignals[idx][0][this.prevFlowSignalsEnd - j] = this.flowSignals[j];
                        }
                    } else {
                        for (j = this.prevFlowSignalsStart; j <= this.prevFlowSignalsEnd; ++j) {
                            blockFlowSignals[idx][0][j - this.prevFlowSignalsStart] = this.flowSignals[j];
                        }
                    }
                } else {
                    blockFlowSignals[idx][0] = null;
                }
                blockFlowSignals[idx][1] = new short[1];
                blockFlowSignals[idx][1][0] = s;
                if (0 <= nextFlowSignalsStart && nextFlowSignalsStart <= nextFlowSignalsEnd && nextFlowSignalsEnd < this.flowSignals.length) {
                    blockFlowSignals[idx][2] = new short[nextFlowSignalsEnd - nextFlowSignalsStart + 1];
                    if (this.readNegativeStrandFlag) {
                        for (j = nextFlowSignalsEnd; nextFlowSignalsStart <= j; --j) {
                            blockFlowSignals[idx][2][nextFlowSignalsEnd - j] = this.flowSignals[j];
                        }
                    } else {
                        for (j = nextFlowSignalsStart; j <= nextFlowSignalsEnd; ++j) {
                            blockFlowSignals[idx][2][j - nextFlowSignalsStart] = this.flowSignals[j];
                        }
                    }
                } else {
                    blockFlowSignals[idx][2] = null;
                }
                this.prevFlowSignalsStart = nextFlowSignalsStart;
                this.prevFlowSignalsEnd = nextFlowSignalsEnd;
                ++i;
                ++idx;
            }
            return blockFlowSignals;
        }
    }
}

