/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import org.broad.igv.hic.HeatmapRenderer;
import org.broad.igv.hic.HiC;
import org.broad.igv.hic.IGVUtils;
import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.util.ObjectCache;

public class HeatmapPanel
extends JComponent
implements Serializable {
    MainWindow mainWindow;
    private HiC hic;
    private int imageTileWidth = 500;
    ObjectCache<String, ImageTile> tileCache = new ObjectCache(100);
    private Rectangle zoomRectangle;
    private int[] chromosomeBoundaries;
    HeatmapRenderer renderer;

    public HeatmapPanel(MainWindow mainWindow, HiC hic) {
        this.mainWindow = mainWindow;
        this.hic = hic;
        this.renderer = new HeatmapRenderer(mainWindow, hic);
        HeatmapMouseHandler mouseHandler = new HeatmapMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setObservedRange(int min, int max) {
        this.renderer.setObservedRange(min, max);
        this.clearTileCache();
        this.repaint();
    }

    public void setChromosomeBoundaries(int[] chromosomeBoundaries) {
        this.chromosomeBoundaries = chromosomeBoundaries;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        g.clearRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        if (this.hic != null && this.hic.zd != null) {
            boolean isWholeGenome;
            double scale = this.hic.xContext.getScale();
            if (scale <= 0.0) {
                return;
            }
            int binSize = this.hic.zd.getBinSize();
            int originX = this.hic.xContext.getOrigin();
            int originY = this.hic.yContext.getOrigin();
            int bLeft = originX / binSize;
            int bRight = (int)(((double)originX + (double)this.getWidth() * scale) / (double)binSize);
            int bTop = originY / binSize;
            int bBottom = (int)(((double)originY + (double)this.getHeight() * scale) / (double)binSize);
            int tLeft = bLeft / this.imageTileWidth;
            int tRight = bRight / this.imageTileWidth;
            int tTop = bTop / this.imageTileWidth;
            int tBottom = bBottom / this.imageTileWidth;
            double pixelsPerBin = (double)binSize / scale;
            for (int i = tLeft; i <= tRight; ++i) {
                for (int j = tTop; j <= tBottom; ++j) {
                    ImageTile tile = this.getImageTile(i, j, pixelsPerBin, this.hic.getDisplayOption());
                    if (tile == null) continue;
                    int pxOffset = (int)((double)(tile.bLeft - bLeft) * pixelsPerBin);
                    int pyOffset = (int)((double)(tile.bTop - bTop) * pixelsPerBin);
                    g.drawImage(tile.image, pxOffset, pyOffset, null);
                }
            }
            boolean bl = isWholeGenome = this.hic.xContext.getChromosome().getName().equals("All") && this.hic.yContext.getChromosome().getName().equals("All");
            if (isWholeGenome) {
                Color color = g.getColor();
                g.setColor(Color.lightGray);
                Chromosome[] chromosomes = this.hic.getChromosomes();
                int xGenomeCoord = 0;
                for (int i = 1; i < chromosomes.length; ++i) {
                    Chromosome c = chromosomes[i];
                    int x = this.hic.xContext.getScreenPosition(xGenomeCoord += c.getSize() / 1000);
                    g.drawLine(x, 0, x, this.getHeight());
                }
                int yGenomeCoord = 0;
                for (int i = 1; i < chromosomes.length; ++i) {
                    Chromosome c = chromosomes[i];
                    int y = this.hic.yContext.getScreenPosition(yGenomeCoord += c.getSize() / 1000);
                    g.drawLine(0, y, this.getWidth(), y);
                }
                g.setColor(color);
            }
        }
        if (this.zoomRectangle != null) {
            ((Graphics2D)g).draw(this.zoomRectangle);
        }
    }

    public Image getThumbnailImage(MatrixZoomData zd, int tw, int th, MainWindow.DisplayOption displayOption) {
        int maxBinCountX = (this.hic.xContext.getChrLength() - this.hic.xContext.getOrigin()) / zd.getBinSize() + 1;
        int maxBinCountY = (this.hic.yContext.getChrLength() - this.hic.yContext.getOrigin()) / zd.getBinSize() + 1;
        int wh = Math.max(maxBinCountX, maxBinCountY);
        BufferedImage image = (BufferedImage)this.createImage(wh, wh);
        Graphics2D g = image.createGraphics();
        Rectangle clipBounds = new Rectangle(0, 0, wh, wh);
        this.renderer.render(0, 0, maxBinCountX, maxBinCountY, zd, displayOption, g);
        return image.getScaledInstance(tw, th, 4);
    }

    private ImageTile getImageTile(int i, int j, double scaleFactor, MainWindow.DisplayOption displayOption) {
        String key = "_" + i + "_" + j + "_" + (Object)((Object)displayOption);
        ImageTile tile = this.tileCache.get(key);
        if (tile == null) {
            int maxBinCountX = (this.hic.xContext.getChrLength() - this.hic.xContext.getOrigin()) / this.hic.zd.getBinSize() + 1;
            int maxBinCountY = (this.hic.yContext.getChrLength() - this.hic.yContext.getOrigin()) / this.hic.zd.getBinSize() + 1;
            if (maxBinCountX < 0 || maxBinCountY < 0) {
                return null;
            }
            int imageWidth = Math.min(maxBinCountX, this.imageTileWidth);
            int imageHeight = Math.min(maxBinCountY, this.imageTileWidth);
            BufferedImage image = (BufferedImage)this.createImage(imageWidth, imageHeight);
            Graphics2D g2D = (Graphics2D)image.getGraphics();
            int bx0 = i * this.imageTileWidth;
            int by0 = j * this.imageTileWidth;
            this.renderer.render(bx0, by0, imageWidth, imageHeight, this.hic.zd, displayOption, g2D);
            if (scaleFactor > 0.999 && scaleFactor < 1.001) {
                tile = new ImageTile(image, bx0, by0);
            } else {
                int scaledWidth = (int)(scaleFactor * (double)imageWidth);
                int scaledHeight = (int)(scaleFactor * (double)imageHeight);
                Image scaledImage = image.getScaledInstance(scaledWidth, scaledHeight, 4);
                tile = new ImageTile(scaledImage, bx0, by0);
            }
            this.tileCache.put(key, tile);
        }
        return tile;
    }

    public void clearTileCache() {
        this.tileCache.clear();
    }

    class HeatmapMouseHandler
    extends MouseAdapter {
        DragMode dragMode = DragMode.NONE;
        private Point lastMousePoint;

        HeatmapMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (HeatmapPanel.this.hic.isWholeGenome()) {
                return;
            }
            if (e.isAltDown()) {
                this.dragMode = DragMode.ZOOM;
            } else {
                this.dragMode = DragMode.PAN;
                MainWindow cfr_ignored_0 = HeatmapPanel.this.mainWindow;
                HeatmapPanel.this.setCursor(MainWindow.fistCursor);
            }
            this.lastMousePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragMode == DragMode.ZOOM && HeatmapPanel.this.zoomRectangle != null) {
                double xBP = ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(((HeatmapPanel)HeatmapPanel.this).zoomRectangle.x);
                double yBP = ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(((HeatmapPanel)HeatmapPanel.this).zoomRectangle.y);
                double wBP = (double)((HeatmapPanel)HeatmapPanel.this).zoomRectangle.width * ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getScale();
                double hBP = (double)((HeatmapPanel)HeatmapPanel.this).zoomRectangle.height * ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getScale();
                double newXScale = wBP / (double)HeatmapPanel.this.getWidth();
                double newYScale = hBP / (double)HeatmapPanel.this.getHeight();
                double newScale = Math.max(newXScale, newYScale);
                HeatmapPanel.this.hic.zoomTo(xBP, yBP, newScale);
            }
            this.dragMode = DragMode.NONE;
            this.lastMousePoint = null;
            HeatmapPanel.this.zoomRectangle = null;
            HeatmapPanel.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public final void mouseDragged(MouseEvent e) {
            if (((HeatmapPanel)HeatmapPanel.this).hic.zd == null || HeatmapPanel.this.hic.isWholeGenome()) {
                return;
            }
            if (this.lastMousePoint == null) {
                this.lastMousePoint = e.getPoint();
                return;
            }
            double deltaX = e.getX() - this.lastMousePoint.x;
            double deltaY = e.getY() - this.lastMousePoint.y;
            switch (this.dragMode) {
                case ZOOM: {
                    Rectangle lastRectangle = HeatmapPanel.this.zoomRectangle;
                    if (deltaX == 0.0 || deltaY == 0.0) {
                        return;
                    }
                    double aspectRatio = (double)HeatmapPanel.this.getWidth() / (double)HeatmapPanel.this.getHeight();
                    if (deltaX * aspectRatio > deltaY) {
                        deltaY = (int)(deltaX / aspectRatio);
                    } else {
                        deltaX = (int)(deltaY * aspectRatio);
                    }
                    int x = deltaX > 0.0 ? this.lastMousePoint.x : this.lastMousePoint.x + (int)deltaX;
                    int y = deltaY > 0.0 ? this.lastMousePoint.y : this.lastMousePoint.y + (int)deltaY;
                    HeatmapPanel.this.zoomRectangle = new Rectangle(x, y, (int)Math.abs(deltaX), (int)Math.abs(deltaY));
                    Rectangle damageRect = lastRectangle == null ? HeatmapPanel.this.zoomRectangle : HeatmapPanel.this.zoomRectangle.union(lastRectangle);
                    --damageRect.x;
                    --damageRect.y;
                    damageRect.width += 2;
                    damageRect.height += 2;
                    HeatmapPanel.this.paintImmediately(damageRect);
                    break;
                }
                default: {
                    int dx = (int)(deltaX * ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getScale());
                    int dy = (int)(deltaY * ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getScale());
                    this.lastMousePoint = e.getPoint();
                    HeatmapPanel.this.hic.moveBy(-dx, -dy);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                if (HeatmapPanel.this.hic.isWholeGenome()) {
                    double xGenome = ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(e.getX());
                    double yGenome = ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(e.getY());
                    Chromosome xChrom = null;
                    Chromosome yChrom = null;
                    for (int i = 0; i < HeatmapPanel.this.chromosomeBoundaries.length; ++i) {
                        if (xChrom == null && (double)HeatmapPanel.this.chromosomeBoundaries[i] > xGenome) {
                            xChrom = HeatmapPanel.this.hic.getChromosomes()[i + 1];
                        }
                        if (yChrom == null && (double)HeatmapPanel.this.chromosomeBoundaries[i] > yGenome) {
                            yChrom = HeatmapPanel.this.hic.getChromosomes()[i + 1];
                        }
                        if (xChrom == null || yChrom == null) continue;
                        HeatmapPanel.this.mainWindow.setSelectedChromosomes(xChrom, yChrom);
                    }
                } else if (e.getClickCount() > 1) {
                    int currentZoom = ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getZoom();
                    int newZoom = e.isAltDown() ? Math.max(currentZoom - 1, 1) : Math.min(11, currentZoom + 1);
                    int centerLocationX = (int)((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(e.getX());
                    int centerLocationY = (int)((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(e.getY());
                    HeatmapPanel.this.hic.setZoom(newZoom, centerLocationX, centerLocationY, true);
                } else if (e.isShiftDown()) {
                    String chr1 = ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosome().getName();
                    int leftX = (int)((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(0);
                    int wX = (int)(((HeatmapPanel)HeatmapPanel.this).hic.xContext.getScale() * (double)HeatmapPanel.this.getWidth());
                    int rightX = leftX + wX;
                    String chr2 = ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosome().getName();
                    int leftY = (int)((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(0);
                    int wY = (int)(((HeatmapPanel)HeatmapPanel.this).hic.xContext.getScale() * (double)HeatmapPanel.this.getHeight());
                    int rightY = leftY + wY;
                    String locus1 = "chr" + chr1 + ":" + leftX + "-" + rightX;
                    String locus2 = "chr" + chr2 + ":" + leftY + "-" + rightY;
                    IGVUtils.sendToIGV(locus1, locus2);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (((HeatmapPanel)HeatmapPanel.this).hic.xContext != null && ((HeatmapPanel)HeatmapPanel.this).hic.zd != null) {
                if (HeatmapPanel.this.hic.isWholeGenome()) {
                    double xGenome = ((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(e.getX());
                    double yGenome = ((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(e.getY());
                    Chromosome xChrom = null;
                    Chromosome yChrom = null;
                    for (int i = 0; i < HeatmapPanel.this.chromosomeBoundaries.length; ++i) {
                        if (xChrom == null && (double)HeatmapPanel.this.chromosomeBoundaries[i] > xGenome) {
                            xChrom = HeatmapPanel.this.hic.getChromosomes()[i + 1];
                        }
                        if (yChrom == null && (double)HeatmapPanel.this.chromosomeBoundaries[i] > yGenome) {
                            yChrom = HeatmapPanel.this.hic.getChromosomes()[i + 1];
                        }
                        if (xChrom == null || yChrom == null) continue;
                        int leftBoundaryX = xChrom.getIndex() == 1 ? 0 : HeatmapPanel.this.chromosomeBoundaries[xChrom.getIndex() - 2];
                        int leftBoundaryY = yChrom.getIndex() == 1 ? 0 : HeatmapPanel.this.chromosomeBoundaries[yChrom.getIndex() - 2];
                        int xChromPos = (int)((xGenome - (double)leftBoundaryX) * 1000.0);
                        int yChromPos = (int)((yGenome - (double)leftBoundaryY) * 1000.0);
                        StringBuffer txt = new StringBuffer();
                        txt.append("<html>");
                        txt.append(yChrom.getName());
                        txt.append(":");
                        txt.append(String.valueOf(yChromPos));
                        txt.append("<br>");
                        txt.append(xChrom.getName());
                        txt.append(":");
                        txt.append(String.valueOf(xChromPos));
                        HeatmapPanel.this.setToolTipText(txt.toString());
                        return;
                    }
                } else {
                    int posX = (int)((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosomePosition(e.getX());
                    int posY = (int)((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosomePosition(e.getY());
                    StringBuffer txt = new StringBuffer();
                    txt.append("<html>");
                    txt.append(((HeatmapPanel)HeatmapPanel.this).hic.xContext.getChromosome().getName());
                    txt.append(":");
                    txt.append(String.valueOf(posX));
                    txt.append("<br>");
                    txt.append(((HeatmapPanel)HeatmapPanel.this).hic.yContext.getChromosome().getName());
                    txt.append(":");
                    txt.append(String.valueOf(posY));
                    HeatmapPanel.this.setToolTipText(txt.toString());
                }
            }
        }
    }

    static class ImageTile {
        int bLeft;
        int bTop;
        Image image;

        ImageTile(Image image, int bLeft, int py0) {
            this.bLeft = bLeft;
            this.bTop = py0;
            this.image = image;
        }
    }

    static enum DragMode {
        NONE,
        PAN,
        ZOOM;

    }
}

