/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFTile;

public class MAFLocalReader
implements MAFReader {
    private static Logger log = Logger.getLogger(MAFLocalReader.class);
    public static String mafFile;
    MAFIO mafIO;
    List<String> sequenceIds;

    public MAFLocalReader(String mafFileName) throws IOException, ParseException {
        mafFile = mafFileName;
        this.mafIO = new MAFIO(mafFile, false);
    }

    @Override
    public List<String> getChrNames() {
        return this.sequenceIds;
    }

    @Override
    public MAFTile loadTile(String seq, int start, int end, List<String> species) {
        try {
            MAFAlignment maf = this.mafIO.load(species, start, end);
            if (maf.isEmpty()) {
                return null;
            }
            MultipleAlignment.AlignedSequence refSeq = maf.getAlignedSequences().get(0);
            int[] gapAdjustedCoordinates = new int[end - start];
            for (int i = start; i < end; ++i) {
                int idx = i - start;
                gapAdjustedCoordinates[idx] = refSeq.getGapAdjustedCoordinate(idx);
            }
            HashMap<String, String> bases = new HashMap<String, String>();
            for (String seqId : maf.getAlignedSequenceIds()) {
                bases.put(seqId, maf.getAlignedSequence(seqId).getSequenceBases());
            }
            return new MAFTile(start, end, bases, gapAdjustedCoordinates, refSeq.getId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.mafIO.destroyFileHandle();
    }
}

