/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.hic.HiCGlobals;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.AsciiPairIterator;
import org.broad.igv.hic.tools.BinPairIterator;
import org.broad.igv.hic.tools.DensityCalculation;
import org.broad.igv.hic.tools.HiCTools;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class DensityUtil {
    private static Logger log = Logger.getLogger(DensityCalculation.class);

    public static void main(String[] args) throws IOException {
        String genomeID = "b37";
        List<Chromosome> chromosomes = HiCTools.loadChromosomes(genomeID);
        DensityUtil.calculate(chromosomes);
        DensityUtil.read("/xchip/igv/dev/hic/testFiles/test.hic.densities");
    }

    private static void dumpDensities(String path, int zoomNumber, int chr) throws IOException {
        InputStream is = ParsingUtils.openInputStream(path);
        Map<Integer, DensityFunction> d = DensityUtil.readDensities(is);
        DensityFunction df = d.get(zoomNumber);
        if (df != null) {
            for (int b = 0; b < 250; ++b) {
                System.out.println(df.getDensity(chr, b));
            }
        }
        is.close();
    }

    private static Map<Integer, DensityFunction> read(String ifile) throws IOException {
        InputStream is = ParsingUtils.openInputStream(ifile);
        return DensityUtil.readDensities(is);
    }

    private static void calculate(List<Chromosome> chromosomes) throws IOException {
        String[] paths = new String[]{"/xchip/igv/dev/hic/testFiles/GSM455139_428EGAAXX.7.maq.hic.summary.binned.txt", "/xchip/igv/dev/hic/testFiles/GSM455140_428EGAAXX.8.maq.hic.summary.binned.txt"};
        HashMap<String, Integer> chrIndexMap = new HashMap<String, Integer>();
        for (Chromosome chr : chromosomes) {
            if (chr == null || chr.getIndex() <= 0) continue;
            chrIndexMap.put(chr.getName(), chr.getIndex());
        }
        int[] gridSizeArray = new int[8];
        for (int i = 0; i < 8; ++i) {
            gridSizeArray[i] = HiCGlobals.zoomBinSizes[i];
        }
        DensityCalculation[] calcs = new DensityCalculation[gridSizeArray.length];
        for (int z = 0; z < gridSizeArray.length; ++z) {
            calcs[z] = new DensityCalculation(chromosomes, gridSizeArray[z]);
        }
        for (String path : paths) {
            PairIterator iter;
            PairIterator pairIterator = iter = path.endsWith(".bin") ? new BinPairIterator(path) : new AsciiPairIterator(path, chrIndexMap);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                if (pair.getChr1() != pair.getChr2()) continue;
                int dist = Math.abs(pair.getPos1() - pair.getPos2());
                int index = pair.getChr1();
                for (int z = 0; z < gridSizeArray.length; ++z) {
                    calcs[z].addDistance(index, dist);
                }
            }
        }
        for (int z = 0; z < gridSizeArray.length; ++z) {
            calcs[z].computeDensity();
        }
        DensityUtil.outputDensities(calcs, new File("/xchip/igv/dev/hic/testFiles/HindIII_Human_August.densities"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputDensities(DensityCalculation[] calcs, File outputFile) throws IOException {
        FilterOutputStream os = null;
        try {
            os = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            ((LittleEndianOutputStream)os).writeInt(calcs.length);
            for (int i = 0; i < calcs.length; ++i) {
                calcs[i].outputBinary((LittleEndianOutputStream)os);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static Map<Integer, DensityFunction> readDensities(InputStream is) throws IOException {
        LittleEndianInputStream les = new LittleEndianInputStream(new BufferedInputStream(is));
        int nZooms = les.readInt();
        HashMap<Integer, DensityFunction> densityMap = new HashMap<Integer, DensityFunction>();
        for (int i = 0; i < nZooms; ++i) {
            DensityCalculation calc = new DensityCalculation(les);
            densityMap.put(i, new DensityFunction(calc));
        }
        return densityMap;
    }
}

