/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.util.Map;
import javax.swing.JOptionPane;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.HiCGlobals;
import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.Dataset;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;

public class HiC {
    MainWindow mainWindow;
    MainWindow.DisplayOption displayOption;
    Dataset dataset;
    Context xContext;
    Context yContext;
    Matrix matrix;
    MatrixZoomData zd;
    private Chromosome[] chromosomes;
    Map<Integer, DensityFunction> zoomToDensityMap = null;

    public HiC(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public MainWindow.DisplayOption getDisplayOption() {
        return this.displayOption;
    }

    public boolean isWholeGenome() {
        return this.xContext != null && this.xContext.getChromosome().getName().equals("All");
    }

    public void reset() {
        this.matrix = null;
        this.zd = null;
    }

    public void setChromosomes(Chromosome[] chromosomes) {
        this.chromosomes = chromosomes;
    }

    public Chromosome[] getChromosomes() {
        return this.chromosomes;
    }

    public void setZoomToDensityMap(Map<Integer, DensityFunction> zoomToDensityMap) {
        this.zoomToDensityMap = zoomToDensityMap;
    }

    public Map<Integer, DensityFunction> getZoomToDensityMap() {
        return this.zoomToDensityMap;
    }

    public DensityFunction getDensityFunction() {
        return this.zd == null || this.zoomToDensityMap == null ? null : this.zoomToDensityMap.get(this.zd.getZoom());
    }

    public DensityFunction getDensityFunction(int zoom) {
        return this.zoomToDensityMap == null ? null : this.zoomToDensityMap.get(zoom);
    }

    public void setZoom(int newZoom, final int centerLocationX, final int centerLocationY, boolean updateSlider) {
        if (newZoom < 0 || newZoom > MainWindow.MAX_ZOOM) {
            return;
        }
        Chromosome chr1 = this.xContext.getChromosome();
        Chromosome chr2 = this.yContext.getChromosome();
        final MatrixZoomData newZD = this.dataset.getMatrix(chr1, chr2).getObservedMatrix(newZoom);
        if (this.displayOption == MainWindow.DisplayOption.PEARSON && newZD.getPearsons() == null) {
            int ans;
            if (newZoom > 3 && (ans = JOptionPane.showConfirmDialog(this.mainWindow, "Pearson's calculation at this zoom will take a while.\nAre you sure you want to proceed?", "Confirm calculation", 0)) == 1) {
                this.mainWindow.updateZoom(this.zd.getZoom());
                return;
            }
            final DensityFunction df = this.getDensityFunction(newZoom);
            Runnable callable = new Runnable(){

                @Override
                public void run() {
                    newZD.computePearsons(df);
                    HiC.this.mainWindow.refresh();
                    HiC.this.updateState2(newZD, centerLocationX, centerLocationY);
                }
            };
            this.mainWindow.executeLongRunningTask(callable);
        } else {
            this.updateState2(newZD, centerLocationX, centerLocationY);
        }
    }

    private void updateState2(MatrixZoomData newZD, double centerLocationX, double centerLocationY) {
        this.zd = newZD;
        int newZoom = this.zd.getZoom();
        int newBinSize = this.zd.getBinSize();
        double xScaleMax = (double)this.xContext.getChrLength() / (double)this.mainWindow.getHeatmapPanel().getWidth();
        double yScaleMax = (double)this.yContext.getChrLength() / (double)this.mainWindow.getWidth();
        double scaleMax = Math.max(xScaleMax, yScaleMax);
        double scale = Math.min((double)newBinSize, scaleMax);
        this.xContext.setZoom(newZoom, scale);
        this.yContext.setZoom(newZoom, scale);
        this.center((int)centerLocationX, (int)centerLocationY);
        this.mainWindow.updateZoom(newZoom);
        this.mainWindow.refresh();
    }

    public void zoomTo(final double xBP, final double yBP, final double scale) {
        int newZoom = HiCGlobals.zoomBinSizes.length - 1;
        for (int z = 1; z < HiCGlobals.zoomBinSizes.length; ++z) {
            if (!((double)HiCGlobals.zoomBinSizes[z] < scale)) continue;
            newZoom = z - 1;
            break;
        }
        Chromosome chr1 = this.xContext.getChromosome();
        Chromosome chr2 = this.yContext.getChromosome();
        final MatrixZoomData newZD = this.dataset.getMatrix(chr1, chr2).getObservedMatrix(newZoom);
        if (this.displayOption == MainWindow.DisplayOption.PEARSON && newZD.getPearsons() == null) {
            int ans;
            if (newZoom > 3 && (ans = JOptionPane.showConfirmDialog(this.mainWindow, "Pearson's calculation at this zoom will take a while.\nAre you sure you want to proceed?", "Confirm calculation", 0)) == 1) {
                return;
            }
            final DensityFunction df = this.getDensityFunction(newZoom);
            Runnable callable = new Runnable(){

                @Override
                public void run() {
                    newZD.computePearsons(df);
                    HiC.this.mainWindow.refresh();
                    HiC.this.updateState(newZD, scale, xBP, yBP);
                }
            };
            this.mainWindow.executeLongRunningTask(callable);
        } else {
            this.updateState(newZD, scale, xBP, yBP);
        }
    }

    private void updateState(MatrixZoomData newZD, double scale, double xBP, double yBP) {
        this.zd = newZD;
        this.xContext.setZoom(this.zd.getZoom(), scale);
        this.yContext.setZoom(this.zd.getZoom(), scale);
        this.xContext.setOrigin((int)xBP);
        this.yContext.setOrigin((int)yBP);
        this.mainWindow.updateZoom(this.zd.getZoom());
        this.mainWindow.refresh();
    }

    public void center(int centerLocationX, int centerLocationY) {
        double w = (double)this.mainWindow.getHeatmapPanel().getWidth() * this.xContext.getScale();
        int newX = (int)((double)centerLocationX - w / 2.0);
        double h = (double)this.mainWindow.getHeatmapPanel().getHeight() * this.yContext.getScale();
        int newY = (int)((double)centerLocationY - h / 2.0);
        this.moveTo(newX, newY);
    }

    public void moveBy(int dx, int dy) {
        int newX = this.xContext.getOrigin() + dx;
        int newY = this.yContext.getOrigin() + dy;
        this.moveTo(newX, newY);
    }

    private void moveTo(int newX, int newY) {
        double bpWidthX = this.xContext.getScale() * (double)this.mainWindow.getHeatmapPanel().getWidth();
        int maxX = (int)((double)this.xContext.getChrLength() - bpWidthX);
        double bpWidthY = this.yContext.getScale() * (double)this.mainWindow.getHeatmapPanel().getHeight();
        int maxY = (int)((double)this.yContext.getChrLength() - bpWidthY);
        int x = Math.max(0, Math.min(maxX, newX));
        int y = Math.max(0, Math.min(maxY, newY));
        this.xContext.setOrigin(x);
        this.yContext.setOrigin(y);
        this.mainWindow.repaint();
    }

    public void setDisplayOption(MainWindow.DisplayOption newDisplay) {
        if (this.displayOption != newDisplay) {
            if (newDisplay == MainWindow.DisplayOption.PEARSON && this.zd.getPearsons() == null) {
                int ans;
                if (this.zd.getZoom() > 3 && (ans = JOptionPane.showConfirmDialog(this.mainWindow, "Pearson's calculation at this zoom will take a while.\nAre you sure you want to proceed?", "Confirm calculation", 0)) == 1) {
                    return;
                }
                this.displayOption = newDisplay;
                final DensityFunction df = this.getDensityFunction(this.zd.getZoom());
                Runnable callable = new Runnable(){

                    @Override
                    public void run() {
                        HiC.this.zd.computePearsons(df);
                        HiC.this.mainWindow.refresh();
                    }
                };
                this.mainWindow.executeLongRunningTask(callable);
                return;
            }
            this.displayOption = newDisplay;
            this.mainWindow.refresh();
        }
    }

    public double[] getEigenvector(final int n) {
        DensityFunction df;
        if (this.zd == null) {
            return null;
        }
        double[] eigenvector = this.zd.getEigenvector();
        if (eigenvector == null && (df = this.getDensityFunction()) != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (HiC.this.zd.getZoom() > 3) {
                        String str = "Eigenvector calculation requires Pearson's correlation matrix.\n";
                        str = str + "At this zoom, calculation might take a while.\n";
                        int ans = JOptionPane.showConfirmDialog(HiC.this.mainWindow, str = str + "Are you sure you want to proceed?", "Confirm calculation", 0);
                        if (ans == 1) {
                            return;
                        }
                    }
                    double[] eigenvector = HiC.this.zd.computeEigenvector(df, n);
                    HiC.this.mainWindow.updateEigenvectorTrack(eigenvector, HiC.this.zd.getBinSize());
                }
            };
            this.mainWindow.executeLongRunningTask(runnable);
        }
        return eigenvector;
    }
}

