/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

public class TristateCheckBoxIcon
implements Icon,
SynthConstants {
    private UIDefaults.LazyValue _originalIcon;
    private static Map<String, Boolean> _synthIconMap;

    public TristateCheckBoxIcon(UIDefaults.LazyValue lazyValue) {
        this._originalIcon = lazyValue;
    }

    protected boolean isSynthIconClassName(String string) {
        return string != null && string.contains("sun.swing.plaf.synth.SynthIcon");
    }

    private boolean isSynthIcon(Icon icon) {
        if (_synthIconMap == null) {
            _synthIconMap = new HashMap<String, Boolean>();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        for (Class<?> clazz = icon.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String string = clazz.getCanonicalName();
            if (string == null) continue;
            Object object = _synthIconMap.get(string);
            if (object != null) {
                return (Boolean)object;
            }
            arrayList.add(string);
            if (!this.isSynthIconClassName(string)) continue;
            bl = true;
            break;
        }
        for (Object object : arrayList) {
            _synthIconMap.put((String)object, bl);
        }
        return bl;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        if (this.isSynthIcon(icon)) {
            int n3 = this.getComponentState((JComponent)component);
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                n3 &= 0xFFFFFDFF;
            }
            SynthContext synthContext = new SynthContext((JComponent)component, Region.CHECK_BOX, SynthLookAndFeel.getStyle((JComponent)component, Region.CHECK_BOX), n3);
            int n4 = ((SynthIcon)icon).getIconWidth(synthContext);
            int n5 = ((SynthIcon)icon).getIconHeight(synthContext);
            ((SynthIcon)icon).paintIcon(synthContext, graphics, n, n2, n4, n5);
        } else {
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)component).getModel()).internalSetSelected(false);
            }
            icon.paintIcon(component, graphics, n, n2);
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)component).getModel()).internalSetSelected(true);
            }
        }
        graphics.setColor(UIManager.getColor("CheckBox.foreground"));
        if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
            this.drawSquare(component, graphics, n, n2);
        }
    }

    private int getComponentState(JComponent jComponent) {
        AbstractButton abstractButton;
        ButtonModel buttonModel;
        int n = 1;
        if (!jComponent.isEnabled()) {
            n = 8;
        }
        if ((buttonModel = (abstractButton = (AbstractButton)jComponent).getModel()).isPressed()) {
            n = buttonModel.isArmed() ? 4 : 2;
        }
        if (buttonModel.isRollover()) {
            n |= 2;
        }
        if (buttonModel.isSelected()) {
            n |= 0x200;
        }
        if (jComponent.isFocusOwner() && abstractButton.isFocusPainted()) {
            n |= 0x100;
        }
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
            n |= 0x400;
        }
        return n;
    }

    public int getIconWidth() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconWidth();
    }

    public int getIconHeight() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconHeight();
    }

    protected void drawSquare(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        int n5 = n3 / 3;
        graphics.fillRect(n + n5, n2 + n5, n3 - n5 * 2, n4 - n5 * 2);
    }
}

