/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.affective;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.broad.igv.dev.affective.AffectiveUtils;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.tools.parsers.UnsortedException;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

public class AffectiveLogParser {
    static int CHR_SAMPLING_RATE = 8;
    static int CHR_START_TIME = AffectiveUtils.START_TIME_HR * 60 * 60;
    DataConsumer dataConsumer;
    File root;
    Pattern commaPattern = Pattern.compile(",");

    public AffectiveLogParser(String file, DataConsumer dataConsumer) {
        this.root = new File(file);
        this.dataConsumer = dataConsumer;
    }

    public void parse() throws IOException {
        if (this.root.isDirectory()) {
            File[] files = this.root.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getName().compareTo(file1.getName());
                }
            });
            for (File f : files) {
                if (!f.getName().endsWith(".csv")) continue;
                System.out.println(f);
                this.parseFile(f);
            }
        } else {
            this.parseFile(this.root);
        }
        this.dataConsumer.parsingComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file) throws IOException {
        BufferedReader br = null;
        try {
            String nextLine;
            int startOffset;
            br = ParsingUtils.openBufferedReader(file.getAbsolutePath());
            Header header = this.parseHeader(br);
            String chrName = header.getStartDate();
            String[] trackNames = header.getTrackNames();
            this.dataConsumer.setTrackParameters(TrackType.AFFECTIVE, null, trackNames, false);
            String prefix = "ATTR:" + chrName + ":";
            this.dataConsumer.setAttribute(prefix + "uuid", header.getUuid());
            this.dataConsumer.setAttribute(prefix + "samplingRate", String.valueOf(header.getSamplingRate()));
            this.dataConsumer.setAttribute(prefix + "startTime", String.valueOf(CHR_START_TIME));
            int stepSize = (int)(Math.round((double)CHR_SAMPLING_RATE) / (long)header.getSamplingRate());
            int startTime = startOffset = (header.getStartTime() - CHR_START_TIME) * CHR_SAMPLING_RATE;
            while ((nextLine = br.readLine()) != null) {
                block14: {
                    try {
                        String[] tokens = this.commaPattern.split(nextLine);
                        if (tokens.length == trackNames.length) {
                            float[] values = new float[tokens.length];
                            for (int i = 0; i < tokens.length; ++i) {
                                float v;
                                try {
                                    v = Float.parseFloat(tokens[i]);
                                    if (i < 3) {
                                        v = Math.abs(v);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    v = Float.NaN;
                                }
                                values[i] = v;
                            }
                            try {
                                this.dataConsumer.addData(chrName, startTime, startTime + stepSize, values, null);
                            }
                            catch (UnsortedException e) {}
                            break block14;
                        }
                        System.out.println("Skipping line: " + nextLine);
                    }
                    catch (Exception e) {
                        System.out.println(nextLine);
                        e.printStackTrace();
                    }
                }
                startTime += stepSize;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    Header parseHeader(BufferedReader reader) throws IOException {
        String nextLine;
        Header header = new Header();
        while ((nextLine = reader.readLine()) != null) {
            String[] tokens;
            if (nextLine.startsWith("UUID:")) {
                tokens = nextLine.split("\\s+");
                if (tokens.length <= 1) continue;
                header.uuid = tokens[1];
                continue;
            }
            if (nextLine.startsWith("Sampling Rate:")) {
                tokens = nextLine.split("\\s+");
                if (tokens.length <= 2) continue;
                header.samplingRate = Integer.parseInt(tokens[2]);
                continue;
            }
            if (nextLine.startsWith("Start Time:")) {
                tokens = nextLine.split("\\s+");
                if (tokens.length <= 2) continue;
                header.startDate = tokens[2];
                String timeString = tokens[3];
                String[] hms = timeString.split(":");
                int hour = Integer.parseInt(hms[0]);
                int minute = Integer.parseInt(hms[1]);
                int second = Integer.parseInt(hms[2]);
                header.startTime = (hour * 60 + minute) * 60 + second;
                String headerLine = reader.readLine();
                String[] trackNames = headerLine.split("\\|");
                for (int i = 0; i < trackNames.length; ++i) {
                    trackNames[i] = trackNames[i].trim();
                }
                Header.access$402(header, trackNames);
                continue;
            }
            if (!nextLine.startsWith("------")) continue;
            break;
        }
        return header;
    }

    static class Header {
        private String uuid;
        private int samplingRate;
        private String startDate;
        private int startTime;
        private String[] trackNames;

        Header() {
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public int getStartTime() {
            return this.startTime;
        }

        public String[] getTrackNames() {
            return this.trackNames;
        }

        public int getSamplingRate() {
            return this.samplingRate;
        }

        static /* synthetic */ String[] access$402(Header x0, String[] x1) {
            x0.trackNames = x1;
            return x1;
        }
    }
}

