/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.util.List;
import org.broad.igv.feature.Locus;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RenderContextImpl;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class Preloader {
    public static synchronized void preload() {
        List<Track> trackList = IGV.getInstance().getAllTracks(true);
        int flankingRegion = 1;
        String genomeId = IGV.getInstance().getGenomeManager().getGenomeId();
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            Locus locus = frame.getInitialLocus();
            if (locus == null) continue;
            for (Track track : trackList) {
                if (track == null || !track.isVisible() || !(track instanceof DataTrack)) continue;
                DataTrack dt = (DataTrack)track;
                RenderContextImpl context = new RenderContextImpl(genomeId, null, null, frame, null);
                int start = Math.max(0, locus.getStart() - flankingRegion);
                int end = locus.getEnd() + flankingRegion;
                dt.load(context, locus.getChr(), start, end, frame.getZoom());
            }
        }
    }
}

