/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.MutationTrack;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;

public class MutationParser {
    private static Logger log = Logger.getLogger(MutationParser.class);
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private int sampleColumn;
    private int typeColumn;
    private int refAlleleColumn;
    private int tumorAllele1Column;
    private int tumorAllele2Column;

    public static boolean isMutationAnnotationFile(ResourceLocator locator) throws IOException {
        AsciiLineReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openAsciiReader(locator);
            if (reader == null) {
                boolean bl = false;
                return bl;
            }
            while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#version")) continue;
                boolean bl = true;
                return bl;
            }
            if (nextLine == null) {
                boolean bl = false;
                return bl;
            }
            String[] tokens = nextLine.split("\t");
            boolean bl = tokens.length > 15 && tokens[0].equalsIgnoreCase("Hugo_Symbol");
            return bl;
        }
        catch (Exception e) {
            log.error("", e);
            throw new DataLoadException("Error checking for MAF file type: " + e.toString(), locator.getPath());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public List<FeatureTrack> loadMutationTracks(ResourceLocator locator, Genome genome) {
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        Map<String, List<Feature>> features = this.loadMutations(locator, genome);
        for (String sampleId : features.keySet()) {
            String id = locator.getPath() + "_" + sampleId;
            MutationTrack track = new MutationTrack(locator, id, (FeatureSource)new FeatureCollectionSource((Iterable<Feature>)features.get(sampleId), genome));
            track.setSquishedRowHeight(5);
            track.setExpandedRowHeight(15);
            track.setHeight(15);
            track.setName(sampleId);
            track.setMinimumHeight(0);
            tracks.add(track);
        }
        return tracks;
    }

    private Map<String, List<Feature>> loadMutations(ResourceLocator locator, Genome genome) {
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            LinkedHashMap<String, List<Feature>> mutationMap = new LinkedHashMap<String, List<Feature>>();
            reader = ParsingUtils.openAsciiReader(locator);
            String[] headers = null;
            int lineNumber = 1;
            boolean isMAF = false;
            while ((nextLine = reader.readLine()) != null) {
                ArrayList<Mutation> features;
                int end;
                int start;
                String[] tokens;
                ++lineNumber;
                if (nextLine.startsWith("#") || (tokens = nextLine.split("\t")).length <= 4) continue;
                if (headers == null) {
                    headers = tokens;
                    isMAF = headers.length > 15 && headers[0].equalsIgnoreCase("Hugo_Symbol");
                    this.setColumns(headers, isMAF);
                    continue;
                }
                String chr = genome.getChromosomeAlias(tokens[this.chrColumn].trim());
                try {
                    start = Integer.parseInt(tokens[this.startColumn].trim());
                    if (isMAF) {
                        --start;
                    }
                }
                catch (NumberFormatException e) {
                    throw new DataLoadException("Column " + (this.startColumn + 1) + " must be a numeric value.", locator.getPath());
                }
                try {
                    end = Integer.parseInt(tokens[this.endColumn].trim());
                }
                catch (NumberFormatException e) {
                    throw new DataLoadException("Column " + (this.endColumn + 1) + " must be a numeric value.", locator.getPath());
                }
                String sampleId = tokens[this.sampleColumn].trim();
                String type = tokens[this.typeColumn];
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                int n = Math.min(headers.length, tokens.length);
                for (int i = 0; i < n; ++i) {
                    String key = headers[i];
                    String value = tokens[i];
                    if (value.length() <= 0) continue;
                    attributes.put(key, value);
                }
                Mutation mut = new Mutation(sampleId, chr, start, end, type);
                mut.setAttributes(attributes);
                if (this.refAlleleColumn > 0) {
                    mut.setRefAllele(tokens[this.refAlleleColumn].trim());
                }
                if (this.tumorAllele1Column > 0) {
                    mut.setAltAllele1(tokens[this.tumorAllele1Column].trim());
                }
                if (this.tumorAllele2Column > 0) {
                    mut.setAltAllele2(tokens[this.tumorAllele2Column].trim());
                }
                if ((features = (ArrayList<Mutation>)mutationMap.get(sampleId)) == null) {
                    features = new ArrayList<Mutation>();
                    mutationMap.put(sampleId, features);
                }
                features.add(mut);
            }
            LinkedHashMap<String, List<Feature>> linkedHashMap = mutationMap;
            return linkedHashMap;
        }
        catch (IOException e) {
            log.error("", e);
            throw new DataLoadException("IO Exception: " + e.toString(), locator.getPath());
        }
        finally {
            reader.close();
        }
    }

    private void setColumns(String[] headings, boolean isMAF) {
        if (isMAF) {
            this.chrColumn = 4;
            this.startColumn = 5;
            this.endColumn = 6;
            this.sampleColumn = 15;
            this.typeColumn = 8;
            this.refAlleleColumn = 10;
            this.tumorAllele1Column = 11;
            this.tumorAllele2Column = 12;
        } else {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.sampleColumn = 3;
            this.typeColumn = 4;
            this.refAlleleColumn = -1;
            this.tumorAllele1Column = -1;
            this.tumorAllele2Column = -1;
        }
    }
}

