/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.awt.Frame;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LoginDialog;

public class DBManager {
    private static Logger log = Logger.getLogger(DBManager.class);
    static Collection<ConnectionWrapper> connectionPool = Collections.synchronizedCollection(new ArrayList());
    static String username;
    static String password;

    public static Connection getConnection() {
        ConnectionWrapper conn;
        Iterator<ConnectionWrapper> poolIter = connectionPool.iterator();
        while (poolIter.hasNext()) {
            conn = poolIter.next();
            try {
                if (conn == null || conn.isReallyClosed()) {
                    poolIter.remove();
                    continue;
                }
                if (conn.isClosed()) continue;
                return conn;
            }
            catch (SQLException e) {
                log.error("Bad connection", e);
                poolIter.remove();
            }
        }
        conn = DBManager.createConnection();
        if (conn != null) {
            connectionPool.add(conn);
            log.info("Connection pool size: " + connectionPool.size());
        }
        return conn;
    }

    private static ConnectionWrapper createConnection() {
        String driver = "com.mysql.jdbc.Driver";
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreferenceManager preferenceManager = PreferenceManager.getInstance();
        String host = preferenceManager.get("DB_HOST");
        String db = preferenceManager.get("DB_NAME");
        String port = preferenceManager.get("DB_PORT");
        String url = "jdbc:mysql://" + host;
        if (!port.equals("-1")) {
            url = url + ":" + port;
        }
        url = url + "/" + db;
        return DBManager.connect(url);
    }

    private static ConnectionWrapper connect(String url) {
        try {
            return new ConnectionWrapper(DriverManager.getConnection(url, username, password));
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 1044 || errorCode == 1045) {
                String host = PreferenceManager.getInstance().get("DB_HOST");
                Frame parent = Globals.isHeadless() ? null : IGV.getMainFrame();
                LoginDialog dlg = new LoginDialog(parent, false, host, false);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    throw new RuntimeException("Must login to access" + host);
                }
                username = dlg.getUsername();
                password = new String(dlg.getPassword());
                return DBManager.connect(url);
            }
            MessageUtils.showMessage("<html>Error connecting to database: <br>" + e.getMessage());
            return null;
        }
    }

    public static void shutdown() {
        for (ConnectionWrapper conn : connectionPool) {
            if (conn == null) continue;
            try {
                conn.reallyClose();
            }
            catch (SQLException sQLException) {}
        }
        connectionPool.clear();
    }

    static class ConnectionWrapper
    implements Connection {
        Connection conn;
        boolean closed;

        ConnectionWrapper(Connection conn) {
            this.conn = conn;
            this.closed = false;
        }

        @Override
        public void close() throws SQLException {
            this.closed = true;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed;
        }

        public void reallyClose() throws SQLException {
            this.closed = true;
            this.conn.close();
        }

        public boolean isReallyClosed() throws SQLException {
            return this.conn.isClosed();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.conn.clearWarnings();
        }

        @Override
        public void commit() throws SQLException {
            this.conn.commit();
        }

        @Override
        public Array createArrayOf(String s, Object[] objects) throws SQLException {
            return this.conn.createArrayOf(s, objects);
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.conn.createBlob();
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.conn.createClob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.conn.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.conn.createSQLXML();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.conn.createStatement();
        }

        @Override
        public Statement createStatement(int i, int i1) throws SQLException {
            return this.conn.createStatement(i, i1);
        }

        @Override
        public Statement createStatement(int i, int i1, int i2) throws SQLException {
            return this.conn.createStatement(i, i1, i2);
        }

        @Override
        public Struct createStruct(String s, Object[] objects) throws SQLException {
            return this.conn.createStruct(s, objects);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            throw new UnsupportedOperationException("Operation not supported for backwards compatibility to Java 6");
        }

        @Override
        public String getSchema() throws SQLException {
            return null;
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            throw new UnsupportedOperationException("Operation not supported for backwards compatibility to Java 6");
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            throw new UnsupportedOperationException("Operation not supported for backwards compatibility to Java 6");
        }

        @Override
        public int getNetworkTimeout() {
            return -1;
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.conn.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.conn.getCatalog();
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.conn.getClientInfo();
        }

        @Override
        public String getClientInfo(String s) throws SQLException {
            return this.conn.getClientInfo(s);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.conn.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.conn.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.conn.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.conn.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.conn.getWarnings();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.conn.isReadOnly();
        }

        @Override
        public boolean isValid(int i) throws SQLException {
            return this.conn.isValid(i);
        }

        @Override
        public String nativeSQL(String s) throws SQLException {
            return this.conn.nativeSQL(s);
        }

        @Override
        public CallableStatement prepareCall(String s) throws SQLException {
            return this.conn.prepareCall(s);
        }

        @Override
        public CallableStatement prepareCall(String s, int i, int i1) throws SQLException {
            return this.conn.prepareCall(s, i, i1);
        }

        @Override
        public CallableStatement prepareCall(String s, int i, int i1, int i2) throws SQLException {
            return this.conn.prepareCall(s, i, i1, i2);
        }

        @Override
        public PreparedStatement prepareStatement(String s) throws SQLException {
            return this.conn.prepareStatement(s);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i) throws SQLException {
            return this.conn.prepareStatement(s, i);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i, int i1) throws SQLException {
            return this.conn.prepareStatement(s, i, i1);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int i, int i1, int i2) throws SQLException {
            return this.conn.prepareStatement(s, i, i1, i2);
        }

        @Override
        public PreparedStatement prepareStatement(String s, int[] ints) throws SQLException {
            return this.conn.prepareStatement(s, ints);
        }

        @Override
        public PreparedStatement prepareStatement(String s, String[] strings) throws SQLException {
            return this.conn.prepareStatement(s, strings);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.conn.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() throws SQLException {
            this.conn.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.conn.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean b) throws SQLException {
            this.conn.setAutoCommit(b);
        }

        @Override
        public void setCatalog(String s) throws SQLException {
            this.conn.setCatalog(s);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.conn.setClientInfo(properties);
        }

        @Override
        public void setClientInfo(String s, String s1) throws SQLClientInfoException {
            this.conn.setClientInfo(s, s1);
        }

        @Override
        public void setHoldability(int i) throws SQLException {
            this.conn.setHoldability(i);
        }

        @Override
        public void setReadOnly(boolean b) throws SQLException {
            this.conn.setReadOnly(b);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.conn.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String s) throws SQLException {
            return this.conn.setSavepoint(s);
        }

        @Override
        public void setTransactionIsolation(int i) throws SQLException {
            this.conn.setTransactionIsolation(i);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
            this.conn.setTypeMap(stringClassMap);
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) throws SQLException {
            return this.conn.isWrapperFor(aClass);
        }

        @Override
        public <T> T unwrap(Class<T> tClass) throws SQLException {
            return this.conn.unwrap(tClass);
        }
    }
}

