/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.synteny;

public class SyntenyMapping {
    private String name;
    private String fromChr;
    private int fromStart;
    private int fromEnd;
    private String toChr;
    private int toStart;
    private int toEnd;
    private boolean direction;
    double scaleFactor;

    public SyntenyMapping(String name, String fromChr, int fromStart, int fromEnd, String fromDir, String toChr, int toStart, int toEnd, String toDir) {
        this.name = name;
        this.fromChr = fromChr;
        this.fromStart = fromStart;
        this.fromEnd = fromEnd;
        this.toChr = toChr;
        this.toStart = toStart;
        this.toEnd = toEnd;
        this.direction = fromDir.equals(toDir);
        this.scaleFactor = (double)(toEnd - toStart) / (double)(fromEnd - fromStart);
    }

    public double mapPosition(int fromPosition) {
        return this.direction ? (double)this.toStart + this.scaleFactor * (double)(fromPosition - this.fromStart) : (double)this.toEnd - this.scaleFactor * (double)(fromPosition - this.fromStart);
    }

    public boolean containsFromPosition(int fromPosition) {
        return fromPosition >= this.fromStart && fromPosition < this.fromEnd;
    }

    public boolean containsFromInterval(int start, int end) {
        return end >= this.fromStart && start < this.fromEnd;
    }

    public String getName() {
        return this.name;
    }

    public String getFromChr() {
        return this.fromChr;
    }

    public int getFromStart() {
        return this.fromStart;
    }

    public int getFromEnd() {
        return this.fromEnd;
    }

    public String getToChr() {
        return this.toChr;
    }

    public int getToStart() {
        return this.toStart;
    }

    public int getToEnd() {
        return this.toEnd;
    }

    public boolean getDirection() {
        return this.direction;
    }
}

