/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.util.HashMap;
import java.util.Map;
import org.broad.igv.session.Persistable;

public class DataRange
implements Persistable {
    private Type type = Type.LINEAR;
    private float minimum = 0.0f;
    private float baseline = 0.0f;
    private float maximum;
    private boolean flipAxis = false;
    private boolean drawBaseline = true;

    public DataRange(float minimum, float maximum) {
        this(minimum, minimum, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum) {
        this(minimum, baseline, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline) {
        this.minimum = minimum;
        this.baseline = baseline;
        this.maximum = maximum;
        this.drawBaseline = drawBaseline;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLog() {
        return this.type == Type.LOG;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getBaseline() {
        return this.baseline;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public boolean isFlipAxis() {
        return this.flipAxis;
    }

    public boolean isDrawBaseline() {
        return this.drawBaseline;
    }

    public void setDrawBaseline(boolean drawBaseline) {
        this.drawBaseline = drawBaseline;
    }

    @Override
    public Map<String, String> getPersistentState() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("type", this.type.toString());
        attributes.put("minimum", String.valueOf(this.minimum));
        attributes.put("baseline", String.valueOf(this.baseline));
        attributes.put("maximum", String.valueOf(this.maximum));
        attributes.put("flipAxis", String.valueOf(this.flipAxis));
        attributes.put("drawBaseline", String.valueOf(this.drawBaseline));
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> values) {
        String drawBaselineString;
        String minimumString;
        String typeString = values.get("type");
        if (typeString != null) {
            this.type = Type.valueOf(typeString);
        }
        if ((minimumString = values.get("minimum")) != null) {
            this.minimum = Float.parseFloat(minimumString);
        }
        String baselineString = values.get("baseline");
        if (typeString != null) {
            this.baseline = Float.parseFloat(baselineString);
        }
        String maximumString = values.get("maximum");
        if (typeString != null) {
            this.maximum = Float.parseFloat(maximumString);
        }
        String flipAxisString = values.get("flipAxis");
        if (typeString != null) {
            this.flipAxis = Boolean.parseBoolean(flipAxisString);
        }
        if ((drawBaselineString = values.get("drawBaseline")) != null) {
            this.drawBaseline = Boolean.parseBoolean(drawBaselineString);
        }
    }

    public static enum Type {
        LOG,
        LINEAR;

    }
}

